/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class DataDictionaryOptimized
implements DataProviderDictionary {
    private static final int NO_PATH = 1000;
    private static final int NULL_PATH = 1001;
    private static final int EMPTY_PATH = 1002;
    private static final int NULL_KEY = 1003;
    private static final int EMPTY_KEY = 1004;
    private static final long serialVersionUID = 1L;
    private final Node root;
    private final int size;

    public DataDictionaryOptimized(DataProviderDictionary other) {
        this(other.getDataProviderInfos());
    }

    public DataDictionaryOptimized(List<DataProviderInfo> data) {
        int size = 0;
        BuilderNode builderRoot = new BuilderNode(null, Collections.emptyMap());
        for (DataProviderInfo d : data) {
            String[] path = d.getFullPath().split("/");
            HashMap<DataProviderInfo.Attribute, String> att = new HashMap<DataProviderInfo.Attribute, String>();
            for (DataProviderInfo.Attribute a : d.getAttributes()) {
                att.put(a, d.getAttributeValue(a));
            }
            BuilderNode parent = builderRoot;
            for (int i = 0; i < path.length - 1; ++i) {
                String name = path[i];
                BuilderNode child = parent.children.get(name);
                if (child == null) {
                    child = new BuilderNode(name, att);
                    parent.children.put(name, child);
                    att.clear();
                } else {
                    Iterator<Map.Entry<DataProviderInfo.Attribute, String>> it = child.att.entrySet().iterator();
                    while (it.hasNext()) {
                        String newValue;
                        Map.Entry<DataProviderInfo.Attribute, String> e = it.next();
                        DataProviderInfo.Attribute key = e.getKey();
                        String oldValue = e.getValue();
                        if (Objects.equals(oldValue, newValue = (String)att.get(key))) {
                            att.remove(key);
                            continue;
                        }
                        it.remove();
                        child.children.values().forEach(node -> node.att.put(key, oldValue));
                        child.leaves.values().forEach(node -> node.att.put(key, oldValue));
                    }
                }
                parent = child;
            }
            String lastName = path[path.length - 1];
            BuilderNode leaf = new BuilderNode(lastName, att);
            if (parent.leaves.put(lastName, leaf) != null) {
                throw new RuntimeException("Duplicate path: " + d.getFullPath());
            }
            ++size;
            String p = d.getPath();
            String k = d.getKey();
            if (p == null) {
                leaf.keyFlag = 1001;
                continue;
            }
            if (p.isEmpty()) {
                leaf.keyFlag = 1002;
                continue;
            }
            if (k == null) {
                leaf.keyFlag = 1003;
                continue;
            }
            if (k.isEmpty()) {
                leaf.keyFlag = 1004;
                continue;
            }
            if (p.endsWith(k)) {
                leaf.keyFlag = k.split("/").length;
                continue;
            }
            leaf.keyFlag = -k.split("/").length;
        }
        this.tryToMergeChildren(builderRoot);
        HashMap<Map<DataProviderInfo.Attribute, String>, Map.Entry<DataProviderInfo.Attribute[], String[]>> maps = new HashMap<Map<DataProviderInfo.Attribute, String>, Map.Entry<DataProviderInfo.Attribute[], String[]>>(2048);
        this.root = this.convert(builderRoot, maps);
        this.size = size;
    }

    private void tryToMergeChildren(BuilderNode node) {
        node.hash = node.att.hashCode();
        if (node.children.isEmpty() && node.leaves.isEmpty()) {
            return;
        }
        ArrayList<Map<String, BuilderNode>> all = new ArrayList<Map<String, BuilderNode>>(2);
        all.add(node.children);
        all.add(node.leaves);
        for (Map map : all) {
            map.values().forEach(child -> {
                this.tryToMergeChildren((BuilderNode)child);
                node.hash = 97 * node.hash + child.hash;
            });
            LinkedList nodes = new LinkedList(map.values());
            while (!nodes.isEmpty()) {
                BuilderNode child1 = (BuilderNode)nodes.pollFirst();
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    BuilderNode child2 = (BuilderNode)it.next();
                    if (!child1.equals(child2)) continue;
                    child1.names.addAll(child2.names);
                    it.remove();
                    child2.names.forEach(name -> daughters.remove(name));
                }
            }
        }
    }

    private Node convert(BuilderNode builderNode, Map<Map<DataProviderInfo.Attribute, String>, Map.Entry<DataProviderInfo.Attribute[], String[]>> maps) {
        Node[] children;
        Map.Entry<Object, Object> att;
        String names = String.join((CharSequence)"+", builderNode.names);
        if (builderNode.att.isEmpty()) {
            att = new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null);
        } else {
            att = maps.get(builderNode.att);
            if (att == null) {
                int n = builderNode.att.size();
                DataProviderInfo.Attribute[] keys = new DataProviderInfo.Attribute[n];
                String[] values = new String[n];
                int i = 0;
                for (Map.Entry<DataProviderInfo.Attribute, String> e : builderNode.att.entrySet()) {
                    keys[i] = e.getKey();
                    values[i++] = e.getValue();
                }
                att = new AbstractMap.SimpleImmutableEntry<DataProviderInfo.Attribute[], String[]>(keys, values);
                maps.put(builderNode.att, att);
            }
        }
        if (builderNode.children.isEmpty() && builderNode.leaves.isEmpty()) {
            children = null;
        } else {
            children = new Node[builderNode.children.size() + builderNode.leaves.size()];
            int i = 0;
            for (BuilderNode child : builderNode.children.values()) {
                children[i++] = this.convert(child, maps);
            }
            for (BuilderNode child : builderNode.leaves.values()) {
                children[i++] = this.convert(child, maps);
            }
        }
        return new Node(names, (DataProviderInfo.Attribute[])att.getKey(), (String[])att.getValue(), children, builderNode.keyFlag);
    }

    public List<DataProviderInfo> getDataProviderInfos() {
        return new AbstractSequentialList<DataProviderInfo>(){

            @Override
            public ListIterator<DataProviderInfo> listIterator(int index) {
                if (index < 0 || index > DataDictionaryOptimized.this.size) {
                    throw new IndexOutOfBoundsException();
                }
                Iter it = new Iter();
                while (index-- > 0) {
                    it.next();
                }
                return it;
            }

            @Override
            public int size() {
                return DataDictionaryOptimized.this.size;
            }
        };
    }

    public DataProviderInfo getDataProviderInfoForPath(String path) {
        LinkedHashMap<DataProviderInfo.Attribute, String> att = new LinkedHashMap<DataProviderInfo.Attribute, String>();
        String[] ss = path.split("/");
        Node parent = this.root;
        int n = ss.length;
        for (String name : ss) {
            Node child = null;
            if (--n > 0) {
                for (Node node : parent.children) {
                    if (!node.containsName(name) || node.children == null) continue;
                    child = node;
                    break;
                }
            } else {
                int i = parent.children.length;
                while (i > 0) {
                    Node node;
                    if (!(node = parent.children[--i]).containsName(name) || node.children != null) continue;
                    child = node;
                    break;
                }
            }
            if (child == null) {
                return null;
            }
            if (child.attKeys != null) {
                for (int i = 0; i < child.attKeys.length; ++i) {
                    att.put(child.attKeys[i], child.attValues[i]);
                }
            }
            parent = child;
        }
        return DataDictionaryOptimized.makeDPI(path, parent.keyFlag, att);
    }

    @Deprecated
    public Set<String> getGroups() {
        return Collections.singleton("");
    }

    @Deprecated
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group) {
        return group == null || !group.isEmpty() ? Collections.emptyList() : this.getDataProviderInfos();
    }

    @Deprecated
    public CCSTimeStamp getCCSTimeStamp() {
        return CCSTimeStamp.currentTime();
    }

    public int size() {
        return this.size;
    }

    private static DataProviderInfo makeDPI(String fullPath, int keyFlag, Map<DataProviderInfo.Attribute, String> attributes) {
        switch (keyFlag) {
            case 1001: {
                return new DataProviderInfo(null, fullPath, attributes);
            }
            case 1002: {
                return new DataProviderInfo("", fullPath, attributes);
            }
            case 1003: {
                return new DataProviderInfo(fullPath, null, attributes);
            }
            case 1004: {
                return new DataProviderInfo(fullPath, "", attributes);
            }
            case 1000: {
                return null;
            }
        }
        List<String> ss = Arrays.asList(fullPath.split("/"));
        int n = ss.size();
        if (keyFlag == n) {
            return new DataProviderInfo(fullPath, fullPath, attributes);
        }
        if (keyFlag > 0) {
            String key = String.join((CharSequence)"/", ss.subList(n - keyFlag, n));
            return new DataProviderInfo(fullPath, key, attributes);
        }
        String path = String.join((CharSequence)"/", ss.subList(0, n + keyFlag));
        String key = String.join((CharSequence)"/", ss.subList(n + keyFlag, n));
        return new DataProviderInfo(path, key, attributes);
    }

    private static class IterNode {
        Node node;
        ArrayList<String> paths;
        Map<DataProviderInfo.Attribute, String> att;
        int childIndex;
        int pathIndex;

        private IterNode() {
        }
    }

    private class Iter
    implements ListIterator<DataProviderInfo> {
        private int nextIndex = 0;
        private final IterNode[] nodes = new IterNode[50];
        private int itNodeIndex;

        Iter() {
            IterNode itRoot = new IterNode();
            itRoot.node = DataDictionaryOptimized.this.root;
            itRoot.paths = null;
            itRoot.att = Collections.emptyMap();
            itRoot.pathIndex = -1;
            itRoot.childIndex = 0;
            this.nodes[0] = itRoot;
            this.itNodeIndex = 0;
            this.seek(true);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < DataDictionaryOptimized.this.size;
        }

        @Override
        public DataProviderInfo next() {
            if (this.nextIndex == DataDictionaryOptimized.this.size) {
                throw new NoSuchElementException("No next element");
            }
            IterNode itNode = this.nodes[this.itNodeIndex];
            DataProviderInfo out = DataDictionaryOptimized.makeDPI(itNode.paths.get(itNode.pathIndex), itNode.node.keyFlag, itNode.att);
            if (++this.nextIndex < DataDictionaryOptimized.this.size) {
                this.stepForward();
            }
            return out;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public DataProviderInfo previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException("No previous element");
            }
            if (this.nextIndex-- < DataDictionaryOptimized.this.size) {
                this.stepBack();
            }
            IterNode itNode = this.nodes[this.itNodeIndex];
            return DataDictionaryOptimized.makeDPI(itNode.paths.get(itNode.pathIndex), itNode.node.keyFlag, itNode.att);
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported by unmodifiable list.");
        }

        @Override
        public void set(DataProviderInfo e) {
            throw new UnsupportedOperationException("Not supported by unmodifiable list.");
        }

        @Override
        public void add(DataProviderInfo e) {
            throw new UnsupportedOperationException("Not supported by unmodifiable list.");
        }

        private void stepBack() {
            IterNode itNode = this.nodes[this.itNodeIndex];
            if (itNode.pathIndex-- == 0) {
                do {
                    itNode = this.nodes[--this.itNodeIndex];
                } while (itNode.childIndex <= 0);
                --itNode.childIndex;
                this.seek(false);
                return;
            }
        }

        private void stepForward() {
            IterNode itNode = this.nodes[this.itNodeIndex];
            if (++itNode.pathIndex == itNode.paths.size()) {
                do {
                    itNode = this.nodes[--this.itNodeIndex];
                } while (itNode.childIndex >= itNode.node.children.length - 1);
                ++itNode.childIndex;
                this.seek(true);
                return;
            }
        }

        private void seek(boolean forward) {
            IterNode itParent = this.nodes[this.itNodeIndex];
            Node child = itParent.node.children[itParent.childIndex];
            IterNode itChild = new IterNode();
            this.nodes[++this.itNodeIndex] = itChild;
            itChild.node = child;
            String[] names = child.names.split("\\+");
            if (itParent.paths == null) {
                itChild.paths = new ArrayList<String>(Arrays.asList(names));
            } else {
                itChild.paths = new ArrayList(itParent.paths.size() * names.length);
                for (String path : itParent.paths) {
                    for (String name : names) {
                        itChild.paths.add(path + "/" + name);
                    }
                }
            }
            itChild.att = new LinkedHashMap<DataProviderInfo.Attribute, String>(DataProviderInfo.Attribute.values().length * 2);
            itChild.att.putAll(itParent.att);
            if (child.attKeys != null) {
                for (int i = 0; i < child.attKeys.length; ++i) {
                    itChild.att.put(child.attKeys[i], child.attValues[i]);
                }
            }
            if (child.keyFlag == 1000) {
                itChild.pathIndex = -1;
                itChild.childIndex = forward ? 0 : child.children.length - 1;
                this.seek(forward);
            } else {
                itChild.pathIndex = forward ? 0 : itChild.paths.size() - 1;
                itChild.childIndex = -1;
            }
        }
    }

    private static class Node
    implements Serializable {
        final String names;
        final DataProviderInfo.Attribute[] attKeys;
        final String[] attValues;
        final Node[] children;
        final int keyFlag;

        Node(String names, DataProviderInfo.Attribute[] attKeys, String[] attValues, Node[] children, int keyFlag) {
            this.names = names;
            this.attKeys = attKeys;
            this.attValues = attValues;
            this.children = children;
            this.keyFlag = keyFlag;
        }

        boolean containsName(String name) {
            if (this.names.equals(name)) {
                return true;
            }
            return Arrays.binarySearch(this.names.split("\\+"), name) >= 0;
        }
    }

    private static class BuilderNode {
        final SortedSet<String> names = new TreeSet<String>();
        final Map<DataProviderInfo.Attribute, String> att;
        final Map<String, BuilderNode> children;
        final Map<String, BuilderNode> leaves;
        int keyFlag = 1000;
        int hash;

        BuilderNode(String name, Map<DataProviderInfo.Attribute, String> att) {
            if (name != null) {
                this.names.add(name);
            }
            this.att = new TreeMap<DataProviderInfo.Attribute, String>(att);
            this.children = new TreeMap<String, BuilderNode>();
            this.leaves = new TreeMap<String, BuilderNode>();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BuilderNode)) {
                return false;
            }
            BuilderNode other = (BuilderNode)obj;
            if (this.hash != other.hash) {
                return false;
            }
            if (this.keyFlag != other.keyFlag) {
                return false;
            }
            if (!Objects.equals(this.att, other.att)) {
                return false;
            }
            if (!Objects.equals(this.children, other.children)) {
                return false;
            }
            return Objects.equals(this.leaves, other.leaves);
        }

        public int hashCode() {
            int h = 7;
            h = 73 * h + Objects.hashCode(this.att);
            h = 73 * h + Objects.hashCode(this.children);
            h = 73 * h + Objects.hashCode(this.leaves);
            h = 73 * h + this.keyFlag;
            h = 73 * h + this.hash;
            return h;
        }
    }
}

