/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerMain;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochanger;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;

public class AutochangerTest
extends FCSTestTemplate {
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static AutochangerTwoLatches latches;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static AutochangerOnlineClamp[] clampsList;
    private static SimuAutochangerLinearRailController acTruckXminusController;
    private static SimuAutochangerLinearRailController acTruckXplusController;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF AUTOCHANGER IN STANDALONE MODE");
        System.out.println("***************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.autochanger.standalone", "true");
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"Autochanger", (String)"serialNB:<alias>,controller:defaultInitial|<alias>", (String)"autochanger-simu");
        autochangerSubsystem.startAgent();
        ((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMain)lookup.getTopComponentNode().getComponent();
        autochanger = (SimuAutochanger)lookup.getComponentByPath("autochanger");
        autochanger.updateStateWithSensors();
        acTruckXminusController = (SimuAutochangerLinearRailController)lookup.getComponentByPath("acTruckXminusController");
        acTruckXplusController = (SimuAutochangerLinearRailController)lookup.getComponentByPath("acTruckXplusController");
        trucks = (AutochangerTwoTrucks)lookup.getComponentByPath("autochangerTrucks");
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByPath("acSensorsGateway");
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        latches = (AutochangerTwoLatches)lookup.getComponentByPath("latches");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByPath("onlineClamps");
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampYminus");
        clampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus};
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.allDevicesBooted());
        onlineClampXminus.configureController();
        onlineClampXplus.configureController();
        onlineClampYminus.configureController();
        for (AutochangerOnlineClamp clamp : clampsList) {
            Assert.assertTrue((String)"After initialization phase, simulated clamps should be ready", (boolean)clamp.myDevicesReady());
        }
    }

    @Before
    public void setUp() {
        Utils.printJoliSetUp("AutochangerTest");
        System.out.println("***    autochanger empty at HANDOFF");
        System.out.println("***    latches UNLOCKED");
        System.out.println("***    ONLINE clamps OPENED");
        System.out.println("***    carousel is holding filter at STANDBY");
        System.out.println("*******************************************************");
        for (AutochangerOnlineClamp clamp : clampsList) {
            clamp.setIncrementCurrentToClose(300);
            clamp.setIncrementCurrentToOpen(300);
            clamp.setIncrementCurrentToClamp(532);
            clamp.setInitialCurrentToClose(300);
            clamp.setFinalCurrentToClose(1800);
            clamp.setCurrentToOpen(-300);
            clamp.setCurrentToClamp(4992);
        }
        System.out.println("simulateAutochangerTrucksIsAtHandoff");
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        System.out.println("simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        System.out.println("simulateAutochangerLatchesAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        System.out.println("simulateAutochangerOnlineClampsAreOpened");
        plutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isOpened());
        Assert.assertTrue((String)"ONLINE clamps are OPENED", (boolean)onlineClamps.isOpened());
        System.out.println("simulateCarouselIsHoldingFilter");
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        ((AlertService)autochangerSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
        acTruckXplusController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
    }

    @Test
    public void testSimuAutochangerLinearRailController() {
        System.out.println("****tests of SimuAutochangerLinearRailController");
        int handoffPosition = trucks.getHandoffPosition();
        Assert.assertEquals((String)"acTruckXminusController position", (long)handoffPosition, (long)acTruckXminusController.readPosition());
        int pos = 5000;
        System.out.println("acTruckXminusController: move trucks to position " + pos);
        acTruckXminusController.writeTargetPosition(pos);
        Assert.assertEquals((String)"acTruckXminusController", (long)pos, (long)acTruckXminusController.readPosition());
        trucks.updatePosition();
        Assert.assertEquals((String)"trucks position", (long)pos, (long)trucks.getPosition());
    }

    public void testOfAutochangerTrucksMotion() {
        System.out.println("************************************************");
        System.out.println("****tests of Autochanger Trucks motion");
        System.out.println("****tests of goToHandOff and isAtHandoff");
        System.out.println("trucks.goToHandOff again - should be rejected");
        try {
            trucks.goToHandOff();
        }
        catch (RejectedCommandException ex) {
            System.out.println("RejectedCommandException=" + (Object)((Object)ex));
            Assert.fail((String)"trucks already at HANDOFF - should NOT raise a RejectedCommandException - should log and do nothing.");
        }
        System.out.println("****tests of goToOnline and isAtOnlinePosition");
        trucks.goToOnline();
        Assert.assertTrue((String)"AutochangerTrucks are at ONLINE", (boolean)trucks.isAtOnline());
        try {
            trucks.goToOnline();
        }
        catch (RejectedCommandException ex) {
            System.out.println("RejectedCommandException=" + (Object)((Object)ex));
            Assert.fail((String)"trucks already at ONLINE - should NOT raise a RejectedCommandException - should log and do nothing.");
        }
        trucks.goToHandOff();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        System.out.println("****tests of goToStandby and isAtStandbyPosition");
        trucks.goToStandby();
        Assert.assertTrue((String)"AutochangerTrucks are at STANDBY", (boolean)trucks.isAtStandby());
        try {
            trucks.goToStandby();
        }
        catch (RejectedCommandException ex) {
            System.out.println("RejectedCommandException=" + (Object)((Object)ex));
            Assert.fail((String)"trucks already at STANDBY - should NOT raise a RejectedCommandException - should log and do nothing.");
        }
        System.out.println("****tests of moveToAbsoluteTargetPosition with arg=-1");
        try {
            int pos = -1;
            trucks.moveToAbsoluteTargetPosition(pos);
            Assert.fail((String)(pos + " is < minActualPositionValue - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
        System.out.println("****tests of moveToAbsoluteTargetPosition with arg=2000000");
        try {
            int pos = 2000000;
            trucks.moveToAbsoluteTargetPosition(pos);
            Assert.fail((String)(pos + " > maxActualPositionValue - should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("IllegalArgumentException=" + ex);
        }
    }

    @Test
    public void testCheckFilterSafetyBeforeMotion() {
        System.out.println("****tests of checkFilterSecurityBeforeMotion");
        System.out.println("** tests with a filter in autochanger trucks and latches LOCKED");
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger should not be empty", (boolean)autochanger.isEmpty());
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger should NOT be holding filter", (boolean)autochanger.isHoldingFilter());
        String msg = "A filter is in trucks but NOT held by autochanger. Should raise a RejectedCommandException";
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are ONLINE, latches are LOCKED and onlineClamps too. Should raise a RejectedCommandException";
        plutoGateway.simulateAutochangerTrucksAreOnline();
        trucks.updatePosition();
        plutoGateway.simulateAutochangerLatchesAreLocked();
        plutoGateway.simulateAutochangerOnlineClampsAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are ONLINE", (boolean)autochanger.getAutochangerTrucks().isAtOnline());
        Assert.assertTrue((String)"Autochanger latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Autochanger ONLINE clamps are LOCKED", (boolean)autochanger.getOnlineClamps().isLocked());
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are at STANDBY, latches are LOCKED and carousel is holding filter too. Should raise a RejectedCommandException";
        plutoGateway.simulateAutochangerTrucksAreAtStandby();
        trucks.updatePosition();
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertTrue((String)"Autochanger latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are at HANDOFF, latches are LOCKED and loader is holding filter too. Should raise a RejectedCommandException";
        plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        plutoGateway.simulateLoaderIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at HANDOFF", (boolean)autochanger.isAtHandoff());
        Assert.assertTrue((String)"Autochanger latches are LOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Loader is holding filter", (boolean)autochanger.isLoaderHoldingFilterAtHandoff());
        this.checkFilterSafetyBeforeMotionShouldFail(msg);
        msg = "Trucks are at HANDOFF, latches are UNLOCKED and loader is holding filter too. Should not raise a RejectedCommandException ";
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at HANDOFF", (boolean)autochanger.isAtHandoff());
        Assert.assertFalse((String)"Autochanger latches are UNLOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Loader is holding filter", (boolean)autochanger.isLoaderHoldingFilterAtHandoff());
        this.checkFilterSafetyBeforeMotionShouldNotFail(msg);
        msg = "Trucks are at STANDBY, latches are UNLOCKED and carousel is holding filter too. Should not raise a RejectedCommandException ";
        plutoGateway.simulateAutochangerTrucksAreAtStandby();
        trucks.updatePosition();
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are at STANDBY", (boolean)autochanger.isAtStandby());
        Assert.assertFalse((String)"Autochanger latches are UNLOCKED", (boolean)autochanger.isHoldingFilter());
        Assert.assertTrue((String)"Carousel is holding filter", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.checkFilterSafetyBeforeMotionShouldNotFail(msg);
        msg = "Trucks are at ONLINE, latches are UNLOCKED and onlineClamps are LOCKED. Should not raise a RejectedCommandException ";
        plutoGateway.simulateAutochangerTrucksAreOnline();
        trucks.updatePosition();
        plutoGateway.simulateAutochangerOnlineClampsAreLocked();
        main.updateStateWithSensors();
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger trucks are ONLINE", (boolean)autochanger.getAutochangerTrucks().isAtOnline());
        Assert.assertTrue((String)"Autochanger ONLINE clamps are LOCKED", (boolean)autochanger.getOnlineClamps().isLocked());
        Assert.assertFalse((String)"Autochanger latches are UNLOCKED", (boolean)autochanger.isHoldingFilter());
        this.checkFilterSafetyBeforeMotionShouldNotFail(msg);
    }

    private void checkFilterSafetyBeforeMotionShouldFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkFilterSafetyBeforeMotion();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
    }

    private void checkFilterSafetyBeforeMotionShouldNotFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkFilterSafetyBeforeMotion();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
    }

    public void testCheckConditionsForClosingLatches() {
        System.out.println("**** test of checkConditionsForClosingLatches ***");
        Assert.assertTrue((String)"autochanger is empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isOpened());
        if (((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).isInState((Enum)OperationalState.NORMAL)) {
            this.checkConditionsForClosingLatchesShouldFail("Trucks empty - not allowed to close latches");
        }
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isOpened());
        ((AlertService)autochangerSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        plutoGateway.simulateAutochangerTrucksAreAtStandby();
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger is NOT empty", (boolean)autochanger.isEmpty());
        this.closeLatchesShouldNotFail("A filter is in Trucks at HANDOFF - can close latches.");
        Assert.assertTrue((String)"autochanger latches are LOCKED", (boolean)latches.isClosed());
        Assert.assertFalse((String)"carousel is NOT holding filter at STANDBY", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        trucks.moveToAbsoluteTargetPosition(5000);
        if (((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).isInState((Enum)OperationalState.NORMAL)) {
            this.checkConditionsForClosingLatchesShouldFail("A filter is in Trucks but is not at STANDBY neither at HANDOFF  - not allowed to close latches");
        }
        Assert.assertTrue((String)"autochanger latches are still LOCKED", (boolean)latches.isClosed());
    }

    private void checkConditionsForClosingLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkConditionsForClosingLatches();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testCloseLatches() {
        System.out.println("**** test closeLatches ***");
        if (((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).isInState((Enum)OperationalState.NORMAL)) {
            this.closeLatchesShouldFail("trucks empty");
        }
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isOpened());
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        plutoGateway.simulateAutochangerTrucksAreAtStandby();
        trucks.updatePosition();
        Assert.assertFalse((String)"autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger is UNLOCKED", (boolean)latches.isOpened());
        this.closeLatchesShouldNotFail("trucks loaded at STANDBY");
        Assert.assertTrue((String)"autochanger is LOCKED", (boolean)latches.isClosed());
    }

    private void closeLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            latches.close();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        finally {
            ((AlertService)autochangerSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
        }
    }

    private void closeLatchesShouldNotFail(String message) {
        System.out.println(message);
        try {
            latches.close();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
        Assert.assertTrue((String)"Latches are LOCKED", (boolean)latches.isClosed());
    }

    public void testCheckConditionsForOpeningLatches() {
        System.out.println("**** test of checkConditionsForOpeningLatches ***");
        String msg = "Trucks empty - not allowed to open latches";
        System.out.println(msg);
        Assert.assertTrue((String)"autochanger is empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isOpened());
        if (((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).isInState((Enum)OperationalState.NORMAL)) {
            this.checkConditionsForOpeningLatchesShouldFail(msg);
        }
        Assert.assertTrue((String)"autochanger latches are still UNLOCKED", (boolean)latches.isOpened());
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"autochanger trucks are loaded with a filter", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isOpened());
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.checkConditionsForOpeningLatchesShouldNotFail("A filter is in Trucks at STANDBY and held by carousel - can open latches.");
        this.closeLatchesShouldNotFail("A filter is in Trucks at STANDBY and held by carousel - can close latches.");
        Assert.assertTrue((String)"autochanger latches are LOCKED", (boolean)latches.isClosed());
        plutoGateway.simulateCarouselIsNotHoldingFilter();
        main.updateStateWithSensors();
        trucks.moveToAbsoluteTargetPosition(5000);
        if (((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).isInState((Enum)OperationalState.NORMAL)) {
            this.checkConditionsForOpeningLatchesShouldFail("Trucks are not at STANDBY neither at HANDOFF  - not allowed to open latches");
        }
        trucks.goToHandOff();
        plutoGateway.simulateLoaderIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Loader is holding filter at HANDOFF", (boolean)autochanger.isLoaderHoldingFilterAtHandoff());
        this.checkConditionsForOpeningLatchesShouldNotFail("Trucks at HANDOFF and loader holds filter. latches can be opened.");
    }

    private void checkConditionsForOpeningLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkConditionsForOpeningLatches();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        finally {
            ((AlertService)autochangerSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
        }
    }

    private void checkConditionsForOpeningLatchesShouldNotFail(String message) {
        System.out.println(message);
        try {
            autochanger.checkConditionsForOpeningLatches();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
    }

    public void testOpenLatches() {
        System.out.println("**** test openLatches ***");
        this.openLatchesShouldFail("latches already UNLOCKED");
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isOpened());
        plutoGateway.simulateCarouselIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)autochanger.isCarouselHoldingFilterAtStandby());
        this.openLatchesShouldNotFail("filter is held by carousel at STANDBY - latches can be opened.");
        Assert.assertTrue((String)"autochanger latches are UNLOCKED", (boolean)latches.isOpened());
    }

    private void openLatchesShouldFail(String message) {
        System.out.println(message);
        try {
            latches.open();
            Assert.fail((String)message);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        finally {
            ((AlertService)autochangerSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
        }
    }

    private void openLatchesShouldNotFail(String message) {
        System.out.println(message);
        try {
            latches.open();
        }
        catch (RejectedCommandException ex) {
            System.out.println(message + (Object)((Object)ex));
        }
        Assert.assertTrue((String)"Latches are UNLOCKED", (boolean)latches.isOpened());
    }

    @AfterClass
    public static void after() throws Exception {
        System.getProperties().remove("org.lsst.ccs.fcs.instance.autochanger.standalone");
        System.out.println("****************************************************");
        System.out.println("*** shutdown of autochanger-standalone subsystem ***");
        System.out.println("****************************************************");
        if (autochangerSubsystem != null) {
            autochangerSubsystem.shutdownAgent();
            ((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        }
    }

    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT autochangerTest.py ***");
        System.out.println("************************************************");
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/autochangerTest.py", (String[])new String[0]);
        System.out.println("************************************************");
        System.out.println("*** End of Python SCRIPT autochangerTest.py ***");
        System.out.println("************************************************");
    }
}

