/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.Inclinometer;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public abstract class PlutoGateway
extends CanOpenDevice
implements PlutoGatewayInterface {
    protected int[] readValues = new int[17];
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Map<String, SensorPluggedOnDevice> sensorsMap = new HashMap<String, SensorPluggedOnDevice>();

    @Override
    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByPlutoGateway.class, this.name);
    }

    @Override
    public void init() {
        FCSCst.FCSLOG.info((Object)(this.name + " =====> initialization of my sensors map"));
        StringBuilder sb = new StringBuilder();
        if (this.sensorsMap.isEmpty()) {
            FCSCst.FCSLOG.error((Object)("NO SENSORS ARE FOUND FOR " + this.name));
            return;
        }
        Iterator<SensorPluggedOnDevice> it = this.sensorsMap.values().iterator();
        while (it.hasNext()) {
            SensorPluggedOnDevice sensor = it.next();
            if (this.name.equals(sensor.getDeviceName())) {
                sb.append(sensor.getName());
                sb.append(" ====> IS A SENSOR PLUGGED ON ");
                sb.append(this.name);
                sb.append(":byteNumero=");
                sb.append(sensor.getByteNumero());
                if (sensor instanceof DigitalSensor) {
                    sb.append(";inputNumero=");
                    sb.append(((DigitalSensor)sensor).getInputNumero());
                }
                sb.append("\n");
                continue;
            }
            it.remove();
        }
        FCSCst.FCSLOG.info((Object)sb.toString());
    }

    public List<String> listMySensorsNames() {
        if (this.sensorsMap.isEmpty()) {
            FCSCst.FCSLOG.info((Object)("NO SENSORS ARE FOUND FOR " + this.name));
            return Collections.emptyList();
        }
        FCSCst.FCSLOG.info((Object)("listMySensorsNames for " + this.name));
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.sensorsMap.keySet());
        Collections.sort(res);
        return res;
    }

    @Override
    public void updateValues() {
        this.readValues = this.readNewValues();
        FCSCst.FCSLOG.info((Object)(this.name + " updating my sensors values."));
        this.sensorsMap.values().stream().forEach(sensor -> sensor.updateValue(this.readValues[sensor.getByteNumero()]));
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the string representation of PlutoGateway")
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (int i = 0; i < this.readValues.length; ++i) {
            sb.append("/byte");
            sb.append(i);
            sb.append('=');
            sb.append(String.valueOf(this.readValues[i]));
        }
        return sb.toString();
    }

    public StatusDataPublishedByPlutoGateway createStatusDataPublishedByPlutoGatewayModule() {
        return new StatusDataPublishedByPlutoGateway(this.isBooted(), this.isInitialized(), this.readValues);
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByPlutoGatewayModule()));
        KeyValueDataList kvdl = new KeyValueDataList();
        this.sensorsMap.values().stream().forEach(sensor -> {
            if (sensor instanceof Inclinometer) {
                kvdl.addData(sensor.getName(), (Serializable)Double.valueOf(((Inclinometer)sensor).getInclinaison()));
            } else if (sensor instanceof ForceSensor) {
                kvdl.addData(sensor.getName(), (Serializable)Integer.valueOf(((ForceSensor)sensor).getVoltage()));
            } else if (sensor instanceof DigitalSensor) {
                kvdl.addData(sensor.getName(), (Serializable)Integer.valueOf(((DigitalSensor)sensor).isOn() ? 1 : 0));
            } else {
                FCSCst.FCSLOG.error((Object)(this.getName() + " UNKNOWN sensor instance"));
            }
        });
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)kvdl));
    }
}

