/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSController
extends PieceOfHardware,
HasLifecycle {
    public int getStatusWord();

    public int readStatusWord();

    public void updateStatusWord();

    public short readControlWord();

    public void setEposState(EPOSEnumerations.EposState var1);

    public EPOSEnumerations.EposState getEposState();

    public void writeControlWord(int var1);

    @Command(type=Command.CommandType.QUERY, level=1, description="print status word in binary.")
    default public String printStatusWordInBinary() {
        int sw = this.readStatusWord();
        return "0b" + Integer.toBinaryString(sw);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Shutdown the controller - writeControlWord[6] and check that controller is in state READY_TO_SWITCH_ON.")
    default public void shutdownController() {
        this.writeControlWord(6);
        this.checkState(EPOSEnumerations.EposState.READY_TO_SWITCH_ON);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is READY_TO_SWITCH_ON."));
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller state is state given as argument.")
    default public boolean isInState(EPOSEnumerations.EposState state) {
        return state == this.getEposState();
    }

    public static boolean isReadyToSwitchOn(int statusWord) {
        return (statusWord & 0x6F) == 33;
    }

    public static boolean isSwitchedOn(int statusWord) {
        return (statusWord & 0x6F) == 35;
    }

    public static boolean isSwitchOnDisabled(int statusWord) {
        return (statusWord & 0x4F) == 64;
    }

    public static boolean isOperationEnabled(int statusWord) {
        return (statusWord & 0x6F) == 39;
    }

    public static boolean isFault(int statusWord) {
        return (statusWord & 8) == 8;
    }

    public static boolean isQuickstop(int statusWord) {
        return (statusWord & 0x7F) == 23;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read statusWord by SDO and update eposState.")
    default public void updateEposState() {
        int statusWord = this.readStatusWord();
        this.updateEposState(statusWord);
    }

    default public void updatePositionFromSDO() {
        this.setPosition(this.readPosition());
    }

    default public void updateEposState(int statusWord) {
        if (EPOSController.isFault(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.FAULT);
        } else if (EPOSController.isSwitchOnDisabled(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED);
        } else if (EPOSController.isQuickstop(statusWord)) {
            FCSCst.FCSLOG.info((Object)("QUICKSTOP state " + this.getName() + " statusword " + Integer.toBinaryString(this.readStatusWord()) + " error register " + this.getErrorRegister() + " last error code " + this.getLastErrorCode()));
            if (this instanceof CanOpenEPOS) {
                FCSCst.FCSLOG.info((Object)("QUICKSTOP 0x6007" + ((CanOpenEPOS)this).readSDO(24583, 0) + " 0x605E " + ((CanOpenEPOS)this).readSDO(24670, 0)));
            }
            this.setEposState(EPOSEnumerations.EposState.QUICKSTOP);
        } else if (EPOSController.isReadyToSwitchOn(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.READY_TO_SWITCH_ON);
        } else if (EPOSController.isSwitchedOn(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.SWITCHED_ON);
        } else if (EPOSController.isOperationEnabled(statusWord)) {
            this.setEposState(EPOSEnumerations.EposState.OPERATION_ENABLE);
        } else {
            this.setEposState(EPOSEnumerations.EposState.UNKNOWN_STATE);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check controller state until a timeout of 500ms. If controller never goes in state given as argument, throw an Exception.")
    default public void checkState(EPOSEnumerations.EposState state) {
        long timeoutMillis = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        boolean state_ok = false;
        while (!state_ok && duration <= timeoutMillis) {
            FcsUtils.sleep(2, this.getName());
            duration = System.currentTimeMillis() - timeStart;
            this.updateEposState();
            state_ok = this.isInState(state);
        }
        if (!state_ok) {
            String msg = this.getName() + String.format(" couldn't go to state %s during time allocated of %d ms controller state is %s", state, timeoutMillis, this.getEposState());
            FCSCst.FCSLOG.error((Object)msg);
            FCSCst.FCSLOG.severe((Object)("controller " + this.getName() + " in " + state + " statusword " + Integer.toBinaryString(this.readStatusWord()) + " error register " + this.getErrorRegister() + " last error code " + this.getLastErrorCode() + " " + this.getLastErrorName()));
            throw new FcsHardwareException(msg);
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + String.format(" go to state %s duration = %d", state, duration)));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disable voltage - writeControlWord[0] - and check that controller state is SWITCH_ON_DISABLED. This command does not activate holding brake. cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void disableVoltage() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("disableVoltage-EPOS-" + this.getName());){
            this.writeControlWord(0);
            this.checkState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED);
            FCSCst.FCSLOG.info((Object)(this.getName() + " High-level power is switched off."));
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Got to state SWITH_ON_DISABLED.cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void goToSwitchOnDisabled() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("goToSwitchOnDisabled-EPOS-" + this.getName());){
            this.checkFault();
            this.updateEposState();
            if (this.isInState(EPOSEnumerations.EposState.OPERATION_ENABLE)) {
                this.disableOperation();
                this.disableVoltage();
            } else if (this.isInState(EPOSEnumerations.EposState.SWITCHED_ON) || this.isInState(EPOSEnumerations.EposState.READY_TO_SWITCH_ON) || this.isInState(EPOSEnumerations.EposState.QUICKSTOP)) {
                this.disableVoltage();
            } else if (this.isInState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED)) {
                FCSCst.FCSLOG.info((Object)(this.getName() + " Already SWITCH_ON_DISABLED."));
            } else {
                this.disableVoltage();
                FCSCst.FCSLOG.error((Object)(this.getName() + String.format(" is in BAD STATE %s. This should not happen.", this.getEposState())));
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disable operation - writeControlWord[7] - and check that controller state is SWITCHED_ON. This command activates holding brake. cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void disableOperation() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("EPOS-disableOperation-" + this.getName());){
            this.writeControlWord(7);
            this.checkState(EPOSEnumerations.EposState.SWITCHED_ON);
            FCSCst.FCSLOG.info((Object)(this.getName() + " Drive function is disabled."));
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Switch on and enable controller - writeControlWord[0xF] - and check that controller state is in state OPERATION_ENABLE within 500ms.")
    default public void switchOnEnableOperation() {
        this.writeControlWord(15);
        this.checkState(EPOSEnumerations.EposState.OPERATION_ENABLE);
        FCSCst.FCSLOG.info((Object)(this.getName() + " Drive function is enabled."));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Got to state OPERATION_ENABLE.cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void goToOperationEnable() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("goToOperationEnable-EPOS-" + this.getName());){
            FCSCst.FCSLOG.info((Object)("goToOperationEnable entry state " + this.getEposState()));
            this.checkFault();
            this.updateEposState();
            if (this.isInState(EPOSEnumerations.EposState.SWITCH_ON_DISABLED)) {
                this.shutdownController();
                this.switchOnEnableOperation();
            } else if (this.isInState(EPOSEnumerations.EposState.SWITCHED_ON) || this.isInState(EPOSEnumerations.EposState.READY_TO_SWITCH_ON)) {
                this.switchOnEnableOperation();
            } else if (this.isInState(EPOSEnumerations.EposState.OPERATION_ENABLE)) {
                FCSCst.FCSLOG.info((Object)(this.getName() + " Already in state OPERATION_ENABLE."));
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Stop action and goToSwitchOnDisabled controller.")
    default public void stopAction() {
        if (this.getMode() == EPOSEnumerations.EposMode.HOMING) {
            this.writeControlWord(287);
        } else if (this.getMode() == EPOSEnumerations.EposMode.CURRENT) {
            this.writeCurrent(0);
        } else if (this.getMode() == EPOSEnumerations.EposMode.PROFILE_POSITION) {
            this.stopPosition();
        } else if (this.getMode() == EPOSEnumerations.EposMode.PROFILE_VELOCITY) {
            this.stopVelocity();
        }
        this.goToSwitchOnDisabled();
        FCSCst.FCSLOG.info((Object)(this.getName() + " ACTION STOPPED"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="QuickStop.")
    default public void quickStop() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " running QUICKSTOP command."));
        if (this.getMode().equals((Object)EPOSEnumerations.EposMode.HOMING) || this.getMode().equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION) || this.getMode().equals((Object)EPOSEnumerations.EposMode.VELOCITY)) {
            this.writeControlWord(11);
        } else if (this.getMode().equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            this.writeControlWord(2);
        } else {
            throw new IllegalArgumentException(this.getName() + " has invalid Epos mode:" + this.getMode());
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="This command enables the controller : i.e. this makes it able to receive commands.it does shutdownController, then switchOnEnableOperation.")
    default public void enable() {
        this.shutdownController();
        this.switchOnEnableOperation();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the controller is enabled (statusWord & 0x6F) == 0x27).")
    default public boolean isEnabled() {
        int statusWord = this.readStatusWord();
        this.updateEposState(statusWord);
        return EPOSController.isOperationEnabled(statusWord);
    }

    public void changeMode(EPOSEnumerations.EposMode var1);

    public EPOSEnumerations.EposMode readMode();

    public EPOSEnumerations.EposMode getMode();

    default public boolean isInMode(EPOSEnumerations.EposMode aMode) {
        return aMode.equals((Object)this.getMode());
    }

    default public void checkEposMode(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.EposMode myMode = this.readMode();
        if (aMode != myMode) {
            throw new FcsHardwareException(this.getName() + " is not in mode " + aMode);
        }
    }

    public int readCurrent();

    public int readCurrentAverageValue();

    public int readVelocity();

    public int readFollowingError();

    @Command(type=Command.CommandType.ACTION, level=1, description="In current mode this methods send a current to the motor. index:0x2030 subindex:0 size:2")
    public void writeCurrent(int var1) throws EPOSConfigurationException;

    @Command(type=Command.CommandType.ACTION, level=3, description="Enables controller and sets the current value in the EPOS CPU.")
    default public void enableAndWriteCurrent(int aValue) {
        this.goToOperationEnable();
        this.writeCurrent(aValue);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Defining Absolute Position:" + position));
        int sleepTime = 50;
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.writeControlWord(6);
        FcsUtils.sleep(sleepTime, this.getName());
        this.writeControlWord(15);
        FcsUtils.sleep(sleepTime, this.getName());
        this.writeControlWord(31);
        this.checkHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Check if homing has been done otherwise throws an Exception.")
    default public void checkHomingDone() {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " homing target not yet reached. duration=" + duration));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached()) {
            throw new FcsHardwareException(this.getName() + " couldn't do homing : target is not reached within timeout of " + timeout + "milliseconds.");
        }
        this.writeControlWord(15);
        FCSCst.FCSLOG.info((Object)(this.getName() + " ==> END homing"));
    }

    default public void definePositionFromNegativeLimitSwitch() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Homing with homing method negative limit switch"));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, 0);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 17);
        this.goToOperationEnable();
        this.writeControlWord(31);
    }

    default public void defineHomingCurrentThresholdNegativeSpeed(int currentThreshold) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Homing with method Current Threshold Negative Speed"));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomeOffset, 1000);
        this.writeParameter(EPOSEnumerations.Parameter.CurrentThresholdHomingMode, currentThreshold);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, -4);
        this.goToOperationEnable();
        this.writeControlWord(31);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION Mode this methods returns the actual position. index:0x6064 subindex:0")
    default public int readPosition() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.PositionActualValue);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="read HomingMethod parameter")
    default public byte readHomingMethod() {
        return (byte)this.readParameter(EPOSEnumerations.Parameter.HomingMethod);
    }

    public int getCurrent();

    public int getPosition();

    public int getVelocity();

    public void setCurrent(int var1);

    public void setPosition(int var1);

    public void setVelocity(int var1);

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the position returned by the absolute encoder (single serial data) index:0x2211 subindex:3")
    default public int readSSIPosition() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.SSIEncoderActualPosition);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the controller structure : dual loop or not. Should be 0 or 1index:0x2220 subindex:0")
    default public int readControllerStructure() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.ControllerStructure);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileVelocity. index:0x6081 subindex:0")
    default public long readProfileVelocity() {
        long profileVelocity = this.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readProfileVelocity=" + profileVelocity));
        return profileVelocity;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read PositionSensorType. index:0x2210 subindex:2")
    default public int readPositionSensorType() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.PositionSensorType);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.index:0x607A subindex:0 size:4")
    public void writeTargetPosition(int var1);

    default public void changeProfileVelocity(int newVelocity) {
        FCSCst.FCSLOG.info((Object)(this.getName() + " changing ProfileVelocity to " + newVelocity));
        try {
            this.writeParameter(EPOSEnumerations.Parameter.ProfileVelocity, newVelocity);
        }
        catch (Exception ex) {
            String msg = this.getName() + " : could not change ProfileVelocity to value " + newVelocity;
            FCSCst.FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg, (Throwable)ex);
        }
    }

    public boolean isParametersOK();

    public long readParameter(EPOSEnumerations.Parameter var1);

    public void writeParameter(EPOSEnumerations.Parameter var1, int var2);

    public void checkParameters(EPOSEnumerations.EposMode var1);

    public void writeParameters(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=3, description="Write in the CPU of the EPOS device the values of the parameters set for the mode.")
    default public void writeParameters() {
        this.readMode();
        this.writeParameters(this.getMode());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the decimal value of the Parameter which parameter name is given as argument.")
    default public long readParameter(String parameterName) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf((String)parameterName);
        return this.readParameter(param);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the parameters for the actual mode.")
    default public String readParameters() {
        return this.readParameters(this.readMode().toString());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="This methods reads in the CPU of the EPOS the values of the parameters for a given mode.")
    default public String readParameters(String modeInString) {
        return this.readParameters(EPOSEnumerations.EposMode.valueOf((String)modeInString));
    }

    default public String readParameters(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.Parameter[] params;
        String modeIS = aMode.toString();
        StringBuilder sb = new StringBuilder(this.getName() + " parameters VALUES in decimal format for mode ");
        sb.append(modeIS);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = aMode.getParameters()) {
            sb.append(param.toString());
            sb.append("=");
            long valueInt = this.readParameter(param);
            sb.append(valueInt);
            sb.append("\n");
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + sb.toString()));
        return sb.toString();
    }

    default public void writeParameters(Map<String, Integer> paramMap) {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(EPOSEnumerations.Parameter.valueOf((String)paramName), value);
        }
    }

    public static long convertEPOSValue(EPOSEnumerations.Parameter param, long value, String myName) {
        if (!param.isSigned()) {
            return value;
        }
        if (param.getSize() == 4) {
            return (int)value;
        }
        if (param.getSize() == 2) {
            return (short)value;
        }
        if (param.getSize() == 1) {
            return (byte)value;
        }
        throw new EPOSConfigurationException(myName + ":\f" + param.getSize() + " => bad value for size");
    }

    public boolean isInError();

    public String getErrorRegister();

    public int getLastErrorCode();

    public String getLastErrorName();

    public int getErrorHistoryNB();

    public String displayErrorHistory();

    public void checkFault();

    public void faultReset();

    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode and PROFILE_POSITION mode this indicates that the position is reached. ((readStatusWord() >> 10) & 1) == 1)")
    default public boolean isTargetReached() {
        return (this.readStatusWord() >> 10 & 1) == 1;
    }

    default public void checkTargetReached(long timeout) {
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " target is not yet reached."));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached()) {
            String msg = this.getName() + " couldn't reach target during time allocated of " + timeout + " ms";
            FCSCst.FCSLOG.info((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to absolute position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteAbsolutePosition(int pos) {
        this.goToOperationEnable();
        this.writeTargetPosition(pos);
        this.writeControlWord(63);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to relative position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteRelativePosition(int pos) {
        this.goToOperationEnable();
        this.writeTargetPosition(pos);
        this.writeControlWord(127);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Stop motion when in mode PROFILE_POSITION. (writeControlWord(0x010F))")
    default public void stopPosition() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_POSITION mode.");
        }
        this.writeControlWord(271);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Stop motion when in mode PROFILE_VELOCITY. (writeControlWord(0x0107)")
    default public void stopVelocity() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_VELOCITY)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_VELOCITY mode.");
        }
        this.writeControlWord(263);
    }

    default public StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController() {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(this.isBooted(), this.isInitialized(), this.isInError(), this.getErrorRegister(), this.getErrorHistoryNB(), this.getLastErrorCode(), this.getLastErrorName());
        status.setMode(this.getMode());
        status.setState(this.getEposState());
        status.setCurrent(this.getCurrent());
        status.setPosition(this.getPosition());
        status.setVelocity(this.getVelocity());
        return status;
    }
}

