
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForOnlineClamp;

/**
 * To simulate a controller which opens and closes a ONLINE clamp on the autochanger.
 * @author virieux
 */
public class SimuAutochangerOnlineClampController extends SimuEPOSController implements EPOSControllerForOnlineClamp {

    @ConfigurationParameter(isFinal = true, category = "controller")
    private volatile String onlineClampName;

    @LookupField(strategy = LookupField.Strategy.SIBLINGS)
    private SimuAutochangerPlutoGateway plutoGateway;

    @LookupPath
    private String nodePath;
    

    private AutochangerOnlineClamp onlineClamp;

    private boolean brakeActivatedPub;

    // in the simulation, homing is always done.
    private boolean homingDone = true;

    @Override
    public boolean isBrakeActivatedPub() {
        return brakeActivatedPub;
    }

    @Override
    public void setBrakeActivatedPub(boolean brakeActivatedToPublish) {
        this.brakeActivatedPub = brakeActivatedToPublish;
    }

    @Override
    public void init() {
        if ( plutoGateway == null ) {
            throw new RuntimeException("Invalid initialization. An instance of SimuAutochangerPlutoGateway should have been "
                    + "picked up from the Lookup tree from the siblinds of this node: "+nodePath);
        }
        ComponentLookup lookup = subs.getComponentLookup();
        this.onlineClamp = (AutochangerOnlineClamp) lookup.getComponentByPath(onlineClampName);
        if ( onlineClamp == null ) {
            throw new RuntimeException("Could not find online campl "+onlineClampName);
        }
    }

    /**
     * Quick and dirty simulation.
     * This will have to be refactorized after tests on the real hardware.
     *
     * @param current
     */
    @Override
    public void writeCurrent(int current) {
        this.targetCurrent = current;
        this.actualCurrent = current;
        if (targetCurrent == onlineClamp.getFinalCurrentToClose()) {

            plutoGateway.simulateAutochangerOnlineClampIsClosed(onlineClamp);

        } else if(targetCurrent == onlineClamp.getCurrentToOpen()) {

            plutoGateway.simulateAutochangerOnlineClampIsOpened(onlineClamp);

        } else if(targetCurrent == onlineClamp.getCurrentToClamp()) {

            plutoGateway.simulateAutochangerOnlineClampIsLocked(onlineClamp);
        }
    }

    @Override
    public void writeTargetPosition(int positionToReach) {
        targetPosition = positionToReach;
        position = positionToReach;
        onlineClamp.updatePosition();
        publishData();

        if (targetPosition == onlineClamp.getTargetPositionToOpen()) {
            plutoGateway.simulateAutochangerOnlineClampIsOpened(onlineClamp);

        } else if (targetPosition == onlineClamp.getTargetPositionToClose()) {
            plutoGateway.simulateAutochangerOnlineClampIsClosed(onlineClamp);
        }
    }

    @Override
    public void activateBrakeAndDisable() {
        brakeActivatedPub = true;
    }

    @Override
    public void enableAndReleaseBrake() {
        brakeActivatedPub = false;
    }

    @Override
    public void doReleaseBrake() {
        brakeActivatedPub = false;
    }

    @Override
    public boolean isBrakeActivated() {
        return brakeActivatedPub;
    }

    @Override
    public void activateBrake() {
        brakeActivatedPub = true;
    }

    @Override
    public void homing() {
    }

    @Override
    public boolean isHomingDone() {
        return homingDone;
    }


}
