/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class SimuCarousel
extends Carousel {
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/hyttc580")
    private SimuTTC580 hyttc580;
    private int deltaPositionMax = 1000;

    @Override
    public void postStart() {
        super.postStart();
        FCSLOG.info((Object)"===> INITIALISATION OF CLAMPS STATE : socket at STANBY empty; others loaded with filter<===");
        this.hyttc580.simulateSocketREADYTOCLAMP((short)1);
        this.hyttc580.simulateSocketClampedOnFilter(false, (short)2);
        this.hyttc580.simulateSocketClampedOnFilter(false, (short)3);
        this.hyttc580.simulateSocketClampedOnFilter(false, (short)4);
        this.hyttc580.simulateSocketClampedOnFilter(false, (short)5);
        this.publishData();
        ((SimuCarouselController)this.carouselController).simulateSWITCH_ON_DISABLED();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        int simuAbsTargetPos = this.absoluteTargetPosition % this.getFullTurn();
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            FCSLOG.info((Object)(this.name + " => Checking for carousel position to complete action -  CurrentCarousel Position = " + this.position + " Target Position = " + this.absoluteTargetPosition + " Delta Position expected = " + this.deltaPositionMax));
            return Math.abs(this.position - simuAbsTargetPos) < this.deltaPositionMax;
        }
        return false;
    }

    @Override
    public boolean isRotationAllowedByPLC() {
        return true;
    }

    @Override
    public boolean isUnclampAllowedByPLC() {
        return true;
    }

    @Override
    public void initializeClampsState() {
        FCSLOG.info((Object)(this.name + " Initializing simulated clamps state...."));
        this.clampsStateInitialized = true;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update state from hyttc580 data.", timeout=2000)
    public void updateState() {
        long cmdBeginTime = System.currentTimeMillis();
        this.updateSocketAtStandbyState();
        this.position = this.carouselController.getPosition();
        this.readCurrent = this.carouselController.getCurrent();
        this.readVelocity = this.carouselController.getVelocity();
        this.updateSocketNotAtStandby();
        long duration = System.currentTimeMillis() - cmdBeginTime;
        FCSLOG.info((Object)(this.name + " updateState duration = " + duration));
    }

    @Override
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.hyttc580.socketMapByID.values().stream().forEach(socket -> {
            socket.publishData();
            socket.getClampXminus().publishData();
            socket.getClampXplus().publishData();
        });
    }

    public void simulateCarouselPosition(int pos) {
        ((SimuCarouselController)this.carouselController).simulatePosition(pos);
    }

    public short getSocketAtStandbyID(int carouselPosition) {
        for (CarouselSocket socket : this.socketsMap.values()) {
            if (carouselPosition != socket.getStandbyPosition()) continue;
            return (short)socket.getId();
        }
        return 0;
    }

    @Override
    public void releaseClamps() {
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't release clamps when no socket is halted at standby position.");
        }
        if (this.socketAtStandby.getClampXminus().isFilterEngaged() || this.socketAtStandby.getClampXplus().isFilterEngaged()) {
            throw new RejectedCommandException(this.name + ": Can't release clamps because a filter is engaged in clamps.");
        }
        this.getClampXminusController().goToSwitchOnDisabled();
        this.getClampXplusController().goToSwitchOnDisabled();
        this.hyttc580.simulateSocketREADYTOCLAMP((short)this.socketAtStandby.getId());
    }
}

