/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class Inclinometer
implements SensorPluggedOnDevice,
AlertRaiser,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    private String name = "unset";
    @ConfigurationParameter(units="unitless", category="sensor")
    private volatile int byteNumero;
    @ConfigurationParameter(units="unitless", category="sensor")
    private volatile String deviceName;
    private double inclinaison = 0.0;
    private double voltage;

    public void build() {
        this.dataProviderDictionaryService.registerData(new KeyValueData(this.name, (Serializable)Double.valueOf(this.inclinaison)));
        DataProviderInfo data = new DataProviderInfo("", DataProviderInfo.Type.TRENDING, this.name);
        data.addAttribute(DataProviderInfo.Attribute.UNITS, "degree");
        data.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "inclinaison of the AC truck");
        data.addAttribute(DataProviderInfo.Attribute.TYPE, "double");
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.getName()), alwaysClear);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    public void updateValue(int newValue) {
        FCSCst.FCSLOG.fine((Object)(this.name + " updating inclinaison with newValue read on gateway (unit=0,1Volt): " + newValue));
        this.voltage = newValue;
        this.inclinaison = this.convertVoltage2Degree(this.voltage);
        if (newValue < 0 || newValue > 50) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, newValue + ": bad value read on inclinometer. Value read has to be between 0 and 50 (unit = 0,1Volts).", this.getName());
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns inclinaison value in degrees. Doesn't read again CANopen device.")
    public double getInclinaison() {
        return this.inclinaison;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return raw voltage read on AC PlutoGateway unit is 0.1 Volt")
    public double getVoltage() {
        return this.voltage;
    }

    private double convertVoltage2Degree(double voltage) {
        double voltageInVolt = voltage / 10.0;
        double sin_angle = (voltageInVolt - 2.5) / 11.52;
        return Math.toDegrees(Math.asin(sin_angle));
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }
}

