/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class ForceSensor
implements SensorPluggedOnDevice,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    private String name = "unset";
    private int voltage;
    @ConfigurationParameter(description="name of the gateway this sensor is plugged on", units="unitless", category="sensor")
    protected volatile String deviceName;
    @ConfigurationParameter(description="byte number on the gateway", units="unitless", category="sensor")
    protected volatile int byteNumero;

    public void build() {
        this.dataProviderDictionaryService.registerData(new KeyValueData(this.name, (Serializable)Integer.valueOf(0)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public void updateValue(int newValue) {
        FCSCst.FCSLOG.info((Object)(this.name + " updating voltage = " + newValue));
        this.voltage = newValue;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Returns force sensor analog Value. No unit.")
    public int getVoltage() {
        return this.voltage;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a string representation of ForceSensor")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/deviceName=");
        sb.append(this.deviceName);
        sb.append("/byteNumero=");
        sb.append(String.valueOf(this.byteNumero));
        sb.append("/voltage=");
        sb.append(String.valueOf(this.voltage));
        return sb.toString();
    }
}

