/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenTTC580;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class CanOpenTTC580Test {
    private static CanOpenTTC580 ttc580;
    private static final long pdoValTest = -7176483772207726552L;

    @BeforeClass
    public static void setUpClass() {
        ttc580 = new CanOpenTTC580();
        CanOpenTTC580Test.ttc580.nodeID = 37;
        CanOpenTTC580Test.ttc580.serialNB = "SNttc580";
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetSocketId() {
        System.out.println("**************getSocketId******************");
        long pdoVal = 0L;
        long expResult = 0L;
        ttc580.setPdo1(pdoVal);
        short result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 61.0);
        ttc580.setPdo1(pdoVal);
        expResult = 1L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 62.0);
        ttc580.setPdo1(pdoVal);
        expResult = 2L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 62.0) + (long)Math.pow(2.0, 61.0);
        ttc580.setPdo1(pdoVal);
        expResult = 3L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = Long.MIN_VALUE;
        ttc580.setPdo1(pdoVal);
        expResult = 4L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = -6917529027641081856L;
        ttc580.setPdo1(pdoVal);
        expResult = 5L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611686018427387904L;
        ttc580.setPdo1(pdoVal);
        expResult = 6L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = -2305843009213693952L;
        ttc580.setPdo1(pdoVal);
        expResult = 7L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = 4567890L;
        ttc580.setPdo1(pdoVal);
        expResult = 0L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 60.0);
        ttc580.setPdo1(pdoVal);
        expResult = 0L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
        pdoVal = -7176483772207726552L;
        ttc580.setPdo1(pdoVal);
        expResult = 4L;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => socketID should be = " + result), (long)expResult, (long)result);
    }

    @Test
    public void testGetLockXm() {
        System.out.println("**************getLockXm**************");
        long pdoVal = 0L;
        ttc580.setPdo1(pdoVal);
        int expResult = 0;
        int result = TTC580Utils.getLockXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockSensorXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611686018427387904L;
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getLockXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockSensorXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611586650064027648L;
        ttc580.setPdo1(pdoVal);
        expResult = 1446;
        result = TTC580Utils.getLockXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockSensorXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -5764607454293434368L;
        ttc580.setPdo1(pdoVal);
        expResult = 1;
        result = TTC580Utils.getLockXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockSensorXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611685880988438528L;
        ttc580.setPdo1(pdoVal);
        expResult = 1;
        result = TTC580Utils.getLockXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockSensorXm should be = " + result), (long)expResult, (long)result);
        pdoVal = 68719476736000L;
        ttc580.setPdo1(pdoVal);
        expResult = 1000;
        result = TTC580Utils.getLockXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockSensorXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -7176483772207726552L;
        ttc580.setPdo1(pdoVal);
        expResult = 32;
        result = TTC580Utils.getLockXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockSensorXm should be = " + result), (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceXm() {
        System.out.println("**************getFilterPresenceXm**************");
        long pdoVal = 0L;
        ttc580.setPdo1(pdoVal);
        int expResult = 0;
        int result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611686018427387904L;
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611686018411655424L;
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611686018400124928L;
        ttc580.setPdo1(pdoVal);
        expResult = 1;
        result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
        pdoVal = 0xFFF000000L;
        ttc580.setPdo1(pdoVal);
        expResult = 4095;
        result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -5764607385611010048L;
        ttc580.setPdo1(pdoVal);
        expResult = 4095;
        result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -5764607499529355264L;
        ttc580.setPdo1(pdoVal);
        expResult = 1401;
        result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
        pdoVal = -7176483772207726552L;
        ttc580.setPdo1(pdoVal);
        expResult = 2085;
        result = TTC580Utils.getFilterPresenceXm((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXm should be = " + result), (long)expResult, (long)result);
    }

    @Test
    public void testGetLockXp() {
        System.out.println("**************getLockXp**************");
        long pdoVal = 0L;
        ttc580.setPdo1(pdoVal);
        int expResult = 0;
        int result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -4611686018427387904L;
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -2305843009213693697L;
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -2305843009213689857L;
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -2305843009213685761L;
        ttc580.setPdo1(pdoVal);
        expResult = 1;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -2305843009203167233L;
        ttc580.setPdo1(pdoVal);
        expResult = 2569;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -2305843009186390017L;
        ttc580.setPdo1(pdoVal);
        expResult = 2569;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -2305843009180139521L;
        ttc580.setPdo1(pdoVal);
        expResult = 4095;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -7176483772207726552L;
        ttc580.setPdo1(pdoVal);
        expResult = 832;
        result = TTC580Utils.getLockXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => lockXp should be = " + result), (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceXp() {
        System.out.println("**************getFilterPresenceXp**************");
        long pdoVal = 0L;
        ttc580.setPdo1(pdoVal);
        int expResult = 0;
        int result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = 1L;
        ttc580.setPdo1(pdoVal);
        expResult = 1;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = 1000L;
        ttc580.setPdo1(pdoVal);
        expResult = (int)pdoVal;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = 2046L;
        ttc580.setPdo1(pdoVal);
        expResult = (int)pdoVal;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = 4095L;
        ttc580.setPdo1(pdoVal);
        expResult = (int)pdoVal;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = 4096L;
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 62.0);
        ttc580.setPdo1(pdoVal);
        expResult = 0;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -6917529027641081841L;
        ttc580.setPdo1(pdoVal);
        expResult = 15;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -6917529027641081601L;
        ttc580.setPdo1(pdoVal);
        expResult = 255;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -6917529027641077761L;
        ttc580.setPdo1(pdoVal);
        expResult = 4095;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
        pdoVal = -7176483772207726552L;
        ttc580.setPdo1(pdoVal);
        expResult = 40;
        result = TTC580Utils.getFilterPresenceXp((long)pdoVal);
        Assert.assertEquals((String)("pdoVal = " + pdoVal + " => filterPresenceXp should be = " + result), (long)expResult, (long)result);
    }

    @Test
    public void testGetSlaveModuleStatus() {
        System.out.println("**************getSlaveModuleStatus**************");
        long pdoVal = 0L;
        ttc580.setPdo2(pdoVal);
        int expResult = 0;
        int result = TTC580Utils.getSlaveModuleStatus((long)pdoVal);
        Assert.assertEquals((String)"slaveModuleStatus", (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 60.0) + (long)Math.pow(2.0, 59.0);
        ttc580.setPdo2(pdoVal);
        expResult = 6;
        result = TTC580Utils.getSlaveModuleStatus((long)pdoVal);
        Assert.assertEquals((String)"slaveModuleStatus", (long)expResult, (long)result);
        pdoVal = 0x1000000000000000L;
        ttc580.setPdo2(pdoVal);
        expResult = 4;
        result = TTC580Utils.getSlaveModuleStatus((long)pdoVal);
        Assert.assertEquals((String)"slaveModuleStatus", (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 60.0) + (long)Math.pow(2.0, 59.0) + (long)Math.pow(2.0, 58.0);
        ttc580.setPdo2(pdoVal);
        expResult = 7;
        result = TTC580Utils.getSlaveModuleStatus((long)pdoVal);
        Assert.assertEquals((String)"slaveModuleStatus", (long)expResult, (long)result);
        pdoVal = (long)Math.pow(2.0, 58.0);
        ttc580.setPdo2(pdoVal);
        expResult = 1;
        result = TTC580Utils.getSlaveModuleStatus((long)pdoVal);
        Assert.assertEquals((String)"slaveModuleStatus", (long)expResult, (long)result);
        pdoVal = -5764607523034234880L;
        ttc580.setPdo2(pdoVal);
        expResult = 4;
        result = TTC580Utils.getSlaveModuleStatus((long)pdoVal);
        Assert.assertEquals((String)"slaveModuleStatus", (long)expResult, (long)result);
        expResult = 5;
        result = ttc580.getSocketId(pdoVal);
        Assert.assertEquals((String)"socketID", (long)expResult, (long)result);
    }

    @Test
    public void textExtractByte() {
        long pdoVal = 0L;
        int result = TTC580Utils.extractByte((long)pdoVal, (int)1);
        int expResult = 0;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        pdoVal = 65535L;
        result = TTC580Utils.extractByte((long)pdoVal, (int)1);
        expResult = 255;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        pdoVal = 0xFF00FFL;
        result = TTC580Utils.extractByte((long)pdoVal, (int)0);
        expResult = 255;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)1);
        expResult = 0;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)2);
        expResult = 255;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        pdoVal = 1193046L;
        result = TTC580Utils.extractByte((long)pdoVal, (int)0);
        expResult = 86;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)1);
        expResult = 52;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)2);
        expResult = 18;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        pdoVal = 3642640L;
        result = TTC580Utils.extractByte((long)pdoVal, (int)0);
        expResult = 16;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)1);
        expResult = 149;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)2);
        expResult = 55;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        pdoVal = -7895261861258461184L;
        result = TTC580Utils.extractByte((long)pdoVal, (int)2);
        expResult = 0;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)3);
        expResult = 7;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)5);
        expResult = 101;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
        result = TTC580Utils.extractByte((long)pdoVal, (int)6);
        expResult = 110;
        Assert.assertEquals((String)"extractByte", (long)expResult, (long)result);
    }

    @Test
    public void testGetSensorValue() {
        long pdoVal = 0L;
        int result = TTC580Utils.getSensorValue((long)pdoVal, (int)1, (int)5);
        int expResult = 0;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)2, (int)2);
        expResult = 0;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)3, (int)7);
        expResult = 0;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        pdoVal = 0xFFFFFFL;
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)0, (int)1);
        expResult = 1;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)1, (int)7);
        expResult = 1;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)2, (int)7);
        expResult = 1;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        pdoVal = 14615287L;
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)0, (int)0);
        expResult = 1;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)1, (int)0);
        expResult = 0;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)2, (int)0);
        expResult = 1;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)0, (int)3);
        expResult = 0;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)1, (int)1);
        expResult = 1;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)2, (int)5);
        expResult = 0;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        pdoVal = -7895261861258461184L;
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)5, (int)5);
        expResult = 1;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
        result = TTC580Utils.getSensorValue((long)pdoVal, (int)5, (int)4);
        expResult = 0;
        Assert.assertEquals((String)"getSensorValue", (long)expResult, (long)result);
    }
}

