/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.NotPublisherDigitalSensor;

public class DigitalSensorTest
extends FCSTestTemplate {
    private static final int inputNumero1 = 3;
    private static final int inputNumero2 = 5;
    private static final int byteNumero2 = 1;
    private static NotPublisherDigitalSensor sensor1;
    private static NotPublisherDigitalSensor sensor2;
    private static final String UN = "1";
    private static final String DEUX = "2";
    private static final String TROIS = "3";
    private static final String GATEWAY = "gateway";

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF DigitalSensor");
        System.out.println("***************************************");
        sensor1 = new NotPublisherDigitalSensor("dio1", 3, 0);
        sensor2 = new NotPublisherDigitalSensor("dio1", 5, 1);
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of DigitalSensor tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetByteNumero() {
        System.out.println("getByteNumero");
        int expResult = 0;
        int result = sensor1.getByteNumero();
        Assert.assertEquals((String)"byteNumero of sensor1 is 0", (long)expResult, (long)result);
        expResult = 1;
        result = sensor2.getByteNumero();
        Assert.assertEquals((String)"byteNumero of sensor2 is 1", (long)expResult, (long)result);
    }

    @Test
    public void testGetInputNumero() {
        System.out.println("getInputNumero");
        int expResult = 3;
        int result = sensor1.getInputNumero();
        Assert.assertEquals((String)"inputNumero of sensor1 is 3", (long)expResult, (long)result);
        expResult = 5;
        result = sensor2.getInputNumero();
        Assert.assertEquals((String)"inputNumero of sensor2 is 5", (long)expResult, (long)result);
    }

    @Test
    public void testUpdateValue_Int() {
        NotPublisherDigitalSensor sensor;
        int i;
        System.out.println("##########################################");
        System.out.println("   updateValue of class Digital sensor");
        System.out.println("##########################################");
        System.out.println("updateValue");
        NotPublisherDigitalSensor sensor5 = new NotPublisherDigitalSensor(GATEWAY, 5, 0);
        try {
            sensor5.updateValue(65535);
            Assert.fail((String)"FFFF trop grand devrait lancer une exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        sensor1.updateValue(255);
        Assert.assertTrue((String)"new digital value of sensor1 is now true", (boolean)sensor1.isOn());
        sensor1.updateValue(0);
        Assert.assertFalse((String)"new digital value of sensor1 is now false", (boolean)sensor1.isOn());
        int bin = 8;
        sensor1.updateValue(bin);
        Assert.assertTrue((String)"new digital value of sensor1 is now true", (boolean)sensor1.isOn());
        sensor2.updateValue(255);
        Assert.assertTrue((String)"new digital value of sensor2 is now 1", (boolean)sensor2.isOn());
        sensor2.updateValue(0);
        Assert.assertFalse((String)"new digital value of sensor2 is now false", (boolean)sensor2.isOn());
        for (i = 0; i < 8; ++i) {
            sensor = new NotPublisherDigitalSensor(GATEWAY, i, 0);
            sensor.updateValue(255);
            Assert.assertTrue((String)"when GATEWAY returns FF, sensor is ON", (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new NotPublisherDigitalSensor(GATEWAY, i, 0);
            sensor.updateValue(0);
            Assert.assertFalse((String)"when GATEWAY returns ZERO, sensor is OFF", (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new NotPublisherDigitalSensor(GATEWAY, i, 0);
            sensor.updateValue(1);
            if (i > 0) {
                Assert.assertFalse((String)("when GATEWAY returns 1, sensor " + (Object)((Object)sensor) + " is OFF"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertTrue((String)("when GATEWAY returns 1, sensor " + (Object)((Object)sensor) + " is ON"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new NotPublisherDigitalSensor(GATEWAY, i, 0);
            sensor.updateValue(2);
            if (i == 1) {
                Assert.assertTrue((String)("when GATEWAY returns 2, sensor " + (Object)((Object)sensor) + " is ON"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertFalse((String)("when GATEWAY returns 2, sensor " + (Object)((Object)sensor) + " is OFF"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new NotPublisherDigitalSensor(GATEWAY, i, 0);
            sensor.updateValue(3);
            if (i > 1) {
                Assert.assertFalse((String)("when GATEWAY returns 3, sensor " + (Object)((Object)sensor) + " is OFF"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertTrue((String)("when GATEWAY returns 3, sensor " + (Object)((Object)sensor) + " is ON"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new NotPublisherDigitalSensor(GATEWAY, i, 0);
            sensor.updateValue(35);
            if (i == 0 || i == 1 || i == 5) {
                Assert.assertTrue((String)("when GATEWAY returns 23, sensor " + (Object)((Object)sensor) + " is ON"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertFalse((String)("when GATEWAY returns 23, sensor " + (Object)((Object)sensor) + " is OFF"), (boolean)sensor.isOn());
        }
        for (i = 0; i < 8; ++i) {
            sensor = new NotPublisherDigitalSensor(GATEWAY, i, 0);
            sensor.updateValue(197);
            if (i == 0 || i == 2 || i == 6 || i == 7) {
                Assert.assertTrue((String)("when GATEWAY returns c5, sensor " + (Object)((Object)sensor) + " is ON"), (boolean)sensor.isOn());
                continue;
            }
            Assert.assertFalse((String)("when GATEWAY returns c5, sensor " + (Object)((Object)sensor) + " is OFF"), (boolean)sensor.isOn());
        }
    }

    @Test
    public void testUpdateValue_IntArr() {
        System.out.println("updateValue");
        int[] values = new int[]{255, 255, 255};
        sensor1.updateValue(values[sensor1.getByteNumero()]);
        Assert.assertTrue((String)"new digital value of sensor1 is now true", (boolean)sensor1.isOn());
        sensor2.updateValue(values[sensor2.getByteNumero()]);
        Assert.assertTrue((String)"new digital value of sensor2 is now true", (boolean)sensor2.isOn());
        int[] values2 = new int[]{255, 0, 255};
        sensor2.updateValue(values2[sensor2.getByteNumero()]);
        Assert.assertFalse((String)"new digital value of sensor2 is now false", (boolean)sensor2.isOn());
        int bin = 32;
        int[] values4 = new int[]{0, bin};
        sensor2.updateValue(values4[sensor2.getByteNumero()]);
        Assert.assertTrue((String)"new digital value of sensor2 is now true", (boolean)sensor2.isOn());
        int[] values3 = new int[]{0, 255, 255};
        sensor1.updateValue(values3[sensor1.getByteNumero()]);
        Assert.assertFalse((String)"new digital value of sensor1 is now false", (boolean)sensor1.isOn());
    }
}

