/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class CanOpenEPOSLinearRailTruck
extends CanOpenEPOS
implements EPOSControllerForLinearRail {
    @ConfigurationParameter(description="minimal position of the encoder ribbon.", category="controller")
    private volatile int encoderRibbonMinValue;
    private boolean homingDone;
    private CanOpenEPOSLinearRailTruck otherAcTruckController;
    private boolean brakeActivatedPub = false;
    private boolean configDigitalInputOK = true;
    private boolean configDigitalOutputOK = true;
    private StringBuilder configDigitalInputSb;
    private StringBuilder configDigitalOutputSb;
    protected int cobid1 = this.nodeID + 384;
    protected int cobid2 = this.nodeID + 640;
    private long pdo1 = 0L;
    private long pdo2 = 0L;
    private final boolean updateByPDO = false;

    @Override
    public boolean isBrakeActivatedPub() {
        return this.brakeActivatedPub;
    }

    @Override
    public void setBrakeActivatedPub(boolean brakeActivatedToPublish) {
        this.brakeActivatedPub = brakeActivatedToPublish;
        this.publishData();
    }

    @Override
    public void build() {
        super.build();
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.otherAcTruckController = this.getName().contains("Xminus") ? (CanOpenEPOSLinearRailTruck)lookup.getComponentByPath("acTruckXplusController") : (CanOpenEPOSLinearRailTruck)lookup.getComponentByPath("acTruckXminusController");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return true if homing is done: the controller knows its absolute position.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Do homing of the controller.")
    public void homing() {
        this.checkInitialized();
        this.homingDone = false;
        int ssiPosition = this.readSSIPosition();
        int pos = ssiPosition - this.encoderRibbonMinValue;
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ssiPosition=" + ssiPosition + ", position=" + pos));
        if (Math.abs(pos - this.readPosition()) < 10) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " no homing to be done."));
            this.homingDone = true;
        } else {
            this.doHoming(pos);
            this.publishData();
        }
    }

    private void doHoming(int pos) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ==> BEGIN homing"));
        EPOSEnumerations.EposMode myMode = this.readMode();
        this.goToOperationEnable();
        this.defineAbsolutePosition(pos);
        this.checkHomingDone(pos);
        this.homingDone = true;
        this.changeMode(myMode);
        this.activateBrakeAndDisable();
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ==> END homing"));
    }

    private void checkHomingDone(int pos) {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " homing target not yet reached. duration=" + duration));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached() || pos != this.readPosition()) {
            this.activateBrakeAndDisable();
            throw new FcsHardwareException(this.getName() + " couldn't do homing : target is not reached.");
        }
        this.writeControlWord(15);
    }

    @Override
    public void faultReset() {
        super.faultReset();
        this.otherAcTruckController.updateEposState();
        if (this.otherAcTruckController.getEposState() != EPOSEnumerations.EposState.FAULT) {
            this.otherAcTruckController.activateBrakeAndDisable();
            this.otherAcTruckController.publishData();
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalInputOfLinearRails() {
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 4);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, 5);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 48);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital input of linear rail controller.")
    public void checkConfigDigitalInputOfLinearRails() {
        this.configDigitalInputSb = new StringBuilder();
        this.configDigitalInputSb.append(" Configuration of Digital Input:");
        this.checkParamInput(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 4);
        this.checkParamInput(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, 5);
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 48);
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
        if (this.configDigitalInputOK) {
            FCSCst.FCSLOG.info((Object)this.configDigitalInputSb.toString());
        } else {
            FCSCst.FCSLOG.error((Object)this.configDigitalInputSb.toString());
        }
    }

    private void checkParamInput(EPOSEnumerations.Parameter param, int configValue) {
        int paramValue = (int)this.readParameter(param);
        if (configValue != paramValue) {
            this.configDigitalInputOK = false;
        }
        this.configDigitalInputSb.append(param).append("=");
        this.configDigitalInputSb.append(paramValue).append(";");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalOutputOfLinearRails() {
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 0);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 15);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, 0);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, 2);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 4);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32773);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital output of linear rail controller.")
    public void checkConfigDigitalOutputOfLinearRails() {
        this.configDigitalOutputSb = new StringBuilder();
        this.configDigitalOutputSb.append(" Configuration of Digital Output:");
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 15);
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, 0);
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, 2);
        this.checkParamOutput(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 4);
        this.checkParamOutput(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32773);
        if (this.configDigitalOutputOK) {
            FCSCst.FCSLOG.info((Object)this.configDigitalOutputSb.toString());
        } else {
            FCSCst.FCSLOG.error((Object)this.configDigitalOutputSb.toString());
        }
    }

    private void checkParamOutput(EPOSEnumerations.Parameter param, int configValue) {
        int paramValue = (int)this.readParameter(param);
        if (configValue != paramValue) {
            this.configDigitalOutputOK = false;
        }
        this.configDigitalOutputSb.append(param).append("=");
        this.configDigitalOutputSb.append(paramValue).append(";");
    }

    public void shutdown() {
    }

    @Override
    public void doInitializePDOs() throws DriverException {
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print values updated by PDOs to debug and test")
    public String printValuesUpdatedByPDOs() {
        StringBuilder sb = new StringBuilder("=> pdo1 value = ");
        sb.append(this.pdo1);
        sb.append(" / pdo1 = 0x");
        sb.append(Long.toHexString(this.pdo1));
        sb.append(" / status word = 0x");
        sb.append(Long.toHexString(this.statusWord));
        sb.append("\n status word = 0b");
        sb.append(Long.toBinaryString(this.statusWord));
        sb.append("\n current average = ");
        sb.append(this.current);
        sb.append(" / current average = 0x");
        sb.append(Long.toHexString(this.current));
        sb.append("\n position = ");
        sb.append(this.position);
        sb.append(" / position = 0x");
        sb.append(Long.toHexString(this.position));
        sb.append("\n => pdo2 value = ");
        sb.append(this.pdo2);
        sb.append(" / pdo2 = 0x");
        sb.append(Long.toHexString(this.pdo2));
        sb.append("\n followingError = ");
        sb.append(this.followingError);
        sb.append(" / followingError = 0x");
        sb.append(Long.toHexString(this.followingError));
        sb.append(this.followingError);
        sb.append("\n Velocity = ");
        sb.append(this.velocity);
        sb.append(" / velocity = 0x");
        sb.append(Long.toHexString(this.velocity));
        return sb.toString();
    }
}

