
package org.lsst.ccs.subsystems.fcs.utils;

/**
 *
 * @author virieux
 */
public class TTC580Utils {

    /**
     * return lock sensor for clampXminus
     *
     * @param pdo
     * @return
     */
    public static int getLockXm(long pdo) {
        return (int) (pdo >>> 36) & 0xFFF;
    }

    /**
     * return filter presence sensor for clampXminus
     *
     * @param pdo
     * @return
     */
    public static int getFilterPresenceXm(long pdo) {
        return (int) (pdo >>> 24) & 0xFFF;
    }

    /**
     * return lock sensor for clampXplus
     *
     * @param pdo
     * @return
     */
    public static int getLockXp(long pdo) {
        return (int) (pdo >>> 12) & 0xFFF;
    }

    /**
     * return filter presence sensor value for clampXplus.
     *
     * this value is coded on the last 12 bits (reading from left to right).
     *
     * @param pdo
     * @return
     */
    public static int getFilterPresenceXp(long pdo) {
        return (int) pdo & 0xFFF;
    }

    /**
     * return slave module status.
     *
     * There is one slave module per socket (so 5 slave modules). A slave module is
     * a ttc-30 where clamps sensors are plugged.
     *
     * @param pdo
     * @return
     */
    public static int getSlaveModuleStatus(long pdo) {
        /* 58 = 64 - nbBits (nbBits = 6) */
        return (int) (pdo >>> 58) & 0b000111;
    }

    /**
     * return brakes powered status read on pdo4 byte 3 bit 0
     *
     * @param pdo
     * @return
     */
    public static int getBrakesPowered(long pdo) {
        return 0;
    }

    /**
     * return sleep status read on pdo4 byte 3 bit 1
     *
     * @param pdo
     * @return
     */
    public static int getSleep(long pdo) {
        return 0;
    }

    /**
     * return shutter inactive status read on pdo4 byte 3 bit 2
     *
     * @param pdo
     * @return
     */
    public static int getShutterInactive(long pdo) {
        return 0;
    }

    /**
     * return engineering mode status read on pdo4 byte 4 bit 2 and 1
     *
     * @param pdo
     * @return
     */
    public static int getEngineeringMode(long pdo) {
        return 0;
    }

    /**
     * return lockout status read on pdo4 byte 4 bit 4 and 3
     *
     * @param pdo
     * @return
     */
    public static int getLockout(long pdo) {
        return 0;
    }

    /**
     * return triple switch check rotation read on pdo4 byte 4 bit 5
     *
     * @param pdo
     * @return
     */
    public static int getCheckRotation(long pdo) {
        return 0;
    }

    /**
     * return triple switch stop rotation read on pdo4 byte 4 bit 6
     *
     * @param pdo
     * @return
     */
    public static int getStopRotation(long pdo) {
        return 0;
    }

    /**
     * return triple switch stop unclamp read on pdo4 byte 4 bit 7
     *
     * (name on hyttc580 : force rotation)
     *
     * @param pdo
     * @return
     */
    public static int getStopUnclamp(long pdo) {
        return 0;
    }

    /**
     *
     * @param sdo
     * @return Offset1 for Balluff X- (FilterPresenceSensor)
     */
    public static int getOffset1Xminus(long sdo) {
        return (int) (sdo & 0xFFFF);
    }

    /**
     *
     * @param sdo
     * @return offset1 for Balluff X+ (FilterPresenceSensor)
     */
    public static int getOffset1Xplus(long sdo) {
        return (int) (sdo >> 16 & 0xFFFF);
    }

    /**
     *
     * @param sdo
     * @return Offset2 for Balluff X- (FilterPresenceSensor)
     */
    public static int getOffset2Xminus(long sdo) {
        return (int) (sdo & 0xFFFF);
    }

    /**
     *
     * @param sdo
     * @return offset2 for Balluff X+ (FilterPresenceSensor)
     */
    public static int getOffset2Xplus(long sdo) {
        return (int) (sdo >> 16 & 0xFFFF);
    }

    public static int getErrorSource(int error) {
        return (error >> 28) & 0xF;
    }

    public static int getErrorType(int error) {
        return (error >> 24) & 0xF;
    }

    public static int getErrorCounter(int error) {
        return (error >> 16) & 0xFF;
    }

    public static int getErrorCode(int error) {
        return error & 0xFFFF;
    }

    /**
     * extract a one bit sensor value from pdo
     *
     * @param pdo
     * @param n byte number
     * @param bit bit number
     * @return
     */
    public static int getSensorValue(long pdo, int n, int bit) {
        return ((extractByte(pdo, n) >> bit) & 1);
    }

    public static int extractByte(long pdo, int n) {
        if (n > 7) {
            throw new IllegalArgumentException("n=" + n + " should be < 7 ");
        }
        int decalage = n * 8;
        return (int) (pdo >>> decalage) & 0xFF;
    }


}
