
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;

/**
 * Represents a couple of sensors which are redondant : that means they must
 * have the same digitalValue. If the 2 sensors have different digital value,
 * the couple of sensors is in error.
 *
 * This sort of sensors are used in loader carrier. The goal is to be able to
 * detect errors in sensors (capteur défectueux, error de câblage)
 *
 * @author virieux
 */
public class RedondantSensors implements BinarySensor, HasLifecycle  {

    @LookupPath
    private String path;
    
    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    private final List<DigitalSensor> sensors = new ArrayList<>();

    /**
     * one sensor of the couple of RedondantSensors
     */
    private DigitalSensor sensor;

    /**
     * redondant sensor
     */
    private DigitalSensor sensorR;

    //Public constructor to be used in groovy
    public RedondantSensors() {
        
    }
    
    /**
     * For tests only
     * builds a RedondantSensors object from a couple of sensors.
     *
     * @param sensor
     * @param sensorR
     */
    RedondantSensors(DigitalSensor sensor, DigitalSensor sensorR) {
        this.sensor = sensor;
        this.sensorR = sensorR;
    }

    @Override
    public void build() {
        if ( sensors.size() != 2 ) {
            throw new RuntimeException("A RedondantSensors instance requires two DigitalSensors as its children. For "+path+" there are "+sensors.size());
        }
        sensor = sensors.get(0);
        sensorR = sensors.get(1);        
    }
    

    /**
     * for simulation
     *
     * @return
     */
    public DigitalSensor getSensor() {
        return sensor;
    }

    /**
     * for simulation
     *
     * @return
     */
    public DigitalSensor getSensorR() {
        return sensorR;
    }

    /**
     * returns true if sensors send different values.
     *
     * @return
     */
    @Override
    public boolean isInError() {
        return sensor.isOn() != sensorR.isOn();
    }

    /**
     *
     * @return true if both sensors value is 1
     */
    @Override
    public boolean isOn() {
        return sensor.isOn() && sensorR.isOn();
    }
}
