package org.lsst.ccs.subsystems.fcs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.TreeMap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;


/**
 * A temporary main to convert configuration files to full path
 */
public class ConvertConfigurationToFullPath {
    
    
    
    public static void main(String[] args) throws Exception {
        
        String fileName = args[0];
        if ( fileName.contains("/") ) {
            fileName = fileName.substring(fileName.lastIndexOf("/")+1);
        }
        String[] split = fileName.replace(".properties", "").split("_");
        if ( split.length != 3 ) {
            throw new RuntimeException("File name must be in the format <source>_<tag>_<category>");            
        }
        
        SingleCategoryTag singleCatTag = new SingleCategoryTag(split[0], split[1], split[2]);
      
        LocalConfigurationDAO localDao = new LocalConfigurationDAO();
        SingleCategoryTagData data = localDao.loadCategoryTag(singleCatTag);
        
        
        Properties conversionProps = new Properties();
        conversionProps.load(BootstrapResourceUtils.getBootstrapResource("fullPathConversion.txt"));
        
        StringBuilder sb = new StringBuilder();
        
        for (String key : data.getConfigurationData().keySet() ) {
            int keySplit = key.lastIndexOf("/");
            String component = key.substring(0,keySplit);
            String parameter = key.substring(keySplit+1);
            if ( conversionProps.containsKey(component) ) {
                component = conversionProps.getProperty(component);
            }
            
            String comment = data.getCommentParameter(key);
            if ( comment != null ) {
                sb.append(comment).append("\n");
            }            
            sb.append(component).append("/").append(parameter).append("=").append(data.getConfigurationData().get(key)).append("\n");            
        }
        
        SingleCategoryTagData convertedData = new SingleCategoryTagData(data.getSingleCategoryTag());
        convertedData.load( new ByteArrayInputStream(sb.toString().getBytes()));

        localDao.saveCategoryTagData(convertedData);
    }
    
}
