package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterFamily;

/**
 * This is a model for an optical filter for the camera.
 *
 */
public class Filter {

    @LookupName
    private String name;

    @ConfigurationParameter(description = "weight of this filter", range = "0..100", units = "kilos", category = "filter")
    private volatile double weight;

    @ConfigurationParameter(description = "FilterID which is coded on filter frame with 6 hall effect sensors.", range = "1..63", units = "unitless", category = "filter")
    private volatile int filterID;

    @ConfigurationParameter(description = "Filter family: S ; D ; F ; T ; O", units = "unitless", category = "filter")
    private volatile FilterFamily family;

    /**
     * Default constructor.
     */
    public Filter() {};
    /**
     * Build a filter with an ID and a weight and a socketName.
     *
     * @param filterID
     * @param weight
     */
    Filter(int filterID, double weight) {
        this.filterID = filterID;
        this.weight = weight;
    }

    /**
     * Returns filterID as Integer
     *
     * @return
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, description = "Returns filter id.")
    public int getFilterID() {
        return filterID;
    }

    public String getName() {
        return name;
    }

    /**
     * return filter weight
     *
     * @return
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, description = "Returns filter weight.")
    public double getWeight() {
        return weight;
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, description = "Returns filter family.")
    public FilterFamily getFamily() {
        return family;
    }



}
