/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.BridgeToLoader;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;

public abstract class MainModule
extends Subsystem
implements AlertRaiser,
SignalHandler,
HasLifecycle {
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final List<BridgeToHardware> bridges = new ArrayList<BridgeToHardware>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected final Map<String, MovedByEPOSController> hardMovedByController = new HashMap<String, MovedByEPOSController>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected final Map<String, EPOSController> controllerList = new HashMap<String, EPOSController>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FilterManager filterManager;
    protected BridgeToHardware bridge;
    protected AtomicBoolean haltRequired = new AtomicBoolean(false);
    protected AtomicBoolean stopRequired = new AtomicBoolean(false);

    public MainModule() {
        super("subsystemName-placeholder", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    public boolean isHaltRequired() {
        return this.haltRequired.get();
    }

    public boolean isStopRequired() {
        return this.stopRequired.get();
    }

    public void build() {
        this.agentStateService.registerState(FcsEnumerations.FilterReadinessState.class, "Filter Exchange Readiness State", (Object)this.subs);
        this.agentStateService.registerState(FcsEnumerations.FilterState.class, "Filter Exchange State", (Object)this.subs);
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("main-updateGui", this::updateGui).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofSeconds(1L)));
        switch (this.bridges.size()) {
            case 0: {
                throw new RuntimeException("No BridgeToHardware instances were detected. Something went wrong in groovy.");
            }
            case 1: {
                this.bridge = this.bridges.get(0);
                break;
            }
            case 2: {
                BridgeToHardware b = this.bridges.get(0);
                if (b instanceof BridgeToLoader) {
                    this.bridge = this.bridges.get(1);
                    break;
                }
                this.bridge = b;
                break;
            }
            default: {
                throw new RuntimeException("We expect at most 2 BridgeToHardware instaces, but we got " + this.bridges.size() + "; something went wrong in groovy");
            }
        }
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.UPDATE_ERROR.getAlert(this.name), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if all hardware is booted with the correct serial number.")
    public boolean allDevicesBooted() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns the list of CANopen hardware managed by this subsystem.")
    public List<String> listHardwareNames() {
        return this.bridge.listHardwareNames();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return the list of LOADER CANopen hardware managed by this subsystem.")
    public List<String> listLoaderHardwareNames() {
        return Collections.emptyList();
    }

    @Command(type=Command.CommandType.QUERY, description="Return the list of names of filters  that this subsystem manages.", level=0, alias="listFilterNames")
    public List<String> getFilterNames() {
        return this.filterManager == null ? Collections.emptyList() : this.filterManager.getFilterNames();
    }

    @Command(type=Command.CommandType.QUERY, description="Return a map : couples of name of mobil item and name of controller.", level=0)
    public Map<String, String> getMobilNameControllerNameMap() {
        HashMap<String, String> ctlNames = new HashMap<String, String>();
        this.hardMovedByController.keySet().stream().forEach(hardName -> ctlNames.put((String)hardName, this.hardMovedByController.get(hardName).getControllerName()));
        return ctlNames;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.")
    public abstract void updateStateWithSensors();

    public void updateGui() {
        if (this.isInState((Enum)CommandState.READY)) {
            try {
                this.updateStateWithSensors();
            }
            catch (Exception ex) {
                this.raiseWarning(FcsEnumerations.FcsAlert.UPDATE_ERROR, "error in reading sensors can't update GUI", this.name, ex);
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check hardware after initialization. To be executed if during boot process some hardware is missing.")
    public abstract void initializeHardware();

    public void updateAgentState(FcsEnumerations.FilterState filterS) {
        this.agentStateService.updateAgentState(new Enum[]{filterS});
    }

    public void updateAgentState(FcsEnumerations.FilterReadinessState readinessS) {
        this.agentStateService.updateAgentState(new Enum[]{readinessS});
    }

    public boolean isInState(Enum state) {
        return this.agentStateService.isInState(state);
    }

    public FcsEnumerations.FilterReadinessState getFilterReadinessState() {
        return (FcsEnumerations.FilterReadinessState)this.agentStateService.getState(FcsEnumerations.FilterReadinessState.class);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readiness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.allDevicesBooted() && !this.isInState((Enum)AlertState.ALARM)) {
            this.updateAgentState(FcsEnumerations.FilterState.READY);
            this.updateAgentState(FcsEnumerations.FilterReadinessState.READY);
        }
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                FCSCst.FCSLOG.debug((Object)"HALT required");
                this.haltRequired.set(true);
                break;
            }
            case STOP: {
                FCSCst.FCSLOG.debug((Object)"STOP required");
                this.stopRequired.set(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return TreeWalkerDiag.GO;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Publish Data to populate GUI.")
    public void publishData() {
        this.bridge.publishData();
        this.controllerList.forEach((hardName, controller) -> controller.publishData());
    }

    public void postShutdown() {
        FCSCst.FCSLOG.info((Object)(this.name + " is shutting down."));
        this.bridge.doShutdown();
        FCSCst.FCSLOG.info((Object)(this.name + " is shutdown."));
    }
}

