/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public class Filter {
    @LookupName
    private String name;
    @ConfigurationParameter(description="weight of this filter", range="0..100", units="kilos", category="filter")
    private volatile double weight;
    @ConfigurationParameter(description="FilterID which is coded on filter frame with 6 hall effect sensors.", range="1..63", units="unitless", category="filter")
    private volatile int filterID;
    @ConfigurationParameter(description="Filter family: S ; D ; F ; T ; O", units="unitless", category="filter")
    private volatile FcsEnumerations.FilterFamily family;

    public Filter() {
    }

    Filter(int filterID, double weight) {
        this.filterID = filterID;
        this.weight = weight;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns filter id.")
    public int getFilterID() {
        return this.filterID;
    }

    public String getName() {
        return this.name;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns filter weight.")
    public double getWeight() {
        return this.weight;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns filter family.")
    public FcsEnumerations.FilterFamily getFamily() {
        return this.family;
    }
}

