/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class DoubleHashtable
extends AbstractCollection
implements Serializable {
    private static final long serialVersionUID = -545653328241864972L;
    private Hashtable table = new Hashtable();

    @Override
    public void clear() {
        this.table.clear();
    }

    public void clear(Object key) {
        Hashtable subtable = this.get(key);
        if (subtable != null) {
            subtable.clear();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("DoubleHashtable.clone() is not (yet) supported.");
    }

    @Override
    public boolean contains(Object value) {
        if (value == null) {
            value = this;
        }
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            Hashtable subtable = this.get(e.nextElement());
            if (!subtable.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            key = this;
        }
        return this.table.containsKey(key);
    }

    public boolean containsKey(Object key, Object subKey) {
        Hashtable subtable;
        if (subKey == null) {
            subKey = this;
        }
        return (subtable = this.get(key)) != null ? subtable.containsKey(subKey) : false;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Enumeration subtableEnumeration;
            private Enumeration valueEnumeration;
            private Object nullValue;
            {
                this.subtableEnumeration = DoubleHashtable.this.table.elements();
                this.nullValue = DoubleHashtable.this;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.valueEnumeration == null || !this.valueEnumeration.hasMoreElements()) {
                    if (!this.subtableEnumeration.hasMoreElements()) {
                        return false;
                    }
                    this.valueEnumeration = ((Hashtable)this.subtableEnumeration.nextElement()).elements();
                }
                return true;
            }

            public Object nextElement() {
                this.hasMoreElements();
                Object value = this.valueEnumeration.nextElement();
                return value == this.nullValue ? null : value;
            }
        };
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private Iterator subtableIterator;
            private Map subtable;
            private Iterator valueIterator;
            private Object nullValue;
            {
                this.subtableIterator = DoubleHashtable.this.table.entrySet().iterator();
                this.nullValue = DoubleHashtable.this;
            }

            @Override
            public boolean hasNext() {
                if (this.valueIterator == null || !this.valueIterator.hasNext()) {
                    if (!this.subtableIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)this.subtableIterator.next();
                    this.subtable = (Map)entry.getValue();
                    this.valueIterator = this.subtable.entrySet().iterator();
                }
                return true;
            }

            public Object next() {
                this.hasNext();
                Map.Entry entry = (Map.Entry)this.valueIterator.next();
                Object value = entry.getValue();
                return value == this.nullValue ? null : value;
            }

            @Override
            public void remove() {
                this.valueIterator.remove();
                if (this.subtable.isEmpty()) {
                    this.subtableIterator.remove();
                }
            }
        };
    }

    public Hashtable get(Object key) {
        if (key == null) {
            key = this;
        }
        return (Hashtable)this.table.get(key);
    }

    public Object get(Object key, Object subKey) {
        Hashtable table;
        if (subKey == null) {
            subKey = this;
        }
        Object value = (table = this.get(key)) == null ? null : table.get(subKey);
        return value == this ? null : value;
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Enumeration keys() {
        return this.table.keys();
    }

    public Enumeration keys(Object key) {
        final Hashtable subtable = this.get(key);
        return new Enumeration(){
            private Enumeration subkeys;
            private Object nullKey;
            {
                this.subkeys = subtable == null ? null : subtable.keys();
                this.nullKey = DoubleHashtable.this;
            }

            @Override
            public boolean hasMoreElements() {
                return this.subkeys == null ? false : this.subkeys.hasMoreElements();
            }

            public Object nextElement() {
                if (this.subkeys == null) {
                    throw new NoSuchElementException();
                }
                Object subkey = this.subkeys.nextElement();
                return subkey == this.nullKey ? null : subkey;
            }
        };
    }

    public Object put(Object key, Object subKey, Object value) {
        Hashtable<Object, Object> subtable = this.get(key);
        if (subtable == null) {
            subtable = new Hashtable<Object, Object>();
            if (key == null) {
                key = this;
            }
            this.table.put(key, subtable);
        }
        if (subKey == null) {
            subKey = this;
        }
        if (value == null) {
            value = this;
        }
        Object old = subtable.get(subKey);
        subtable.put(subKey, value);
        return old == this ? null : old;
    }

    public Object remove(Object key, Object subKey) {
        Hashtable subtable = this.get(key);
        if (subtable == null) {
            return null;
        }
        if (subKey == null) {
            subKey = this;
        }
        Object old = subtable.remove(subKey);
        if (subtable.isEmpty()) {
            if (key == null) {
                key = this;
            }
            this.table.remove(key);
        }
        return old == this ? null : old;
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Hashtable subtable = this.get(key);
            size += subtable.size();
        }
        return size;
    }

    @Override
    public String toString() {
        return "DoubleHashtable@" + this.hashCode();
    }
}

