/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderCarrierController
extends SimuEPOSController {
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carrier")
    private LoaderCarrier carrier;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="loader")
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private SimuLoaderPlutoGateway plutoGateway;
    @LookupPath
    private String nodePath;

    public void init() {
        if (this.plutoGateway == null) {
            throw new RuntimeException("Invalid initialization. An instance of SimuAutochangerPlutoGateway should have been picked up from the Lookup tree from the siblinds of this node: " + this.nodePath);
        }
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)"loader carrier is moving.");
        FCSCst.FCSLOG.debug((Object)(this.name + "=>position intitiale=" + this.position));
        int stepsNB = 20;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            try {
                this.position = positionInitiale + i * step;
                this.carrier.updatePosition();
                if (this.position == this.carrier.getHandoffPosition()) {
                    FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (this.position == this.carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                this.loader.updateStateWithSensors();
                this.carrier.publishData();
                FCSCst.FCSLOG.debug((Object)(this.name + "i=" + i + ",position=" + this.position));
                try {
                    Thread.sleep(10L);
                    if (!this.carrier.getHaltRequired().get()) continue;
                    FCSCst.FCSLOG.debug((Object)(this.name + " STOP simulated carrrier motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    throw new RejectedCommandException(this.name + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                throw new RejectedCommandException(ex.getMessage());
            }
        }
        this.position = this.targetPosition;
        if (this.position == this.carrier.getHandoffPosition()) {
            FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (this.position == this.carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else if (this.position == this.carrier.getEngagedPosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtEngaged();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }
    }
}

