/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

public class CanOpenProxyTest
extends FCSTestTemplate {
    private static Subsystem subs;
    private static CanOpenProxy tcpProxy;
    private static final String deviceName1 = "device1";
    private static final String deviceName2 = "device2";
    private static final int nodeID1 = 586;
    private static final int nodeID2 = 12106;
    private static final int nodeID3 = 3;
    private static final String serial3 = "033fzbgt4";

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("        TESTS OF CanOpenProxy");
        System.out.println("***************************************");
        subs = BootUtils.getSubsystemFromFile((String)"testCanOpenProxy");
        subs.startAgent();
        ComponentLookup lookup = subs.getComponentLookup();
        tcpProxy = (CanOpenProxy)lookup.getComponentByPath("main");
        PieceOfHardware poh3 = (PieceOfHardware)CanOpenProxyTest.tcpProxy.hardwareMapByNodeID.get(3);
        Assert.assertEquals((String)"Serial number of node3", (Object)serial3, (Object)poh3.getSerialNB());
        Assert.assertTrue((String)"hardware should be ready", (boolean)tcpProxy.allDevicesBooted());
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("********* end of CanOpenProxy tests *************");
        subs.shutdownAgent();
    }

    @Before
    public void setUp() throws InterruptedException {
        Utils.printJoliSetUp("CanOpenProxyTest");
        ((AlertService)subs.getAgentService(AlertService.class)).clearAllAlerts();
        Assert.assertTrue((String)"subs is in state NOMINAL", (boolean)((AgentStateService)subs.getAgentService(AgentStateService.class)).isInState((Enum)AlertState.NOMINAL));
    }

    @Test
    public void testSetHardwareList() {
        System.out.println("#setHardwareList");
        Assert.assertEquals((String)"There is 3 devices in hardwareList.", (long)3L, (long)CanOpenProxyTest.tcpProxy.hardwareMapByNodeID.size());
    }

    @Test
    public void testGetNodeName() {
        System.out.println("#getNodeName");
        String expResult = deviceName1;
        String result = tcpProxy.getNodeName(586);
        Assert.assertEquals((String)"Name of device1 isdevice1", (Object)expResult, (Object)result);
        expResult = deviceName2;
        result = tcpProxy.getNodeName(12106);
        Assert.assertEquals((String)"Name of device2 isdevice2", (Object)expResult, (Object)result);
        int fakeNodeID = 65535;
        result = tcpProxy.getNodeName(fakeNodeID);
        System.out.println("Result=" + result);
        expResult = "UnknownDevice" + fakeNodeID;
        Assert.assertEquals((String)(fakeNodeID + "is unbooted."), (Object)expResult, (Object)result);
    }

    @Test
    public void testProcessBootMessage() {
        System.out.println("#processBootMessage");
        PieceOfHardware poh1 = (PieceOfHardware)CanOpenProxyTest.tcpProxy.hardwareMapByNodeID.get(586);
        Assert.assertTrue((String)"586 is booted", (boolean)poh1.isBooted());
        tcpProxy.onBootMessage(586);
        System.out.println("subsystem state=" + ((AgentStateService)subs.getAgentService(AgentStateService.class)).getState());
        Assert.assertTrue((String)("Received a boot message for node " + Integer.toHexString(586) + "so subsystem should be WARNING"), (boolean)((AgentStateService)subs.getAgentService(AgentStateService.class)).isInState((Enum)AlertState.WARNING));
    }

    @Test
    public void testProcessEmcyMessage() {
        System.out.println("#processEmcyMessage");
        try {
            tcpProxy.onEmergencyMessage(586, 0, 0);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.toString(), (boolean)(ex instanceof NullPointerException));
        }
        try {
            tcpProxy.onEmergencyMessage(26, 0, 0);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.toString(), (boolean)(ex instanceof NullPointerException));
        }
    }
}

