/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.awt.Color;
import java.io.Serializable;

public class FcsEnumerations {
    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color darkGreen = new Color(0, 100, 0);
    public static final Color chocolate = new Color(210, 105, 30);
    public static final Color royalblue = new Color(65, 105, 225);
    public static final Color lightblue = new Color(173, 216, 230);
    public static final Color magenta2 = new Color(238, 0, 238);
    public static final Color orange1 = new Color(255, 165, 0);
    public static final String FCS_NAME_FOR_MCM = "FILTER";
    public static final String AC_PLUTOGATEWAY_NAME = "acSensorsGateway";

    public static enum FcsAlert implements Serializable
    {
        UNSYNC_BOOT("A boot message has been received for a device."),
        EMCY("Received an EMERGENCY message from a device."),
        IN_FAULT("Controller in fault."),
        CAN_BUS_TIMEOUT("Timeout expired while waiting to response from CANbus"),
        CAN_BUS_READING_ERROR("Error in reading on CANbus"),
        HARDWARE_MISSING("HARDWARE NOT DETECTED - POWER FAILURE ?"),
        HARDWARE_ERROR("HARDWARE ERROR"),
        CA_LOCKING_ISSUE("CAROUSEL LOCKING ISSUE"),
        CA_LOCKING_RECOVERY_SUCCESS("CAROUSEL LOCKING RECOVERY SUCCESSFUL"),
        BAD_SERIAL_NB("Serial number read in CPU different from serial number in configuration"),
        PARAMETER_ERROR("ERROR in CPU controller for a parameter"),
        SDO_ERROR("Error in a request to a CANopen device"),
        SDO_TOO_SHORT("SDO request received a too short response"),
        READ_PDO_ERROR("Error in response to a sync command"),
        AC_SENSOR_ERROR("Autochanger sensors are in error"),
        CA_SENSOR_ERROR("Carousel sensors are in error"),
        LO_SENSOR_ERROR("Loader sensors are in error"),
        AC_TRUCKS_ERROR("Autochanger trucks ERROR"),
        UPDATE_ERROR("ERROR in updateStateWithSensors"),
        COMPLEMENTARY_SENSOR_ERROR("complementary sensors return same values");

        private final String longDescription;

        private FcsAlert(String longDescription) {
            this.longDescription = longDescription;
        }

        public String getLongDescription() {
            return this.longDescription;
        }
    }

    public static enum FilterReadinessState implements Serializable
    {
        NOT_READY,
        READY;

    }

    public static enum FilterState implements Serializable
    {
        MOVING_TRUCKS_TO_STANDBY,
        MOVING_TRUCKS_TO_ONLINE,
        MOVING_TRUCKS_TO_HANDOFF,
        TRUCKS_STOPPED,
        MOVING_TRUCKS,
        ROTATING,
        CAROUSEL_STOPPED,
        WAITING_FOR_HARWARE_BOOTING,
        CAN_DEVICES_BOOTING,
        READY,
        OFF_LINE,
        ONLINE_U,
        ONLINE_G,
        ONLINE_R,
        ONLINE_I,
        ONLINE_Z,
        ONLINE_Y,
        ONLINE_EF,
        ONLINE_A,
        ONLINE_DU1,
        ONLINE_DU2,
        ONLINE_DR1,
        ONLINE_DZ1,
        ONLINE_DZ2,
        ONLINE_DA1,
        ONLINE_DA2,
        ONLINE_TU,
        ONLINE_TY,
        ONLINE_OA,
        ONLINE_OB,
        ONLINE_OC,
        ONLINE_F15,
        ONLINE_F17,
        ONLINE_F29,
        ONLINE_F3,
        ONLINE_F34,
        ONLINE_F46,
        ONLINE_F48,
        ONLINE_F60;

    }

    public static enum MobileItemAction {
        UNLOCK("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),
        UNLOCKCLAMPS("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASECLAMPS("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        ROTATE_CAROUSEL_TO_RELATIVE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        OPEN("OPENING LATCH", "IS OPENED", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        CLOSE_ONLINECLAMP_MODE_CURRENT("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        LOCK_ONLINECLAMP("LOCKING ONLINECLAMP", "IS LOCKED", "COULD NOT LOCK ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        REOPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_PROFILE_POSITION("OPENING ONLINECLAMP", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        UNLOCK_ONLINECLAMP("UNLOCKING ONLINECLAMP", "IS UNLOCKED", "COULD NOT UNLOCK ONLINECLAMP"),
        MOVE_TO_STANDBY_POSITION_WITH_FCS("MOVING TO STANDBY POSITION WITH FCS", "STANDBY POSITION WITH FCS REACHED", "COULD NOT MOVE TO STANDBY POSITION WITH FCS"),
        MOVE_TO_ABSOLUTE_POSITION("MOVING TO ABSOLUTE POSITION", "ABSOLUTE POSITION REACHED", "COULD NOT MOVE TO ABSOLUTE POSITION"),
        MOVE_TO_ABSOLUTE_POSITION_NO_BREAK("MOVING TO ABSOLUTE POSITION NO BREAK", "ABSOLUTE POSITION REACHED", "COULD NOT MOVE TO ABSOLUTE POSITION"),
        MOVE_TO_RELATIVE_POSITION("MOVING TO RELATIVE POSITION", "RELATIVE POSITION REACHED", "COULD NOT MOVE TO RELATIVE POSITION"),
        ALIGN_SLAVE("ALIGNING SLAVE", "SLAVE ALIGNED", "COULD NOT ALIGN SLAVE"),
        MOVE_SLAVE_TRUCK_ALONE("MOVING SLAVE_TRUCK", "SLAVE_TRUCK MOVED", "COULD NOT MOVE SLAVE_TRUCK"),
        MOVE_TRUCK_XPLUS("MOVING TRUCK_XPLUS", "TRUCK_XPLUS MOVED", "COULD NOT MOVE TRUCK_XPLUS"),
        UNCLAMPLOADERHOOKS("LOADER CLAMP UNCLAMPING", "HOOKS ARE UNCLAMPED", "COULD NOT UNCLAMP"),
        OPENLOADERHOOKS("OPENING LOADER HOOKS", "LOADER HOOKS ARE OPEN", "COULD NOT OPEN LOADER HOOKS"),
        OPENHOMINGLOADERHOOKS("OPENING LOADER HOOKS", "LOADER HOOKS ARE OPEN", "COULD NOT OPEN LOADER HOOKS"),
        CLOSELOADERHOOKS("CLOSING LOADER HOOKS", "LOADER HOOKS ARE CLOSED", "COULD NOT CLOSE LOADER HOOKS"),
        CLAMPLOADERHOOKS("CLAMPING LOADER HOOKS", "LOADER HOOKS ARE CLAMPED", "COULD NOT CLAMP LOADER HOOKS"),
        MOVE_HOOKS_TO_ABSOLUTE_POSITION("MOVING LOADER CLAMP TO POSITION", "ABSOLUTE POSITION REACHED", "COULD NOT MOVEDLOADER CLAMP TO ABSOLUTE POSITION"),
        MOVE_LOADERCARRIER_TO_STORAGE("MOVING LOADER CARRIER TO STORAGE", "LOADER CARRIER IS AT STORAGE POSITION", "COULD NOT MOVE LOADER CARRIER TO STORAGE POSITION"),
        MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION("MOVING LOADER CARRIER TO ABSOLUTE POSITION", "LOADER CARRIER IS AT REQUIRED POSITION", "COULD NOT MOVE LOADER CARRIER TO REQUIRED POSITION"),
        MOVE_LOADERCARRIER_TO_HANDOFF("MOVING LOADER CARRIER TO HANDOFF", "LOADER CARRIER IS AT HANDOFF POSITION", "COULD NOT MOVE LOADER CARRIER TO HANDOFF POSITION"),
        MOVE_LOADERCARRIER_TO_ENGAGED("MOVING LOADER CARRIER TO ENGAGED", "LOADER CARRIER IS AT ENGAGED POSITION", "COULD NOT MOVE LOADER CARRIER TO ENGAGED POSITION");

        private final String shortDescription;
        private final String doneActionMsg;
        private final String failureMsg;

        private MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.shortDescription = aString;
            this.doneActionMsg = aDoneString;
            this.failureMsg = aFailureMsg;
        }

        public String toString() {
            return this.shortDescription;
        }

        public String doneString() {
            return this.doneActionMsg;
        }

        public String getFailureMsg() {
            return this.failureMsg;
        }
    }

    public static enum SlaveModuleStatus implements ColoredObject
    {
        UNKNOWN_STATUS(0, Color.RED),
        IS_SOCKET_AT_STANDBY(1, greenColor),
        IS_READY_NOT_IN_POSITION(2, Color.BLUE),
        ERROR_READING_POSITION(3, Color.red),
        SAFE_STATE(4, Color.RED),
        BOOTING(5, orange1),
        NOT_POWERED_ON(6, Color.RED),
        NOT_WORKING_FOR_OTHER_REASON(7, chocolate);

        private final int status;
        private final Color color;

        private SlaveModuleStatus(int status, Color color) {
            this.status = status;
            this.color = color;
        }

        public int getStatus() {
            return this.status;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public static SlaveModuleStatus getStatusByCode(int s) {
            SlaveModuleStatus[] codes = SlaveModuleStatus.values();
            SlaveModuleStatus status = null;
            for (SlaveModuleStatus slaveStatus : codes) {
                if (slaveStatus.getStatus() != s) continue;
                status = slaveStatus;
            }
            if (status == null) {
                throw new IllegalArgumentException(s + ": this status doesn't exist in SlaveModuleStatus ENUM");
            }
            return status;
        }
    }

    public static enum FilterClampState implements ColoredObject
    {
        READYTOCLAMP(Color.blue, "READY TO CLAMP"),
        UNCLAMPEDONFILTER(chocolate, "UNCLAMPED ON FILTER"),
        UNCLAMPEDEMPTY(royalblue, "UNCLAMPED AND EMPTY"),
        CLAMPEDONFILTER(greenColor, "CLAMPED ON FILTER"),
        UNDEFINED(Color.orange, "UNDEFINED"),
        ERROR(Color.red, "IN ERROR"),
        UNLOCKABLE(magenta2, "FILTER UNLOCKABLE");

        private final String shortDescription;
        private final Color color;

        private FilterClampState(Color color, String aString) {
            this.shortDescription = aString;
            this.color = color;
        }

        public String toString() {
            return this.shortDescription;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    public static enum LoaderCarrierLocation {
        STORAGE,
        HANDOFF,
        UNKNOWN,
        ERROR;

    }

    public static enum AutoChangerTrucksLocation {
        STANDBY,
        STANDBACK,
        HANDOFF,
        ONLINE,
        UNKNOWN,
        ERROR;

    }

    public static enum FilterFamily {
        S("Science Filter"),
        D("Dummy Filter"),
        F("French Dummy Filter"),
        T("Test Filter LNL"),
        O("Open / Non Attributed Filter");

        private final String familyName;

        private FilterFamily(String familyName) {
            this.familyName = familyName;
        }

        public String getFamilyName() {
            return this.familyName;
        }
    }

    public static enum BrakeState {
        CLOSED,
        NOBRAKE,
        NO_SENSOR;

    }

    public static enum LockStatus implements ColoredObject
    {
        UNLOCKED(Color.blue, "UNLOCKED"),
        LOCKED(greenColor, "LOCKED"),
        UNKNOWN(Color.orange, "UNKNOWN"),
        ERROR(Color.red, "IN ERROR"),
        RELAXED(lightblue, "RELAXED"),
        OPENED(Color.blue, "OPENED"),
        CLOSED(greenColor, "CLOSED"),
        CLAMPED(darkGreen, "CLAMPED"),
        UNCLAMPED(Color.blue, "UNCLAMPED"),
        UNDER_CLAMPED(Color.YELLOW, "UNDER LOAD"),
        OVER_CLAMPED(Color.RED, " OVER LOAD"),
        INTRAVEL(Color.YELLOW, "IN TRAVEL"),
        NOERROR(Color.GREEN, "NO ERROR");

        private final Color color;
        private final String text;

        private LockStatus(Color color, String text) {
            this.color = color;
            this.text = text;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum FilterPresenceStatus implements ColoredObject
    {
        NOFILTER(Color.DARK_GRAY),
        ENGAGED(chocolate),
        LOCKABLE(greenColor),
        NOT_LOCKABLE(Color.blue),
        ERROR(Color.red),
        UNKNOWN(Color.YELLOW);

        private final Color color;

        private FilterPresenceStatus(Color color) {
            this.color = color;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    @FunctionalInterface
    public static interface ColoredObject {
        public Color getColor();
    }
}

