/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerTruck;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.ActionGuard;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerTwoTrucks
extends MobileItem
implements ClearAlertHandler {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    private AutochangerTruck truckXminus;
    private AutochangerTruck truckXplus;
    @ConfigurationParameter(description="minimal position for AC trucks", units="microns", category="autochanger")
    private volatile int minActualPositionValue = 0;
    @ConfigurationParameter(description="maximal position for AC trucks", units="microns", category="autochanger")
    private volatile int maxActualPositionValue = 1200000;
    @ConfigurationParameter(description="STANDBY position to be used to store a filter on carousel", units="microns", category="autochanger")
    private volatile int standbyPosition = 997500;
    @ConfigurationParameter(description="STANDBY position to be used when grabing a filter on Carousel", units="microns", category="autochanger")
    private volatile int standbyPositionEmpty = 997500;
    @ConfigurationParameter(description="HANDOFF position", units="microns", category="autochanger")
    private volatile int handoffPosition = 70000;
    @ConfigurationParameter(description="ONLINE position", units="microns", category="autochanger")
    private volatile int onlinePosition = 2600;
    @ConfigurationParameter(description="time for trucks motion from ONLINE to STANDBY", units="milliseconds", category="autochanger")
    private volatile long timeoutForTrucksMotion = 20000L;
    @ConfigurationParameter(description="time to align slave on master controller", units="milliseconds", category="autochanger")
    private volatile long timeoutForAlignSlave = 5000L;
    @ConfigurationParameter(description="prelimary ONLINE position, used by process whichmoves a filter at ONLINE position.", units="microns", category="autochanger")
    private volatile int prelimaryTargetPosition = 3367;
    @ConfigurationParameter(description="natural position at ONLINE position used by process whichmoves a filter at ONLINE position.", units="microns", category="autochanger")
    private volatile int naturalPosition = 3215;
    @ConfigurationParameter(description="lowest position to be used by command moveAndClampFilterOnline.", units="microns", category="autochanger")
    private volatile int minTargetPosition = 1800;
    @ConfigurationParameter(description="minimum value of voltage read on proximitySensor.", units="V", category="autochanger")
    private volatile double umin = 4.2;
    @ConfigurationParameter(description="maximum value of voltage read on proximitySensor.", units="V", category="autochanger")
    private volatile double umax = 4.6;
    @ConfigurationParameter(description="voltage target on proximitySensor.", units="V", category="autochanger")
    private volatile double utarget = 3.85;
    @ConfigurationParameter(description="adjustment factor.", units="microns/V", category="autochanger")
    private volatile double adjustmentFactor = 835.0;
    @ConfigurationParameter(description="low speed to approach STANDBY position", category="autochanger")
    private volatile int lowSpeed = 50;
    @ConfigurationParameter(description="high speed to approach STANDBY position", category="autochanger")
    private volatile int highSpeed = 260;
    @ConfigurationParameter(description="low acceleration to approach STANDBY position", category="autochanger")
    private volatile int lowAcceleration = 150;
    @ConfigurationParameter(description="high acceleration to approach STANDBY position", category="autochanger")
    private volatile int highAcceleration = 310;
    @ConfigurationParameter(description="low deceleration to approach STANDBY position", category="autochanger")
    private volatile int lowDeceleration = 50;
    @ConfigurationParameter(description="high deceleration to approach STANDBY position", category="autochanger")
    private volatile int highDeceleration = 310;
    @ConfigurationParameter(description="approach STANDBY position", units="microns", category="autochanger")
    private volatile int approachStandbyPosition = 950000;
    @ConfigurationParameter(description="approach ONLINE position", units="microns", category="autochanger")
    private volatile int approachOnlinePosition = 10000;
    private int current = 0;
    private int speed = 0;
    private long profileVelocity;
    private int masterPosition;
    private int slavePosition;
    private int deltaPosition;
    private int positionRange = 100;
    @ConfigurationParameter(description="position is reached at STANDBY if |targetPosition - masterPosition| < positionRangeAtStandby", units="microns", category="autochanger")
    private volatile int positionRangeAtStandby = 100;
    @ConfigurationParameter(description="position is reached at ONLINE if |targetPosition - masterPosition| < positionRangeAtOnline", units="microns", category="autochanger")
    private volatile int positionRangeAtOnline = 50;
    @ConfigurationParameter(description="position is reached at HANDOFF if |targetPosition - masterPosition| < positionRangeAtOnline", units="microns", category="autochanger")
    private volatile int positionRangeAtHandoff = 100;
    @ConfigurationParameter(description="position is reached in TRAVEL if |targetPosition - masterPosition| < positionRangeAtOnline", units="microns", category="autochanger")
    private volatile int positionRangeInTravel = 150;
    @ConfigurationParameter(description="an alignment of slave must be done when |deltaPosition| > deltaPositionMax", units="microns", category="autochanger")
    private volatile int deltaPositionMax = 100;
    private volatile int deltaPositionForAlignStrict = 200;
    private volatile int deltaPositionForAlignLenient = 400;
    private int absoluteTargetPosition = 0;
    private int slaveTargetPosition = 0;
    private EPOSControllerForLinearRail linearRailMasterController;
    private EPOSControllerForLinearRail linearRailSlaveController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*proximitySensorsDevice")
    private ADCInterface proximitySensorsDevice;
    @ConfigurationParameter(description="input number on the ADC where proximity sensor is plugged", range="1..4", units="unitless", category="autochanger")
    private volatile int proximitySensorInput = 1;
    private boolean atHandoff = false;
    private boolean atOnline = false;
    private boolean atStandby = false;

    public AutochangerTwoTrucks(AutochangerTruck truckXminus, AutochangerTruck truckXplus, EPOSControllerForLinearRail linearRailMasterController, EPOSControllerForLinearRail linearRailSlaveController) {
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
        this.linearRailMasterController = linearRailMasterController;
        this.linearRailSlaveController = linearRailSlaveController;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutoChangerTrucks.class, this.name);
    }

    @ConfigurationParameterChanger
    public void setNaturalPosition(int pos) {
        int minLimit = this.onlinePosition - 1500;
        int maxLimit = this.onlinePosition + 1500;
        if (pos < minLimit || pos > maxLimit) {
            throw new IllegalArgumentException(pos + " bad value for natural position must be > " + minLimit + " and < " + maxLimit);
        }
        this.naturalPosition = pos;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return actual trucks position (master position). Doesn't read again the position on the controller.")
    public int getPosition() {
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return HANDOFF position. Doesn't read again the position on the controller.")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return STANDBY position. Doesn't read again the position on the controller.")
    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return ONLINE position. Doesn't read again the position on the controller.")
    public int getOnlinePosition() {
        return this.onlinePosition;
    }

    public int getApproachStandbyPosition() {
        return this.approachStandbyPosition;
    }

    public int getApproachOnlinePosition() {
        return this.approachOnlinePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return timeout for trucks motion.")
    public long getTimeoutForTrucksMotion() {
        return this.timeoutForTrucksMotion;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.atHandoff;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.atOnline;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.atStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the homing of the trucks has been done.")
    public boolean isHomingDone() {
        return this.linearRailSlaveController.isHomingDone() && this.linearRailMasterController.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if TruckXminus position sensors or TruckXminus position sensors are in error.")
    public boolean isPositionSensorsInError() {
        return this.truckXminus.isPositionSensorsInError() || this.truckXplus.isPositionSensorsInError() || this.positionSensorsNonConsistant();
    }

    private boolean positionSensorsNonConsistant() {
        return this.isAtStandby() && this.isAtHandoff() || this.isAtStandby() && this.isAtOnline() || this.isAtHandoff() && this.isAtOnline();
    }

    public boolean isPositionSensorErrorsTransient() {
        int delta = 5000;
        boolean errorHandoff = this.truckXminus.isHandoffSensorsInError() || this.truckXplus.isHandoffSensorsInError();
        boolean errorOnline = this.truckXminus.isOnlineSensorsInError() || this.truckXplus.isOnlineSensorsInError();
        boolean errorStandby = this.truckXminus.isStandbySensorsInError() || this.truckXplus.isStandbySensorsInError();
        return errorHandoff && Math.abs(this.masterPosition - this.handoffPosition) < delta || errorOnline && Math.abs(this.masterPosition - this.onlinePosition) < delta || errorStandby && Math.abs(this.masterPosition - this.standbyPosition) < delta;
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.linearRailSlaveController.isBooted() && this.linearRailMasterController.isBooted()) {
            this.initializeControllers();
            this.linearRailSlaveController.updateEposState();
            this.linearRailMasterController.updateEposState();
        }
        if (this.proximitySensorsDevice.isBooted()) {
            this.proximitySensorsDevice.initializeAndCheckHardware();
            this.proximitySensorsDevice.publishData();
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " can't clamp at ONLINE if proximitySensorsDevice not booted", this.name);
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    public void initializeControllers() {
        try {
            this.linearRailSlaveController.initializeAndCheckHardware();
            this.linearRailMasterController.initializeAndCheckHardware();
            this.homing();
            FCSLOG.info((Object)(this.name + " homing of AC trucks done."));
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Couldn't initialize controllers or do homing", this.name, (Exception)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() {
        FCSLOG.info((Object)(this.name + " Begin configuration of the controllers"));
        this.linearRailMasterController.configureDigitalInputOfLinearRails();
        this.linearRailSlaveController.configureDigitalInputOfLinearRails();
        this.linearRailMasterController.configureDigitalOutputOfLinearRails();
        this.linearRailSlaveController.configureDigitalOutputOfLinearRails();
        FCSLOG.info((Object)(this.name + " End configuration of the controllers"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if both controllers are initialized and homing of trucks are done.")
    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized() && this.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the motion of trucks are allowed.")
    public void checkConditionsForTrucksMotion() {
        this.autochanger.checkFilterSafetyBeforeMotion();
        this.checkPrerequisitesForTrucksMotion();
    }

    private void checkPrerequisitesForTrucksMotion() {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.name + " can't move autochanger trucks because controllers are not both initialized:\n";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        this.updatePosition();
        this.checkDeltaPosition();
    }

    public void goToHandOff() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("goToHandOff");){
            this.moveToAbsoluteTargetPosition(this.handoffPosition);
        }
    }

    public void goToOnline() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("goToOnline");){
            this.moveToAbsoluteTargetPosition(this.onlinePosition);
        }
    }

    public void goToStandby() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("goToOnline");){
            this.moveToAbsoluteTargetPosition(this.standbyPosition);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Move Autochanger trucks to the absolute position given as argument. At the end of motion : doesn't align slave then activate brakes and disable controllers.", alias="mobeABSPos", timeout=20000)
    public void moveToAbsoluteTargetPosition(int targetPosition) {
        block36: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToAbsoluteTargetPosition");){
                if (targetPosition < this.minActualPositionValue || targetPosition > this.maxActualPositionValue) {
                    throw new IllegalArgumentException(this.name + "argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
                }
                this.updatePosition();
                if (this.masterPosition == targetPosition) {
                    FCSLOG.info((Object)(this.name + " is already at target position=" + targetPosition));
                    break block36;
                }
                try (ReleasedACBrakes g = new ReleasedACBrakes();){
                    this.checkConditionsForTrucksMotion();
                    this.checkControllersMode();
                    this.checkReadyForAction();
                    this.absoluteTargetPosition = targetPosition;
                    FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
                    if (this.absoluteTargetPosition == this.handoffPosition) {
                        this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_HANDOFF);
                        this.positionRange = this.positionRangeAtHandoff;
                    } else if (this.absoluteTargetPosition == this.standbyPosition) {
                        this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY);
                        this.positionRange = this.positionRangeAtStandby;
                    } else if (this.absoluteTargetPosition == this.onlinePosition) {
                        this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE);
                        this.positionRange = this.positionRangeAtOnline;
                    } else if (this.absoluteTargetPosition < this.prelimaryTargetPosition) {
                        this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS);
                        this.positionRange = this.positionRangeAtOnline;
                    } else {
                        if (this.masterPosition > this.absoluteTargetPosition) {
                            this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE);
                        } else {
                            this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY);
                        }
                        this.positionRange = this.positionRangeInTravel;
                    }
                    FCSLOG.info((Object)(this.name + " accuracy of motion = " + this.positionRange + "microns"));
                    this.goToPosition(this.absoluteTargetPosition);
                    this.checkPositionSensors();
                    this.main.updateAgentState(FcsEnumerations.FilterState.TRUCKS_STOPPED);
                    this.publishData();
                }
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Move Autochanger trucks to the absolute position given as argument. At the end of motion : doesn't align slave then activate brakes and disable controllers VERY DANGEROUS COMMAND. Only for tests with prototype.", timeout=20000)
    public void moveToAbsoluteTargetPositionDangerous(int targetPosition) {
        if (targetPosition < this.minActualPositionValue || targetPosition > this.maxActualPositionValue) {
            throw new IllegalArgumentException(this.name + " argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
        }
        this.updatePosition();
        if (this.masterPosition == targetPosition) {
            FCSLOG.info((Object)(this.name + " is already at target position=" + targetPosition));
        } else {
            this.checkPrerequisitesForTrucksMotion();
            this.checkControllersMode();
            this.checkReadyForAction();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
            if (this.absoluteTargetPosition == this.handoffPosition) {
                this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_HANDOFF);
            } else if (this.absoluteTargetPosition == this.standbyPosition) {
                this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY);
            } else if (this.absoluteTargetPosition == this.onlinePosition) {
                this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE);
            } else {
                this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS);
            }
            this.goToPosition(this.absoluteTargetPosition);
            this.checkPositionSensors();
            this.main.updateAgentState(FcsEnumerations.FilterState.TRUCKS_STOPPED);
            this.publishData();
        }
    }

    public void moveAndClampFilterOnline() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveAndClampFilterOnline");){
            try (ReleasedACBrakes g = new ReleasedACBrakes();){
                this.moveToApproachOnlinePositionWithHighVelocity();
                this.autochanger.waitForProtectionSystemUpdate();
                this.alignSlaveStrict();
                this.moveToTargetOnlinePosition();
            }
            this.autochanger.getOnlineClamps().lockFilterAtOnline();
            this.releaseTruckTensionOnClamps();
            this.autochanger.updateFCSStateToReady();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Compute the actual online target position")
    public int findTargetOnlinePosition() {
        this.updatePosition();
        if (Math.abs(this.masterPosition - this.prelimaryTargetPosition) > this.deltaPositionMax) {
            throw new RejectedCommandException(this.name + "Invalid position for this command. Should be in preliminaryTargetPosition to be executed.");
        }
        double umeasured = this.readProximitySensorDevice();
        int newTargetPosition = (int)((double)this.prelimaryTargetPosition + this.adjustmentFactor * (this.utarget - umeasured));
        FCSLOG.info((Object)(this.name + " computed new target online position=" + newTargetPosition));
        newTargetPosition = Math.max(this.minTargetPosition, newTargetPosition);
        FCSLOG.info((Object)(this.name + " final new target online position=" + newTargetPosition));
        return newTargetPosition;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Move a filter slowly to preliminaryTargetPosition, then computes the new target position and finally reaches it", timeout=5000)
    public void moveToTargetOnlinePosition() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToTargetOnlinePosition");
             ReleasedACBrakes g = new ReleasedACBrakes();){
            this.slowProfile();
            this.moveToAbsoluteTargetPosition(this.prelimaryTargetPosition);
            int newTargetPosition = this.findTargetOnlinePosition();
            this.moveToAbsoluteTargetPosition(newTargetPosition);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Release the tension on the clamps after they are locked by moving the trucks to a move natural position than the computed Online postion.", timeout=2000)
    public void releaseTruckTensionOnClamps() {
        double umeasured = this.readProximitySensorDevice();
        if (umeasured > this.umax) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too high.");
        } else if (umeasured < this.umin) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too low.");
        }
        this.goToPosition(this.naturalPosition);
        FCSLOG.info((Object)(this.name + " END process docking ONLINE."));
    }

    public void moveFilterToStandby() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveFilterToStandby");){
            this.updatePosition();
            this.autochanger.updateStateWithSensors();
            if (!this.atHandoff && !this.atOnline) {
                throw new RejectedCommandException(this.name + "AC should be at Online or Handoff position");
            }
            this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY);
            if (!this.atOnline) {
                this.alignSlaveLenient();
            }
            try (ReleasedACBrakes g = new ReleasedACBrakes();){
                if (this.atOnline) {
                    this.moveToApproachOnlinePositionWithLowVelocity();
                    this.alignSlaveLenient();
                }
                this.moveToApproachStandbyPositionWithHighVelocity();
                this.alignSlaveStrict();
                this.moveToStandbyWithLowVelocity();
                FCSLOG.info((Object)("filter ID on AC after moveToStandbyWithLowVelocity = " + this.autochanger.getFilterID()));
                this.publishData();
            }
        }
    }

    public void moveToApproachStandbyPositionWithLowVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachStandbyPositionWithLowVelocity");){
            this.slowProfile();
            this.moveToAbsoluteTargetPosition(this.approachStandbyPosition);
        }
    }

    public void moveToApproachOnlinePositionWithLowVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachOnlinePositionWithLowVelocity");){
            this.slowProfile();
            this.moveToAbsoluteTargetPosition(this.approachOnlinePosition);
        }
    }

    public void alignSlaveAndMoveEmptyFromApproachToHandoff() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("alignSlaveAndMoveEmptyFromApproachToHandoff");){
            this.alignSlaveStrict();
            this.fastProfile();
            this.moveToAbsoluteTargetPosition(this.handoffPosition);
        }
    }

    public void moveToApproachStandbyPositionWithHighVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachStandbyPositionWithHighVelocity");){
            this.fastProfile();
            this.moveToAbsoluteTargetPosition(this.approachStandbyPosition);
        }
    }

    public void moveToApproachOnlinePositionWithHighVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachOnlinePositionWithHighVelocity");){
            this.fastProfile();
            this.moveToAbsoluteTargetPosition(this.approachOnlinePosition);
        }
    }

    public void moveToStandbyWithLowVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToStandbyWithLowVelocity");){
            FCSLOG.info((Object)(this.name + " === moveToStandbyWithLowVelocity ==="));
            this.slowProfile();
            if (this.autochanger.isEmpty()) {
                this.moveToAbsoluteTargetPosition(this.standbyPositionEmpty);
            } else {
                this.moveToAbsoluteTargetPosition(this.standbyPosition);
            }
        }
    }

    public void moveToStandbyEmptyWithLowVelocity() {
        FCSLOG.info((Object)(this.name + " === moveToStandbyEmptyWithLowVelocity ==="));
        this.slowProfile();
        this.moveToAbsoluteTargetPosition(this.standbyPositionEmpty);
    }

    public void moveToHandoffWithHighVelocity() {
        this.fastProfile();
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    private void goToPosition(int targetPosition) {
        try (ReleasedACBrakes g = new ReleasedACBrakes();){
            FCSLOG.info((Object)(this.name + " moving to position " + targetPosition));
            if (!this.isHomingDone()) {
                this.homing();
            }
            this.absoluteTargetPosition = targetPosition;
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, this.timeoutForTrucksMotion);
            this.main.updateAgentState(FcsEnumerations.FilterState.TRUCKS_STOPPED);
            this.main.updateStateWithSensors();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Activate brakes and disable the 2 controllers.")
    public void activateBrakesAndDisable() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("2Trucks-activateBrakesAndDisable");){
            FcsUtils.parallelRun(() -> this.linearRailMasterController.activateBrake(), () -> this.linearRailSlaveController.activateBrake());
            FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeLR(), this.name);
            this.disableAllRails();
        }
    }

    private void disableAllRails() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("2Trucks-disableAllRails");){
            FcsUtils.parallelRun(() -> this.linearRailMasterController.goToSwitchOnDisabled(), () -> this.linearRailSlaveController.goToSwitchOnDisabled());
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.autochanger.checkLinearRailMotionAllowed();
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: 
            case MOVE_TO_ABSOLUTE_POSITION_NO_BREAK: {
                this.checkControllersMode();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord(63);
                break;
            }
            case ALIGN_SLAVE: {
                this.linearRailSlaveController.enableAndReleaseBrake();
                this.linearRailSlaveController.writeTargetPosition(this.slaveTargetPosition);
                this.linearRailSlaveController.writeControlWord(63);
                break;
            }
            case MOVE_SLAVE_TRUCK_ALONE: {
                this.linearRailSlaveController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailSlaveController.writeControlWord(63);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.name + " ABORTING action: " + action.toString() + " within delay " + delay));
        if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION || action == FcsEnumerations.MobileItemAction.MOVE_TO_STANDBY_POSITION_WITH_FCS) {
            this.quickStopAction(action, 0L);
        } else if (action == FcsEnumerations.MobileItemAction.ALIGN_SLAVE) {
            this.stopAlignSlave();
        }
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.info((Object)(this.name + " ENDING action: " + action.toString()));
        this.autochanger.updateStateWithSensors();
        if (action != FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION) {
            if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION_NO_BREAK) {
                FCSLOG.info((Object)(this.name + " nothing to do for action MOVE_TO_ABSOLUTE_POSITION_NO_BREAK"));
            } else if (action == FcsEnumerations.MobileItemAction.ALIGN_SLAVE) {
                this.stopAlignSlave();
            }
        }
        this.linearRailMasterController.checkFault();
        this.linearRailSlaveController.checkFault();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.linearRailMasterController.quickStop();
        this.linearRailSlaveController.quickStop();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Enable and release brake for the 2 controllers.")
    public void enableControllersAndReleaseBrake() {
        FcsUtils.parallelRun(() -> {
            this.linearRailMasterController.goToOperationEnable();
            this.linearRailMasterController.doReleaseBrake();
        }, () -> {
            this.linearRailSlaveController.goToOperationEnable();
            this.linearRailSlaveController.doReleaseBrake();
        });
    }

    private void checkControllersMode() {
        if (!this.linearRailMasterController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.name + " : linearRailMasterController is not in PROFILE_POSITION mode, can't move.");
        }
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER)) {
            throw new FcsHardwareException(this.name + " : linearRailSlaveController is not in MASTER_ENCODER mode, can't move. Slave controller mode =" + this.linearRailSlaveController.getMode());
        }
    }

    public void alignSlave(boolean lenient) {
        block27: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("alignSlave");){
                this.updatePosition();
                if (!this.isHomingDone()) {
                    this.homing();
                }
                int deltaMax = lenient ? this.deltaPositionForAlignLenient : this.deltaPositionForAlignStrict;
                FCSLOG.info((Object)("alignSlave delta " + this.deltaPosition + " (max " + deltaMax + ") " + (Math.abs(this.deltaPosition) > deltaMax ? "ALIGN" : "no align")));
                if (Math.abs(this.deltaPosition) <= deltaMax) break block27;
                try (ActivatedACBrakes g = new ActivatedACBrakes();){
                    if (this.linearRailMasterController.isEnabled()) {
                        FCSLOG.info((Object)"!!! master controller was enabled");
                        this.activateBrakesAndDisable();
                    }
                    if (this.linearRailMasterController.isEnabled()) {
                        FCSLOG.warn((Object)"!!! master controller was STILL enabled");
                        throw new FcsHardwareException(this.name + " master controller must be disabled.");
                    }
                    this.doAlignSlave(this.masterPosition);
                }
            }
        }
    }

    public void alignSlaveLenient() {
        this.alignSlave(true);
    }

    public void alignSlaveStrict() {
        this.alignSlave(false);
    }

    private void stopAlignSlave() {
        FCSLOG.info((Object)(this.name + " STOP ALIGN SLAVE"));
        this.linearRailSlaveController.activateBrake();
        FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeLR(), this.name);
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        this.linearRailSlaveController.goToSwitchOnDisabled();
        FCSLOG.info((Object)(this.name + " END STOP ALIGN SLAVE"));
    }

    private void doAlignSlave(int pos) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("doAlignSlave");){
            this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            FCSLOG.info((Object)(this.name + " slave's alignment to be done. deltaPosition= " + this.deltaPosition));
            if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
                throw new FcsHardwareException(this.name + " can't align slave truck because couldn't change its mode to PROFILE_POSITION.");
            }
            this.slaveTargetPosition = pos;
            this.executeAction(FcsEnumerations.MobileItemAction.ALIGN_SLAVE, this.timeoutForAlignSlave);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Move truckXminus (slave controller) independently of truckXplus (master controller). To be used with final products AC1 and AC2.Don't use with prototype.")
    public void moveTruckXminus(int newPos) {
        int slavePos = this.linearRailSlaveController.readPosition();
        if (Math.abs(slavePos - newPos) >= 2000) {
            throw new IllegalArgumentException(this.name + " newPos must be such as |newPos - slavePosition| < 2000");
        }
        this.activateBrakesAndDisable();
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.absoluteTargetPosition = newPos;
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_SLAVE_TRUCK_ALONE, this.timeoutForTrucksMotion);
    }

    public void checkPositionSensors() {
        this.autochanger.updateStateWithSensors();
        if (this.absoluteTargetPosition == this.standbyPosition && !this.atStandby) {
            throw new FailedCommandException(this.name + ": check with sensors: STANDBY sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.atHandoff) {
            FCSLOG.info((Object)("this.absoluteTargetPosition=" + this.absoluteTargetPosition));
            FCSLOG.info((Object)("this.handoffPosition=" + this.handoffPosition));
            FCSLOG.info((Object)("this.atHandoff=" + this.atHandoff));
            throw new FailedCommandException(this.name + ": check with sensors: HANDOFF sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.onlinePosition && !this.atOnline) {
            throw new FailedCommandException(this.name + ": check with sensors: ONLINE sensors don't confirm trucks position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Do homing for both  controllers.")
    public void homing() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("AC2Trucks-homing");){
            this.linearRailMasterController.homing();
            this.linearRailSlaveController.homing();
            this.updatePosition();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() {
        this.truckXminus.updatePosition();
        this.truckXplus.updatePosition();
        this.masterPosition = this.linearRailMasterController.getPosition();
        this.slavePosition = this.linearRailSlaveController.getPosition();
        this.deltaPosition = this.masterPosition - this.slavePosition;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read position on controllers then compute difference and throw exceptionif difference is > 1000.")
    public void checkDeltaPosition() {
        this.updatePosition();
        if (Math.abs(this.deltaPosition) > 1000) {
            String msg = "Too much difference between trucks position. Alignment of Slave Truck to be done.";
            throw new FcsHardwareException(this.name + ":" + msg);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update trucks position in reading controller and return position.")
    public int readPosition() {
        this.updatePosition();
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return a voltage in mV which represents a distance between between filterand filter beam.")
    public double readProximitySensorDevice() {
        return this.proximitySensorsDevice.readVoltage(this.proximitySensorInput);
    }

    @Override
    public boolean myDevicesReady() {
        return this.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: 
            case MOVE_TO_ABSOLUTE_POSITION_NO_BREAK: {
                FCSLOG.info((Object)(this.name + " /masterPosition=" + this.masterPosition + " /position to reach = " + this.absoluteTargetPosition + " /positionRange = " + this.positionRange));
                return Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
            case ALIGN_SLAVE: {
                FCSLOG.info((Object)(this.name + " linearRailSlaveController.isTargetReached()=" + this.linearRailSlaveController.isTargetReached() + " /masterPosition=" + this.masterPosition));
                return this.linearRailSlaveController.isTargetReached();
            }
            case MOVE_SLAVE_TRUCK_ALONE: {
                return this.linearRailMasterController.isTargetReached() && Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.updatePosition();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "=> ERROR IN READING CONTROLLERS:", this.name, (Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-ac2Trucks");){
            AutochangerTwoTrucks autochangerTwoTrucks = this;
            synchronized (autochangerTwoTrucks) {
                this.atHandoff = this.truckXminus.isAtHandoff() && this.truckXplus.isAtHandoff();
                this.atOnline = this.truckXminus.isAtOnline() && this.truckXplus.isAtOnline();
                this.atStandby = this.truckXminus.isAtStandby() && this.truckXplus.isAtStandby();
            }
            this.updatePosition();
        }
    }

    public void slowProfile() {
        this.slowProfileVelocity();
        this.slowProfileAcceleration();
        this.slowProfileDeceleration();
        this.checkProfileVelocity();
        this.checkProfileAcceleration();
        this.checkProfileDeceleration();
    }

    public void fastProfile() {
        this.raiseProfileVelocity();
        this.raiseProfileAcceleration();
        this.raiseProfileDeceleration();
        this.checkProfileVelocity();
        this.checkProfileAcceleration();
        this.checkProfileDeceleration();
    }

    public void slowProfileVelocity() {
        this.profileVelocity = this.lowSpeed;
        this.linearRailMasterController.changeProfileVelocity(this.lowSpeed);
        this.linearRailSlaveController.changeProfileVelocity(this.lowSpeed);
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.lowSpeed));
    }

    public void raiseProfileVelocity() {
        this.profileVelocity = this.highSpeed;
        this.linearRailMasterController.changeProfileVelocity(this.highSpeed);
        this.linearRailSlaveController.changeProfileVelocity(this.highSpeed);
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.highSpeed));
    }

    private void checkProfileVelocity() {
        int masterV;
        int slaveV = (int)this.linearRailSlaveController.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        if (slaveV != (masterV = (int)this.linearRailMasterController.readParameter(EPOSEnumerations.Parameter.ProfileVelocity))) {
            throw new FcsHardwareException(this.name + " master and slave ProfileVelocity are not the same. MASTER velocity =" + masterV + " and SLAVE velocity =" + slaveV);
        }
    }

    private void checkProfileAcceleration() {
        long masterAcc;
        long slaveAcc = this.linearRailSlaveController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration);
        if (slaveAcc != (masterAcc = this.linearRailMasterController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration))) {
            throw new FcsHardwareException(this.name + " master and slave ProfileAcceleration are not the same. MASTER acceleration =" + masterAcc + " and SLAVE acceleration =" + slaveAcc);
        }
    }

    private void checkProfileDeceleration() {
        long masterDec;
        long slaveDec = this.linearRailSlaveController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration);
        if (slaveDec != (masterDec = this.linearRailMasterController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration))) {
            throw new FcsHardwareException(this.name + " master and slave ProfileDeceleration are not the same. MASTER deceleration =" + masterDec + " and SLAVE deceleration =" + slaveDec);
        }
    }

    public void raiseProfileAcceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.highAcceleration));
    }

    public void slowProfileAcceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.lowAcceleration));
    }

    public void raiseProfileDeceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.highDeceleration));
    }

    public void slowProfileDeceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.lowDeceleration));
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    public StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks() {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setMasterPosition(this.masterPosition);
        s.setSlavePosition(this.slavePosition);
        s.setCurrent(this.current);
        s.setSpeed(this.speed);
        s.setProfileVelocity(this.profileVelocity);
        s.setHomingDone(this.isHomingDone());
        s.setAtHandoff(this.atHandoff);
        s.setAtOnline(this.atOnline);
        s.setAtStandby(this.atStandby);
        s.setInError(this.isPositionSensorsInError());
        return s;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByAutoChangerTrucks()));
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.linearRailMasterController.isBooted() && this.linearRailSlaveController.isBooted()) {
            this.activateBrakesAndDisable();
        }
        FCSLOG.info((Object)(this.name + " is shutdown."));
    }

    public class ActivatedACBrakes
    extends ActionGuard {
        @Override
        public Runnable getPreAction() {
            return () -> AutochangerTwoTrucks.this.activateBrakesAndDisable();
        }

        @Override
        public Runnable getPostAction() {
            return () -> AutochangerTwoTrucks.this.enableControllersAndReleaseBrake();
        }

        @Override
        public Class<? extends ActionGuard> requiredEnclosure() {
            return ReleasedACBrakes.class;
        }
    }

    public class ReleasedACBrakes
    extends ActionGuard {
        @Override
        public Runnable getPreAction() {
            return () -> AutochangerTwoTrucks.this.enableControllersAndReleaseBrake();
        }

        @Override
        public Runnable getPostAction() {
            return () -> AutochangerTwoTrucks.this.activateBrakesAndDisable();
        }
    }
}

