package org.lsst.ccs.subsystems.fcs.utils;

import java.util.concurrent.ConcurrentHashMap;

import org.lsst.ccs.subsystems.fcs.common.MobileItem;

public abstract class ActionGuard implements AutoCloseable {
    public abstract Runnable getPreAction();

    public abstract Runnable getPostAction();

    static ConcurrentHashMap<Class<? extends ActionGuard>, Integer> guards = new ConcurrentHashMap<>();

    static {
        MobileItem.FCSLOG.info("ActionGuard -- INIT -- 2021 10 15  09:30");
    }

    protected ActionGuard() {
        Integer i = guards.get(getClass());
        if (i == null)
            i = 0;
        i++;
        guards.put(getClass(), i);
        if (requiredEnclosure() == null || guards.containsKey(requiredEnclosure())) {
            if (i == 1) {
                MobileItem.FCSLOG.info("ActionGuard -- PRE ACTION " + this + " enclosure " + requiredEnclosure());
                getPreAction().run();
            }
        }
    }

    public void close() {
        Integer i = guards.get(getClass());
        if (i == null)
            throw new RuntimeException("inconsistent behavior i is null");
        i--;
        if (i == 0) {
            if (requiredEnclosure() == null || guards.containsKey(requiredEnclosure())) {
                MobileItem.FCSLOG.info("ActionGuard -- POST ACTION " + this + " enclosure " + requiredEnclosure());
                getPostAction().run();
            }
            guards.remove(getClass());
        } else {
            guards.put(getClass(), i);
        }
    }

    public Class<? extends ActionGuard> requiredEnclosure() {
        return null;
    }

}
