package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;

/**
 * Used in APC TEST BENCH only. This is to represent a very basic led which is
 * connected on the CAn Open device AI814
 *
 * @author virieux
 */
public class CanOpenLED implements Led, HasLifecycle {

    private CanOpenDAC dac;

    @ConfigurationParameter(range = "0..4", description = "The numero of the output of DAC where this led is plugged on.", units = "unitless")
    private int outputNumero;

    public CanOpenDAC getDac() {
        return dac;
    }

    public int getOutputNumero() {
        return outputNumero;
    }

    public void setOutputNumero(int outputNumero) {
        this.outputNumero = outputNumero;
    }

    @Override
    public void postStart() {
        if (dac.isBooted()) {
            dac.initializeAndCheckHardware();
        }
    }

    @Override
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, description = "Turn on LED.")
    public String turnON() {
        dac.writeAnalogOutput(outputNumero, 0x14000);
        return "LED is turn ON";
    }

    @Override
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, description = "Turn off LED.")
    public String turnOFF() {
        dac.writeAnalogOutput(outputNumero, 0);
        return "LED is turn OFF";
    }
}
