package org.lsst.ccs.subsystems.fcs.common;

/**
 *
 * @author virieux
 */
public interface TTC580Interface extends PieceOfHardware {

    short getSocketId(long pdo);

    /**
     *
     * @return first pdo sent by this device
     */
    default long getPdo1() {
        return 0;
    }

    /**
     *
     * @return second pdo sent by this device
     */
    default long getPdo2() {
        return 0;
    }

    /**
     * read SDO which holds offsets for presence sensors of clampXminus and
     * clampXplus
     * 
     * @param s
     * @return SDO
     */
    long readOffset1SDO(byte s);

    /**
     * read SDO which holds offsets for lock sensors of clampXminus and clampXplus
     * 
     * @param s
     * @return
     */
    long readOffset2SDO(byte s);

    /**
     * read SDO which contains OUT interlocks for autochanger (OUT signals CS,
     * CFC, CF1, CF0)
     *
     * @return SDO
     */
    long readInterlocksSDO();

}
