/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerOnlineClamp
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    public static final String ONLINE_CLAMP_CONFIG_CATEGORY = "onlineClampCurrent";
    public static final String CURRENT_MONITOR_TASK_NAME = "-monitorCurrent";
    public static final int TIMEOUT_FOR_CLOSING = 6000;
    public static final int TIMEOUT_FOR_OPENING = 15000;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private final EPOSControllerForOnlineClamp controller;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    @ConfigurationParameter(description="current to clamp ONLINE clamp", units="mA", category="autochanger")
    private volatile int currentToClamp = 0;
    @ConfigurationParameter(description="current to open ONLINE clamp", units="mA", category="autochanger")
    private volatile int currentToOpen = 0;
    @Persist
    private volatile int sentCurrent = 0;
    private int currentReadOnController;
    private int position;
    @ConfigurationParameter(description="increment of current to lock in a current ramp", units="mA", category="autochanger")
    private volatile int incrementCurrentToClamp = 250;
    @ConfigurationParameter(description="increment of current to close clamp in a current ramp", units="mA", category="autochanger")
    private volatile int incrementCurrentToClose = 250;
    @ConfigurationParameter(description="increment of current to open clamp in a current ramp", units="mA", category="autochanger")
    private volatile int incrementCurrentToOpen = 250;
    @ConfigurationParameter(description="initial current to close clamp in a current ramp", units="mA", category="autochanger")
    private volatile int initialCurrentToClose = -this.currentToOpen;
    @ConfigurationParameter(description="final current to close clamp in a current ramp", units="mA", category="autochanger")
    private volatile int finalCurrentToClose = -this.currentToOpen * 2;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile boolean initialized;
    private boolean controllerConfigured = true;
    private ScheduledFuture<?> currentRampHandle;
    @ConfigurationParameter(description="absolute target position to open clamp", category="autochanger")
    private volatile int targetPositionToOpen;
    @ConfigurationParameter(description="absolute target position to close clamp", category="autochanger")
    private volatile int targetPositionToClose;
    @ConfigurationParameter(description="delta of current between target current and current read on controller. Used to know if action is completed for homing.", units="mA", category="autochanger")
    private volatile int deltaCurrent = 50;

    public AutochangerOnlineClamp(EPOSControllerForOnlineClamp controller, ComplementarySensors closeSensors, ComplementarySensors openSensors) {
        this.controller = controller;
        this.closeSensors = closeSensors;
        this.openSensors = openSensors;
    }

    @ConfigurationParameterChanger
    public void setCurrentToClamp(int currentToClamp) {
        this.currentToClamp = currentToClamp;
    }

    @ConfigurationParameterChanger
    public void setCurrentToOpen(int currentToOpen) {
        this.currentToOpen = currentToOpen;
    }

    @ConfigurationParameterChanger
    public void setInitialCurrentToClose(int initialCurrentToClose) {
        this.initialCurrentToClose = initialCurrentToClose;
    }

    @ConfigurationParameterChanger
    public void setFinalCurrentToClose(int finalCurrentToClose) {
        this.finalCurrentToClose = finalCurrentToClose;
    }

    public void setSentCurrent(int sentCurrent) {
        this.sentCurrent = sentCurrent;
    }

    public void setTargetPositionToOpen(int targetPositionToOpen) {
        this.targetPositionToOpen = targetPositionToOpen;
    }

    public void setTargetPositionToClose(int targetPositionToClose) {
        this.targetPositionToClose = targetPositionToClose;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClamp(int stepHeightAbsValue) {
        FcsUtils.checkPositive(stepHeightAbsValue);
        this.incrementCurrentToClamp = stepHeightAbsValue;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToOpen(int incrementCurrentToOpen) {
        FcsUtils.checkPositive(incrementCurrentToOpen);
        this.incrementCurrentToOpen = incrementCurrentToOpen;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClose(int incrementCurrentToClose) {
        FcsUtils.checkPositive(incrementCurrentToClose);
        this.incrementCurrentToClose = incrementCurrentToClose;
    }

    public int getInitialCurrentToClose() {
        return this.initialCurrentToClose;
    }

    public int getFinalCurrentToClose() {
        return this.finalCurrentToClose;
    }

    public int getIncrementCurrentToOpen() {
        return this.incrementCurrentToOpen;
    }

    public int getIncrementCurrentToClamp() {
        return this.incrementCurrentToClamp;
    }

    public int getIncrementCurrentToClose() {
        return this.incrementCurrentToClose;
    }

    public int getSentCurrent() {
        return this.sentCurrent;
    }

    @Override
    public EPOSControllerWithBrake getController() {
        return this.controller;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public ComplementarySensors getCloseSensors() {
        return this.closeSensors;
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getTargetPositionToClose() {
        return this.targetPositionToClose;
    }

    public ComplementarySensors getOpenSensors() {
        return this.openSensors;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isCloseSensorsInError() {
        return this.closeSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isOpenSensorsInError() {
        return this.openSensors.isInError();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if in ERROR which means that closeSensor or openSensor is in ERROR or thatopenSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CLOSED. Doesn't read again sensors.")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if homing of controller has been done.")
    public boolean isHomingDone() {
        return this.controller.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LOCKED. Doesn't read again sensors.")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if OPENED. Doesn't read again sensors.")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if INTRAVEL. Doesn't read again sensors.")
    public boolean isInTravel() {
        return this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized : controller is booted and parameters in the controller CPU have been opened and controller is configured.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public void init() {
        this.persistenceService.setAutomatic(true, false);
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerOnlineClamp.class, this.name);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean myDevicesReady() {
        return this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be opened.")
    public void checkConditionsForOpening() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " can't be OPENED if autochanger is not HOLDING filter.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be closed.")
    public void checkConditionsForClosing() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.controller.isBooted()) {
            this.initializeController();
            this.controller.updateEposState();
        } else {
            FCSLOG.error((Object)(this.name + " could not initialize controller in postStart. Do it by hand."));
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeController() {
        try {
            this.controller.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.controller.getName(), ex);
        }
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, level=1, description="Change mode depending of action to be done, then enable and release brake.")
    public void enableAndCheckControllerBeforeAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION || action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION) {
            this.controller.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        } else {
            this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        }
        this.controller.enableAndReleaseBrake();
        this.controller.checkFault();
    }

    public void checkControllerWhenGoingFromEngineeringModeToNormal() {
        this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        if (!this.controller.isParametersOK()) {
            String msg = this.name + " Some parameter values are not the same in CPU and configuration system.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() {
        try {
            this.controllerConfigured = false;
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)this.name, (Throwable)ex);
        }
    }

    @Override
    public void updateCurrent() {
        try {
            this.currentReadOnController = this.controller.readCurrent();
            this.publishData();
        }
        catch (Exception ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, " could not updateCurrent", this.controller.getName(), ex);
        }
    }

    public void updatePosition() {
        try {
            this.position = this.controller.readPosition();
            this.publishData();
        }
        catch (Exception ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, " could not updatePosition", this.controller.getName(), ex);
        }
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state from sensors values.")
    public void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-acClamp");){
            boolean inError;
            boolean closed = this.closeSensors.isOn();
            boolean opened = this.openSensors.isOn();
            boolean someSensorsInError = this.closeSensors.isInError() || this.openSensors.isInError();
            boolean bl = inError = someSensorsInError || closed && opened;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (closed ? FcsEnumerations.LockStatus.CLOSED : (opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
            if (closed && this.sentCurrent == this.currentToClamp) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            }
            this.updatePosition();
            this.publishData();
        }
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
        this.position = this.controller.readPosition();
        this.currentReadOnController = this.controller.readCurrent();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            return this.sentCurrent == this.finalCurrentToClose;
        }
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION) {
            return this.isClosed() && this.isAtPosition(this.targetPositionToClose);
        }
        if (action == FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT || action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT) {
            return this.isOpened();
        }
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION) {
            return this.isOpened() && this.isAtPosition(this.targetPositionToOpen);
        }
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            return this.isLocked();
        }
        throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + (Object)((Object)action));
    }

    public boolean isAtPositionClose() {
        return this.isAtPosition(this.targetPositionToClose);
    }

    public boolean isAtPositionOpen() {
        return this.isAtPosition(this.targetPositionToOpen);
    }

    public boolean isAtPosition(int pos) {
        return Math.abs(this.position - pos) < 500;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the ONLINE clamp.", timeout=6000)
    public void closeClampInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (this.isOpened() || this.isInTravel()) {
            this.checkConditionsForClosing();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_CURRENT, 6000L);
            this.checkCloseSensors();
            this.updateStateAndCheckSensors();
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be OPENED before a close action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the ONLINE clamp in mode PROFILE_POSITION.", timeout=6000)
    public void close() {
        block15: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-close");){
                if (!this.controller.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet. Can't close.");
                }
                this.updateStateAndCheckSensors();
                if (this.isOpened() || this.isInTravel()) {
                    this.checkConditionsForClosing();
                    this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION, 6000L);
                    this.checkCloseSensors();
                    this.updateStateAndCheckSensors();
                    break block15;
                }
                if (this.isClosed()) {
                    FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
                    break block15;
                }
                throw new RejectedCommandException(this.name + " has to be OPENED before a close action.");
            }
        }
    }

    private void checkCloseSensors() {
        if (!this.isClosed()) {
            throw new FailedCommandException(this.name + " is not CLOSED after close or unlock command.");
        }
        FCSLOG.info((Object)(this.name + " is CLOSED"));
    }

    private void checkOpenSensors() {
        if (!this.isOpened()) {
            throw new FailedCommandException(this.name + " is not OPEN after open or openAndHoming command. current action : " + this.currentAction.toString());
        }
        FCSLOG.info((Object)(this.name + " is OPEN"));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the ONLINE clamp.", timeout=15000)
    public void openClampInCurrentMode() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openClampInCurrentMode");){
            this.updateStateAndCheckSensors();
            if (this.isClosed()) {
                this.checkConditionsForOpening();
                this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT, 15000L);
            } else if (this.isOpened() || this.isInTravel()) {
                FCSLOG.info((Object)(this.name + " is already OPENED. Send again currentToOpen."));
                this.executeAction(FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT, 15000L);
            } else {
                throw new RejectedCommandException(this.name + " has to be CLOSED before an open action.");
            }
            this.controller.checkFault();
            this.checkOpenSensors();
            this.updateStateAndCheckSensors();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the ONLINE clamp in PROFILE_POSITION.", timeout=15000)
    public void open() {
        block15: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-open");){
                if (!this.controller.isHomingDone()) {
                    throw new RejectedCommandException(this.name + " homing not done yet. Use openInCurrentModeAndHoming.");
                }
                this.updateStateAndCheckSensors();
                if (this.isClosed() || this.isInTravel()) {
                    this.checkConditionsForOpening();
                    this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION, 15000L);
                    this.checkOpenSensors();
                    this.updateStateAndCheckSensors();
                    break block15;
                }
                if (this.isOpened()) {
                    FCSLOG.info((Object)(this.name + " is already OPENED. Nothing to do."));
                    break block15;
                }
                throw new RejectedCommandException(this.name + " has to be CLOSED before an open action.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="open clamp in CURRENT mode and do homing", timeout=5000)
    public void openInCurrentModeAndHoming() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openInCurrentModeAndHoming");){
            this.openClampInCurrentMode();
            this.controller.homing();
            this.updatePosition();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Locks the ONLINE clamp : sends currentToClamp to the controller with a ramp of currentfrom currentToClose to currentToRamp.", timeout=6000)
    public void lock() {
        block14: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-lock");){
                this.updateStateAndCheckSensors();
                if (this.isClosed()) {
                    this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP, 6000L);
                    this.updateStateAndCheckSensors();
                    break block14;
                }
                if (this.isLocked()) {
                    FCSLOG.info((Object)(this.name + " is already LOCKED. Nothing to do."));
                    break block14;
                }
                throw new RejectedCommandException(this.name + " has to be CLOSED before lock action.");
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlocks the ONLINE clamp : sends currentToClamp to the controller  with a ramp of current from currentToClamp to currentToClose.", timeout=15000)
    public void unlock() {
        block14: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("clamp-unlock");){
                this.updateStateAndCheckSensors();
                if (this.isLocked()) {
                    this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP, 6000L);
                    this.checkCloseSensors();
                    this.updateStateAndCheckSensors();
                    break block14;
                }
                if (this.isClosed()) {
                    FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
                    break block14;
                }
                throw new RejectedCommandException(this.name + " has to be LOCKED before unlock action.");
            }
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        block18: {
            try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("AutoOnlineClamp-action-" + action.toString());){
                this.autochanger.checkConditionsForActioningOnlineClamps();
                this.autochanger.checkOnlineClampMotionAllowed();
                if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION) {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                    this.controller.enableAndReleaseBrake();
                    this.controller.writeTargetPosition(this.targetPositionToClose);
                    this.controller.writeControlWord(63);
                    break block18;
                }
                if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION) {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                    this.controller.enableAndReleaseBrake();
                    this.controller.writeTargetPosition(this.targetPositionToOpen);
                    this.controller.writeControlWord(63);
                    break block18;
                }
                if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT) {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.writeCurrentToControllerAndSaveValue(this.finalCurrentToClose);
                    FcsUtils.sleep(250, this.name);
                    this.controller.doReleaseBrake();
                    this.executeCurrentRamp(this.finalCurrentToClose, this.currentToOpen, this.incrementCurrentToOpen);
                    break block18;
                }
                if (action == FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT) {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.controller.doReleaseBrake();
                    this.writeCurrentToControllerAndSaveValue(this.currentToOpen);
                    break block18;
                }
                if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.writeCurrentToControllerAndSaveValue(this.finalCurrentToClose);
                    FcsUtils.sleep(250, this.name);
                    this.controller.doReleaseBrake();
                    this.executeCurrentRamp(this.finalCurrentToClose, this.currentToClamp, this.incrementCurrentToClamp);
                    break block18;
                }
                if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
                    this.controller.checkFault();
                    this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
                    this.controller.goToOperationEnable();
                    this.writeCurrentToControllerAndSaveValue(this.currentToClamp);
                    FcsUtils.sleep(250, this.name);
                    this.controller.doReleaseBrake();
                    this.executeCurrentRamp(this.currentToClamp, this.finalCurrentToClose, this.incrementCurrentToClamp);
                    break block18;
                }
                throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + (Object)((Object)action));
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="sent current to control and save this value")
    public void writeCurrentToControllerAndSaveValue(int current) {
        FCSLOG.finest((Object)(this.name + " current to write to controller " + this.getControllerName() + ":" + current));
        this.controller.writeCurrent((short)current);
        this.sentCurrent = current;
        this.persistenceService.persistNow();
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION || action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION) {
            this.controller.stopAction();
            this.controller.activateBrake();
        } else {
            this.controller.activateBrake();
            this.controller.writeCurrent(0);
            this.controller.goToSwitchOnDisabled();
        }
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT || action == FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT) {
            FCSLOG.info((Object)(this.name + " waiting for clamp to be completely open."));
            FcsUtils.sleep(1000, this.name);
            this.controller.activateBrake();
            FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeOC(), this.name);
            this.controller.goToSwitchOnDisabled();
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_PROFILE_POSITION || action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            this.controller.activateBrake();
            FcsUtils.sleep(this.autochanger.getWaitTimeForBrakeOC(), this.name);
            this.controller.goToSwitchOnDisabled();
        }
        FCSLOG.debug((Object)(this.name + " END of action " + action.toString()));
        this.controller.checkFault();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 5);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 35872);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput4, 15);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32769);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 0);
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setLockSensorValue(this.closeSensors.isOn());
        status.setUnlockSensorValue(this.openSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.closeSensors.isInError());
        status.setUnlockSensorInError(this.openSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        status.setControllerBooted(this.controller.isBooted());
        status.setControllerInFault(this.controller.isInError());
        status.setSentCurrent(this.sentCurrent);
        status.setCurrent(this.currentReadOnController);
        status.setPosition(this.position);
        status.setHomingDone(this.controller.isHomingDone());
        return status;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByOnlineClamp()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
    }

    private void cancelCurrentRamp() {
        this.currentRampHandle.cancel(false);
        FCSLOG.debug((Object)" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp(int timeout) {
        FCSLOG.info((Object)(this.name + " BEGIN WAITING FOR END OF CURRENT RAMP"));
        try {
            this.currentRampHandle.get(timeout, TimeUnit.SECONDS);
        }
        catch (CancellationException ex) {
            if (this.currentRampHandle.isDone()) {
                FCSLOG.info((Object)(this.name + " CURRENT RAMP ENDED"));
            } else {
                FCSLOG.error((Object)(this.name + " during action " + (Object)((Object)this.currentAction) + " waiting was cancelled before END of CURRENT RAMP " + ex));
            }
        }
        catch (TimeoutException ex) {
            FCSLOG.error((Object)(this.name + " CURRENT RAMP IS DURING TOO LONG - timeout=" + timeout), (Throwable)ex);
            this.cancelCurrentRamp();
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction), ex);
        }
        catch (ExecutionException ex) {
            FCSLOG.error((Object)(this.name + " error during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " error during action=" + (Object)((Object)this.currentAction), ex);
        }
        finally {
            FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF CURRENT RAMP"));
        }
    }

    private void writeCurrentRamp(final int initialValue, final int finalValue, final int increment) {
        FCSLOG.debug((Object)"############################");
        FCSLOG.debug((Object)(this.name + "writeCurrentRamp"));
        FCSLOG.debug((Object)("initialValue=" + initialValue));
        FCSLOG.debug((Object)("finalValue=" + finalValue));
        FCSLOG.debug((Object)("|increment|=" + increment));
        FCSLOG.debug((Object)"period=250");
        FCSLOG.debug((Object)"waitTime=250");
        FCSLOG.debug((Object)"############################");
        Runnable currentRamp = new Runnable(){
            private final int adjustedStepHeight;
            private int currentValue;
            {
                this.adjustedStepHeight = FcsUtils.getSignedStepHeight(initialValue, finalValue, increment);
                this.currentValue = initialValue;
            }

            public boolean finalValueReached() {
                boolean reachedUp = this.adjustedStepHeight > 0 && this.currentValue >= finalValue;
                boolean reachedDown = this.adjustedStepHeight < 0 && this.currentValue <= finalValue;
                return reachedUp || reachedDown;
            }

            @Override
            public void run() {
                if (!this.finalValueReached()) {
                    this.currentValue += this.adjustedStepHeight;
                    MobileItem.FCSLOG.info((Object)("ramp " + AutochangerOnlineClamp.this.name + " write current " + this.currentValue));
                    AutochangerOnlineClamp.this.writeCurrentToControllerAndSaveValue(this.currentValue);
                }
                if (this.finalValueReached()) {
                    AutochangerOnlineClamp.this.cancelCurrentRamp();
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    public void executeCurrentRamp(int initialCurrent, int finalCurrent, int incrementCurrent) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("executeCurrentRamp");){
            this.writeCurrentRamp(initialCurrent, finalCurrent, incrementCurrent);
            this.waitForEndOfCurrentRamp(15000);
        }
    }
}

