package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import static org.lsst.ccs.commons.annotations.LookupField.Strategy.CHILDREN;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

/**
 * This class is the Main Module when carousel is in standalone mode.
 *
 * CarouselModle implements HardwareController because we must initialize
 * acPLutoGateway during initialization Phase.
 *
 * @author virieux
 */
public class CarouselMain extends MainModule {

    @LookupField(strategy = CHILDREN)
    private Carousel carousel;

    @LookupField(strategy = CHILDREN, pathFilter = ".*autochanger.*")
    private FilterHolder autochanger;

    @Override
    public void init() {
        /*
         * define a role for my subsystem in order to make CarouselGUI listen to my
         * subsystem
         */
        subs.getAgentService(AgentPropertiesService.class).setAgentProperty("org.lsst.ccs.subsystem.fcs.carousel", "carousel");
        super.init();
    }

    /**
     * Update state in reading sensors.
     *
     * @throws FcsHardwareException
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, description = "Update state in reading sensors.", timeout = 2000)
    @Override
    public void updateStateWithSensors() {
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void initializeHardware() {
        carousel.initializeHardware();
    }
}
