/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class DigitalSensor
implements BinarySensor,
SensorPluggedOnDevice,
HasLifecycle {
    @LookupName
    private String name = "unset";
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @ConfigurationParameter(isFinal=true, description="The name of the Digital Input Output device where this sensor is plugged on.", units="unitless", category="sensor")
    private volatile String dioName;
    @ConfigurationParameter(range="0..7", description="The input number on DIO device where this sensor is plugged on.", units="unitless", category="sensor")
    private volatile int inputNumero;
    @ConfigurationParameter(range="0..15", description="The byte numberwhere the value of this sensor is stored in.", units="unitless", category="sensor")
    protected volatile int byteNumero;
    protected boolean on = false;

    public DigitalSensor() {
    }

    public void build() {
        this.dataProviderDictionaryService.registerData(new KeyValueData(this.name, (Serializable)Integer.valueOf(0)));
    }

    public DigitalSensor(String dioName, int inputNumero, int byteNumero) {
        this.dioName = dioName;
        this.inputNumero = inputNumero;
        this.byteNumero = byteNumero;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    public int getInputNumero() {
        return this.inputNumero;
    }

    @Override
    public String getDeviceName() {
        return this.dioName;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return True if the sensor is ON")
    public boolean isOn() {
        return this.on;
    }

    @Override
    public synchronized void updateValue(int newValue) {
        if (newValue > 256) {
            throw new IllegalArgumentException("hex cannot be superior to 256");
        }
        this.on = (newValue >> this.inputNumero & 1) == 1;
        this.publishData();
    }

    public void publishData() {
        int valueToPublish = this.on ? 1 : 0;
        FCSCst.FCSLOG.fine((Object)("PublishData for name=" + this.name + " value=" + valueToPublish));
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)Integer.valueOf(valueToPublish)));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a String representation of DigitalSensor", alias="printValue")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/DIO module=");
        sb.append(this.dioName);
        sb.append("/Input numero=");
        sb.append(String.valueOf(this.inputNumero));
        sb.append("/byteNumero=");
        sb.append(String.valueOf(this.byteNumero));
        sb.append("/value=");
        sb.append(String.valueOf(this.on));
        return sb.toString();
    }
}

