/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerLatch;
import org.lsst.ccs.subsystems.fcs.AutochangerMain;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;

public class SimuAutochangerPlutoGatewayTest
extends FCSTestTemplate {
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static AutochangerTwoLatches latches;
    private static AutochangerLatch latchXplus;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static AutochangerOnlineClamp[] clampsList;
    private static SimuAutochangerStandalonePlutoGateway acPlutoGateway;
    private static FilterIdentificator filterIdentificator;
    private final SecureRandom randomGenerator = new SecureRandom();
    private static ComplementarySensors filterEngagedSensorsLatchXminus;
    private static ComplementarySensors filterEngagedSensorsLatchXplus;
    private static ComplementarySensors closeSensorsLatchXplus;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuAutochangerPlutoGateway   ");
        System.out.println("***************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.fcs.instance.autochanger.standalone", "true");
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"Autochanger", (String)"serialNB:<alias>,nodeID:<alias>,controller:defaultInitial|<alias>", (String)"autochanger-simu");
        autochangerSubsystem.startAgent();
        ((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMain)lookup.getTopComponentNode().getComponent();
        autochanger = (Autochanger)lookup.getComponentByPath("autochanger");
        autochanger.updateStateWithSensors();
        trucks = (AutochangerTwoTrucks)lookup.getComponentByPath("autochangerTrucks");
        acPlutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByPath("acSensorsGateway");
        filterIdentificator = (FilterIdentificator)lookup.getComponentByPath("filterIdentificator");
        acPlutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        latches = (AutochangerTwoLatches)lookup.getComponentByPath("latches");
        latchXplus = (AutochangerLatch)lookup.getComponentByPath("latchXplus");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByPath("onlineClamps");
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampYminus");
        for (AutochangerOnlineClamp clamp : clampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus}) {
            clamp.setIncrementCurrentToClose(150);
            clamp.setIncrementCurrentToOpen(150);
            clamp.setIncrementCurrentToClamp(266);
            clamp.setInitialCurrentToClose(300);
            clamp.setFinalCurrentToClose(1800);
            clamp.setCurrentToOpen(-300);
            clamp.setCurrentToClamp(4992);
        }
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.allDevicesBooted());
        filterEngagedSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByPath("filterEngagedSensorsLatchXminus");
        filterEngagedSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByPath("filterEngagedSensorsLatchXplus");
        closeSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByPath("closeSensorsLatchXplus");
    }

    @AfterClass
    public static void after() throws Exception {
        if (autochangerSubsystem != null) {
            autochangerSubsystem.shutdownAgent();
            ((AgentStateService)autochangerSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        }
        System.getProperties().remove("org.lsst.ccs.fcs.instance.autochanger.standalone");
    }

    @Before
    public void setUp() {
        System.out.println("***********  BEFORE test : setUp    *******************");
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSimulateAutochangerTrucksAreAtHandoff() {
        System.out.println("###simulateAutochangerTrucksAreAtHandoff");
        acPlutoGateway.simulateAutochangerTrucksAreAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks should be at HANDOFF", (boolean)trucks.isAtHandoff());
    }

    @Test
    public void testSimulateAutochangerTrucksAreOnline() {
        System.out.println("###simulateAutochangerTrucksAreOnline");
        acPlutoGateway.simulateAutochangerTrucksAreOnline();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks should be at ONLINE", (boolean)trucks.isAtOnline());
    }

    @Test
    public void testSimulateAutochangerTrucksAreAtStandby() {
        System.out.println("###simulateAutochangerTrucksAreAtStandby");
        acPlutoGateway.simulateAutochangerTrucksAreAtStandby();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks should be at STANDBY", (boolean)trucks.isAtStandby());
    }

    public void testSimulateLoaderIsConnected() {
        System.out.println("### simulateLoaderIsConnected");
        acPlutoGateway.simulateLoaderIsConnected();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"loader should be connected", (boolean)autochanger.isLoaderConnected());
    }

    @Test
    public void testSimulateLoaderIsDisconnected() {
        System.out.println("### simulateLoaderIsDisconnected");
        acPlutoGateway.simulateLoaderIsDisconnected();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"loader should NOT be connected", (boolean)autochanger.isLoaderConnected());
    }

    @Test
    public void testSimulateFilterIsOnAutochanger() {
        System.out.println("### simulateFilterIsOnAutochanger");
        acPlutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger should be on Autochanger", (boolean)autochanger.isEmpty());
    }

    @Test
    public void testSimulateAutochangerIsEmpty() {
        System.out.println("### simulateAutochangerIsEmpty");
        acPlutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filter ID on AC", (long)0L, (long)autochanger.getFilterID());
    }

    @Test
    public void testSimulateAutochangerLatchesAreLocked() {
        System.out.println("### simulateAutochangerLatchesAreLocked");
        acPlutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches should be LOCKED", (boolean)latches.isClosed());
    }

    @Test
    public void testSimulateAutochangerLatchesAreUnlocked() {
        System.out.println("### simulateAutochangerLatchesAreUnlocked");
        acPlutoGateway.simulateAutochangerLatchesAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Latches should be UNLOCKED", (boolean)latches.isClosed());
    }

    @Test
    public void testSimulateAutochangerLatchIsLocked() {
        System.out.println("### simulateAutochangerLatchIsLocked");
        acPlutoGateway.simulateAutochangerLatchIsLocked(latchXplus.getName());
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXplus is LOCKED", (boolean)latchXplus.isClosed());
    }

    @Test
    public void testSimulateAutochangerLatchIsUnlocked() {
        System.out.println("### simulateAutochangerLatchIsUnlocked");
        acPlutoGateway.simulateAutochangerLatchIsUnlocked(latchXplus.getName());
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"latchXplus is UNLOCKED", (boolean)latchXplus.isClosed());
    }

    @Test
    public void testSimulateLatchLockSensorsInError() {
        System.out.println("### simulateLockSensorsInError");
        acPlutoGateway.simulateLatchLockSensorsInError(latchXplus.getName());
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"closeSensorsLatchXplus should be in error", (boolean)closeSensorsLatchXplus.isInError());
    }

    @Test
    public void testSimulateAutochangerOnlineClampsAreLocked() {
        System.out.println("### simulateAutochangerOnlineClampsAreLocked");
        acPlutoGateway.simulateAutochangerOnlineClampsAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"ONLINE clamps should be LOCKED", (boolean)onlineClamps.isLocked());
    }

    @Test
    public void testSimulateAutochangerOnlineClampsAreClosed() {
        System.out.println("### simulateAutochangerOnlineClampsAreClosed");
        acPlutoGateway.simulateAutochangerOnlineClampsAreClosed();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"ONLINE clamps should be CLOSED", (boolean)onlineClamps.isClosed());
    }

    @Test
    public void testSimulateAutochangerOnlineClampsAreOpened() {
        System.out.println("### simulateAutochangerOnlineClampsAreOpened");
        acPlutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"ONLINE clamps should be OPENED", (boolean)onlineClamps.isOpened());
    }

    @Test
    public void testSimulateAutochangerOnlineClampIsLocked() {
        System.out.println("simulateAutochangerOnlineClampIsLocked");
        acPlutoGateway.simulateAutochangerOnlineClampIsLocked(onlineClampXplus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"onlineClampXplus is locked", (boolean)onlineClampXplus.isLocked());
        System.out.println("simulateAutochangerOnlineClampIsLocked");
        acPlutoGateway.simulateAutochangerOnlineClampIsLocked(onlineClampYminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"onlineClampYminus is locked", (boolean)onlineClampYminus.isLocked());
        System.out.println("simulateAutochangerOnlineClampXminusIsLocked");
        acPlutoGateway.simulateAutochangerOnlineClampIsLocked(onlineClampXminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"onlineClampXminus is locked", (boolean)onlineClampXminus.isLocked());
    }

    @Test
    public void testSimulateAutochangerOnlineClampIsClosed() {
        System.out.println("simulateAutochangerOnlineClampIsClosed");
        acPlutoGateway.simulateAutochangerOnlineClampIsClosed(onlineClampXminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"onlineClampXminus is closed", (boolean)onlineClampXminus.isClosed());
    }

    @Test
    public void testSimulateAutochangerOnlineClampIsOpened() {
        System.out.println("simulateAutochangerOnlineClampIsOpened");
        acPlutoGateway.simulateAutochangerOnlineClampIsOpened(onlineClampXplus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"onlineClampXplus is opened", (boolean)onlineClampXplus.isOpened());
    }

    @Test
    public void testSimuComplementarySensorsOn() {
        System.out.println("###simuComplementarySensorsOn");
        acPlutoGateway.simuComplementarySensorsOn(filterEngagedSensorsLatchXminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXminus.getSensor().isOn()", (boolean)filterEngagedSensorsLatchXminus.getSensor().isOn());
        Assert.assertFalse((String)"filterEngagedSensorsLatchXminus.getSensor() is NOT On", (boolean)filterEngagedSensorsLatchXminus.getSensorC().isOn());
        Assert.assertTrue((String)"filterEngagedSensorsLatchXminus are ON", (boolean)filterEngagedSensorsLatchXminus.isOn());
        acPlutoGateway.simuComplementarySensorsOn(filterEngagedSensorsLatchXplus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXplus are ON", (boolean)filterEngagedSensorsLatchXplus.isOn());
    }

    @Test
    public void testSimuComplementarySensorsNotOn() {
        System.out.println("###simuComplementarySensorsNotOn");
        acPlutoGateway.simuComplementarySensorsNotOn(filterEngagedSensorsLatchXminus);
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"filterEngagedSensorsLatchXminus are NOT ON", (boolean)filterEngagedSensorsLatchXminus.isOn());
        acPlutoGateway.simuComplementarySensorsNotOn(filterEngagedSensorsLatchXplus);
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"filterEngagedSensorsLatchXplus are NOT ON", (boolean)filterEngagedSensorsLatchXplus.isOn());
    }

    @Test
    public void testSimuComplementarySensorsInError() {
        System.out.println("###simuComplementarySensorsInError");
        acPlutoGateway.simuComplementarySensorsInError(filterEngagedSensorsLatchXminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXminus are in Error", (boolean)filterEngagedSensorsLatchXminus.isInError());
        acPlutoGateway.simuComplementarySensorsInError(filterEngagedSensorsLatchXplus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXplus are in Error", (boolean)filterEngagedSensorsLatchXplus.isInError());
    }

    @Test
    public void testSimulateFilterIDOnAutochanger() {
        System.out.println("###SimulateFilterIDOnAutochanger");
        int id = 2;
        acPlutoGateway.simulateFilterIDOnAutochanger(id);
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)("filter on trucks is now " + id), (long)id, (long)autochanger.getFilterID());
        id = 25;
        acPlutoGateway.simulateFilterIDOnAutochanger(id);
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)("filter on trucks is now " + id), (long)id, (long)autochanger.getFilterID());
        id = 0;
        acPlutoGateway.simulateFilterIDOnAutochanger(id);
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)("filter on trucks is now " + id), (long)id, (long)autochanger.getFilterID());
        id = 63;
        acPlutoGateway.simulateFilterIDOnAutochanger(id);
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)("filter on trucks is now " + id), (long)id, (long)autochanger.getFilterID());
        id = 64;
        try {
            acPlutoGateway.simulateFilterIDOnAutochanger(id);
            Assert.fail((String)"plutoGateway.simulateFilterIDOnAutochanger(64) should fail.");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void testSimulateFilterID() {
        System.out.println("simulateFilterID");
        acPlutoGateway.simulateFilterID(5);
        Assert.assertEquals((String)"Now filterID is 5", (long)5L, (long)filterIdentificator.getFilterId());
        acPlutoGateway.simulateFilterID(12);
        Assert.assertEquals((String)"Now filterID is 12", (long)12L, (long)filterIdentificator.getFilterId());
        try {
            acPlutoGateway.simulateFilterID(64);
            Assert.fail((String)"argument of simulateFilterID must be < 64");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        int randomFilterID = this.randomGenerator.nextInt(63);
        if (randomFilterID > 0) {
            System.out.println("simulateFilterID with randomFilterID=" + randomFilterID);
            acPlutoGateway.simulateFilterID(randomFilterID);
            Assert.assertEquals((String)("Now filterID is " + randomFilterID), (long)randomFilterID, (long)filterIdentificator.getFilterId());
        }
    }

    @Test
    public void testIdentification() {
        acPlutoGateway.replaceSensorValue((DigitalSensor)filterIdentificator.getFilterIDSensors().get(0), false);
        acPlutoGateway.replaceSensorValue((DigitalSensor)filterIdentificator.getFilterIDSensors().get(1), true);
        acPlutoGateway.replaceSensorValue((DigitalSensor)filterIdentificator.getFilterIDSensors().get(2), true);
        acPlutoGateway.replaceSensorValue((DigitalSensor)filterIdentificator.getFilterIDSensors().get(3), true);
        acPlutoGateway.replaceSensorValue((DigitalSensor)filterIdentificator.getFilterIDSensors().get(4), false);
        acPlutoGateway.replaceSensorValue((DigitalSensor)filterIdentificator.getFilterIDSensors().get(5), true);
        acPlutoGateway.updateValues();
        filterIdentificator.updateFilterId();
        int id = filterIdentificator.getFilterId();
        System.out.println("getFilterId=" + id + " binaire=" + Integer.toBinaryString(id));
        Assert.assertEquals((String)"filterID", (long)17L, (long)filterIdentificator.getFilterId());
    }

    public void testSimuLPMStatusOn() {
        acPlutoGateway.simuLPMStatusOn();
        Assert.assertTrue((String)"lpmLatchesStatus.isOn()", (boolean)SimuAutochangerPlutoGatewayTest.acPlutoGateway.lpmLatchesStatus.isOn());
        try {
            autochanger.checkLatchMotionAllowed();
        }
        catch (Exception ex) {
            System.out.println("checkLatchMotionAllowed should not fail, ex=" + ex);
        }
    }
}

