/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class LoaderCarrierTest
extends FCSTestTemplate {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderCarrier carrier;
    private static LoaderClamp clamp;
    private static Loader loader;
    private static SimuLoaderStandalonePlutoGateway gateway;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("*************************************************");
        System.out.println("TESTS OF LOADER CARRIER MOTION IN STANDALONE MODE");
        System.out.println("*************************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        props.setProperty("org.lsst.ccs.fcs.instance", "LO1");
        System.setProperty("org.lsst.ccs.fcs.instance.loader.standalone", "true");
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"Loader");
        loaderSubsystem.startAgent();
        ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        carrier = (LoaderCarrier)lookup.getComponentByPath("carrier");
        clamp = (LoaderClamp)lookup.getComponentByPath("clamp");
        loader = (Loader)lookup.getComponentByPath("loader");
        gateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByPath("loaderPlutoGateway");
    }

    @AfterClass
    public static void after() throws Exception {
        if (loaderSubsystem != null) {
            loaderSubsystem.shutdownAgent();
            ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
        }
        System.getProperties().remove("org.lsst.ccs.fcs.instance.loader.standalone");
    }

    @Before
    public void setUp() {
        Utils.printJoliSetUp("LoaderCarrierTest");
        gateway.simulateFilterIsOnLoader();
        gateway.simulateLoaderClampIsClosed();
        gateway.simulateLoaderIsConnectedOnCamera();
        gateway.simulateLoaderCarrierIsAtHandoff();
        loader.updateStateWithSensors();
        carrier.updatePosition();
    }

    @After
    public void tearDown() throws Exception {
        ((AlertService)loaderSubsystem.getAgentService(AlertService.class)).clearAllAlerts();
    }

    @Test
    public void testGetControllerName() {
        System.out.println("###getControllerName");
        String ctlrName = carrier.getControllerName();
        Assert.assertTrue((String)("Carrier controller name should contains String carrier " + ctlrName), (boolean)ctlrName.contains("carrier"));
    }

    @Test
    public void testInitializeHardware() throws Exception {
        System.out.println("### initializeHardware");
        carrier.initializeHardware();
        Assert.assertTrue((String)"carrier is initialized", (boolean)carrier.isInitialized());
    }

    public void testGoToHandOff() {
        System.out.println("### goToHandOff");
        carrier.goToHandOff();
        Assert.assertTrue((String)"carrier is still at HANDOFF position", (boolean)carrier.isAtHandoff());
        gateway.simulateLoaderCarrierIsAtStorage();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"carrier is now at STORAGE position", (boolean)carrier.isAtStorage());
        carrier.updatePosition();
        Assert.assertTrue((String)"carrier position is STORAGE position", (carrier.getPosition() == carrier.getStoragePosition() ? 1 : 0) != 0);
        try {
            carrier.goToHandOff();
        }
        catch (RejectedCommandException ex) {
            System.out.println("#carrier is at STORAGE can't go directly to position 500:" + (Object)((Object)ex));
        }
        gateway.simulateLoaderCarrierIsAtEngaged();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"carrier is now at ENGAGED position", (boolean)carrier.isAtEngaged());
        carrier.updatePosition();
        Assert.assertTrue((String)"carrier position is ENGAGED position", (carrier.getPosition() == carrier.getEngagedPosition() ? 1 : 0) != 0);
        try {
            carrier.goToHandOff();
        }
        catch (RejectedCommandException ex) {
            System.out.println("has to unclamp filter: " + (Object)((Object)ex));
        }
        clamp.unclamp();
        Assert.assertTrue((String)"clamp is unclamped", (boolean)clamp.isClosed());
        carrier.goToHandOff();
        Assert.assertTrue((String)"carrier is again at HANDOFF position", (boolean)carrier.isAtHandoff());
    }

    public void testGoToStorage() {
        System.out.println("### goToStorage");
        try {
            carrier.goToStorage();
        }
        catch (RejectedCommandException ex) {
            System.out.println("carrier is at HANDOFF can't go direcly to STORAGE: " + (Object)((Object)ex));
        }
        gateway.simulateLoaderCarrierIsAtEngaged();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"carrier is now at ENGAGED position", (boolean)carrier.isAtEngaged());
        carrier.updatePosition();
        Assert.assertTrue((String)"carrier position is ENGAGED position", (carrier.getPosition() == carrier.getEngagedPosition() ? 1 : 0) != 0);
        try {
            carrier.goToStorage();
        }
        catch (RejectedCommandException ex) {
            System.out.println("carrier is at ENGAGED. Has to be CLAMPED to goToStorage :" + (Object)((Object)ex));
        }
        gateway.simulateLoaderClampIsClamped();
        loader.updateStateWithSensors();
        carrier.goToStorage();
        Assert.assertTrue((String)"carrier is now at STORAGE position", (boolean)carrier.isAtStorage());
    }

    @Test
    public void testGoToEngaged() {
        System.out.println("### goToEngaged");
        try {
            carrier.goToEngaged();
        }
        catch (RejectedCommandException ex) {
            System.out.println("clamp is CLAMPED can't move to ENGAGED:" + (Object)((Object)ex));
        }
        gateway.simulateLoaderClampIsClosed();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is unclamped", (boolean)clamp.isClosed());
        carrier.goToEngaged();
        Assert.assertTrue((String)"carrier is now at ENGAGED position", (boolean)carrier.isAtEngaged());
    }

    public void testGoToAbsolutePosition() {
        System.out.println("### goToAbsolutePosition");
        System.out.println("carrier is at HANDOFF can't go directly to position 500");
        int absolutePosition = 500;
        try {
            carrier.goToAbsolutePosition(absolutePosition);
        }
        catch (RejectedCommandException ex) {
            System.out.println((Object)ex);
        }
        gateway.simulateLoaderCarrierIsAtStorage();
        loader.updateStateWithSensors();
        carrier.updatePosition();
        try {
            carrier.goToAbsolutePosition(absolutePosition);
        }
        catch (RejectedCommandException ex) {
            System.out.println("carrier is at STORAGE with a filter but not CLAMPED can't move" + (Object)((Object)ex));
        }
        gateway.simulateLoaderClampIsClamped();
        loader.updateStateWithSensors();
        carrier.goToAbsolutePosition(absolutePosition);
        Assert.assertEquals((String)("carrier position is now " + absolutePosition), (long)absolutePosition, (long)carrier.getPosition());
    }

    @Test
    public void testReadPosition() {
        System.out.println("### readPosition");
        Assert.assertEquals((String)"readPosition is equals to getPosition", (long)carrier.getPosition(), (long)carrier.readPosition());
    }

    static {
        loaderSubsystem = null;
    }
}

