/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.FCSTestTemplate;
import org.lsst.ccs.subsystems.fcs.FilterManager;

public class FilterManagerTest
extends FCSTestTemplate {
    private static Subsystem filterManagerSubsystem = null;
    private static FilterManager filterManager;
    private static final String FILTER_R_NAME = "r";

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("   TESTS OF FilterManager             ");
        System.out.println("***************************************");
        filterManagerSubsystem = BootUtils.getSubsystemFromFile((String)"filterManager__simulation");
        filterManagerSubsystem.startAgent();
        ComponentLookup lookup = filterManagerSubsystem.getComponentLookup();
        filterManager = (FilterManager)lookup.getComponentByPath("main");
        filterManager.init();
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****END of TESTS OF FilterManager******");
        System.out.println("***************************************");
        filterManagerSubsystem.shutdownAgent();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDownClass() throws Exception {
    }

    @Test
    public void testGetFiltersMap() {
        System.out.println("getFiltersMap");
        try {
            String result = filterManager.getFiltersMapByName().toString();
            System.out.println("Filter List Map=" + result);
        }
        catch (Exception ex) {
            Assert.fail((String)("getFiltersMap should not raise an Exception:" + ex));
        }
    }

    @Test
    public void testGetFilterNameByID() {
        System.out.println("getFilterNameByID");
        int filterID = 6;
        Assert.assertEquals((String)"filter name for ID=6", (Object)"g", (Object)filterManager.getFilterNameByID(filterID));
    }

    @Test
    public void testCheckFilterName() {
        System.out.println("checkFilterName");
        String filterName = "";
        try {
            filterManager.checkFilterName(filterName);
            Assert.fail((String)"null filter name. Should raise IllegalArgument Exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            filterManager.checkFilterName(FILTER_R_NAME);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"r is a valid filter name. Should NOT raise IllegalArgument Exception.");
        }
    }
}

