
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import static org.lsst.ccs.commons.annotations.LookupField.Strategy.TREE;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;

/**
 * Used only for Simulation to simulate a gateway where we read the fake autochanger sensor.
 * In carousel-standalone subsystem, there is an electric switch connected to a numeric sensor.
 * This sensor : autochangerHoldingFilterSensor simulates that the autochnager is holding a filter or not.
 * Therefore we can do mechanical tests of unlocking clamps.
 *
 * @author virieux
 */
public class SimuCarouselStandalonePlutoGateway extends SimuPlutoGateway {

    @LookupField(strategy = TREE, pathFilter = ".*\\/acAF3")
    private ComplementarySensors acAF3;

    @Override
    public void init() {
        this.initialized = true;
    }

    /**
     * For the simulation software, set autochangerHoldingFilterSensor value to 1.
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsHoldingFilter() {
        replaceSensorValue(acAF3.getSensor(), true);
        replaceSensorValue(acAF3.getSensorC(), false);
    }

    /**
     * For the simulation software, set autochangerHoldingFilterSensor value to 0.
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsNotHoldingFilter() {
        replaceSensorValue(acAF3.getSensor(), false);
        replaceSensorValue(acAF3.getSensorC(), true);
    }
}
