/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Loader
implements FilterHolder,
AlertRaiser,
HasLifecycle {
    private static final int TIMEOUT_FOR_MOVING_CARRIER = 120000;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderCarrier carrier;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderClamp clamp;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderFilterPresenceSensors")
    private RedondantSensors loaderFilterPresenceSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderOnCameraSensors")
    private RedondantSensors loaderOnCameraSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="acAP2")
    private ComplementarySensors acAP2;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="acAF0")
    private ComplementarySensors acAF0;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="acAF1")
    private ComplementarySensors acAF1;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="acAF3")
    private ComplementarySensors acAF3;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="keyLockSensors")
    private ComplementarySensors keyLockSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="keyEngSensors")
    private ComplementarySensors keyEngSensors;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderCarrierRelayStatus")
    private DigitalSensor loaderCarrierRelayStatus;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderHooksRelayStatus")
    private DigitalSensor loaderHooksRelayStatus;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderChainPresenceSensor")
    private DigitalSensor loaderChainPresenceSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderDefaultStatus")
    private DigitalSensor loaderDefaultStatus;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderFilterGoodPositionStatus")
    private DigitalSensor loaderFilterGoodPositionStatus;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="loaderFilterDistanceSensor")
    private ForceSensor loaderFilterDistanceSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="Loader_LRH")
    private ComplementarySensors loader_LRH;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="Loader_LPS")
    private ComplementarySensors loader_LPS;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/loaderPlutoGateway")
    private PlutoGatewayInterface loaderPlutoGateway;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/hooksController")
    private EPOSController hooksController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/carrierController")
    private EPOSController carrierController;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="loaderTcpProxy")
    private BridgeToHardware bridge;
    @ConfigurationParameter(description="maximum position of the filter", category="loader")
    private volatile int filterDistanceMin = 80;

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.s;
    }

    public LoaderCarrier getCarrier() {
        return this.carrier;
    }

    public LoaderClamp getClamp() {
        return this.clamp;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if laoder CAN bus (can1) is conencted")
    boolean isCANbusConnected() {
        return this.bridge.isCanbusConnected();
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoader.class, this.name);
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if hardware (controllers and plutoGateway) is correctly initializedand homing of the controllers is done.")
    public boolean isInitialized() {
        boolean devicesInitialized = this.loaderPlutoGateway.isInitialized() && this.hooksController.isInitialized() && this.carrierController.isInitialized();
        return devicesInitialized && this.clamp.isHomingDone() && this.carrier.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return !this.loaderFilterPresenceSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        return this.loaderOnCameraSensors.isOn();
    }

    public boolean isCarrierRelayOn() {
        return this.loaderCarrierRelayStatus.isOn();
    }

    public boolean isHooksRelayOn() {
        return this.loaderHooksRelayStatus.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        return this.autochanger.isHoldingFilter();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a filter is present and it is held by the loader clamp.")
    public boolean isHoldingFilter() {
        return this.isClosedOnFilter();
    }

    public boolean isClampedOnFilter() {
        if (this.isCANbusConnected()) {
            this.updateStateWithSensors();
            this.clamp.updatePosition();
            return this.clamp.isClamped() && !this.isEmpty();
        }
        return false;
    }

    public boolean isClosedOnFilter() {
        if (this.isCANbusConnected()) {
            this.updateStateWithSensors();
            return this.clamp.isClosed() && !this.isEmpty();
        }
        return false;
    }

    public boolean isOpened() {
        return this.clamp.isOpened();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if loader clamp is openened.")
    public boolean isNotHoldingFilter() {
        this.updateStateWithSensors();
        this.clamp.updatePosition();
        return this.clamp.isOpened();
    }

    @Deprecated
    public void locateHardware() {
        boolean devicesInitialized;
        this.carrier.initializeHardware();
        boolean bl = devicesInitialized = this.loaderPlutoGateway.isInitialized() && this.hooksController.isInitialized() && this.carrierController.isInitialized();
        if (!devicesInitialized) {
            throw new FailedCommandException(this.name + " couldn't locate hardware because devices are not initialized.");
        }
        this.updateStateAndCheckSensors();
        this.checkClosedOnVoid();
        if (this.isEmpty() || this.carrier.isAtHandoff() && this.autochanger.isHoldingFilter()) {
            this.clamp.open();
        } else if (!this.clamp.isClamped()) {
            this.clamp.clamp();
        }
        this.updateFCSStateToReady();
    }

    public void checkClosedOnVoid() {
        if (this.isEmpty() && this.clamp.isClosed()) {
            String msg = this.name + ": carrier is empty and clamp is CLOSED - can't start.";
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, this.name);
            throw new FcsHardwareException(msg);
        }
    }

    public void checkHaltRequired() {
        if (this.main.isHaltRequired() || this.main.isStopRequired()) {
            throw new FailedCommandException(this.name + ": received HALT or STOP command.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize loader hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN initializeHardware"));
        this.bridge.bootProcess();
        try {
            this.postStart();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " couldn't initialize loader", ex);
        }
        FCSCst.FCSLOG.info((Object)(this.name + " END initializeHardware"));
    }

    public void postStart() {
        FCSCst.FCSLOG.info((Object)(this.name + " postStart"));
        if (this.loaderPlutoGateway.isBooted()) {
            this.initializeGateway();
            if (!this.isEmpty() || this.carrier.isAtStorage()) {
                // empty if block
            }
            this.carrier.postStart();
            this.clamp.postStart();
        } else if (this.bridge.isCanbusConnected()) {
            this.loaderPlutoGateway.raiseAlarmIfMissing();
        }
    }

    public void initializeGateway() {
        try {
            this.loaderPlutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize loaderPlutoGateway", ex);
        }
    }

    public void checkConnectedOnCamera() {
        if (!this.isConnectedOnCamera()) {
            throw new RejectedCommandException(this.name + " Loader not connected - can't execute commands.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the carrier can move.")
    public void checkConditionsForCarrierMotion(int targetPosition) {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for carrier motion"));
        this.updateStateAndCheckSensors();
        this.checkClosedOnVoid();
        this.carrier.updatePosition();
        if (this.isEmpty()) {
            FCSCst.FCSLOG.info((Object)(this.name + " no filter. Carrier can move."));
        } else {
            if (this.carrier.isAtHandoff() && this.isAutochangerHoldingFilter() && (this.clamp.isClamped() || this.clamp.isClosed())) {
                throw new RejectedCommandException(this.name + " carrier can't move because a filter is in the loader and it's held by loader AND autochanger.");
            }
            if (this.carrier.getPosition() < this.carrier.getEngagedPosition() && this.acAF1.isOn()) {
                throw new RejectedCommandException(this.name + " carrier can't move because a filter is in the loader AND another one is in the autochanger.");
            }
            this.checkFilterDistanceClamped();
            if (targetPosition <= this.carrier.getEngagedPosition() && this.carrier.getPosition() < this.carrier.getEngagedPosition() + 10) {
                this.clamp.checkClamped();
            } else if (targetPosition >= this.carrier.getEngagedPosition() && this.carrier.getPosition() > this.carrier.getEngagedPosition() - 10) {
                this.clamp.checkUnclamped();
            } else if (this.carrier.isAtHandoff() && this.clamp.isOpened()) {
                FCSCst.FCSLOG.info((Object)(this.name + " carrier can move empty to targetPosition=" + targetPosition));
            } else {
                throw new RejectedCommandException("Carrier has to stop first at ENGAGED position");
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be opened.")
    public void checkConditionsForOpeningHooks() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for opening hooks"));
        this.updateStateAndCheckSensors();
        if (!this.isEmpty()) {
            if (!this.carrier.isAtHandoff()) {
                String msg = this.name + ": carrier is loaded with a filter but not at handoff position - can't open clamp.";
                FCSCst.FCSLOG.error((Object)msg);
                throw new RejectedCommandException(msg);
            }
            if (!this.isAutochangerHoldingFilter()) {
                String msg = this.name + ": A filter is in the loader but not held by autochanger - can't open clamp.";
                FCSCst.FCSLOG.error((Object)msg);
                throw new RejectedCommandException(msg);
            }
        }
    }

    public void checkConditionsForClampingHooks() {
        if (!this.carrier.isAtEngaged()) {
            String msg = this.name + ": carrier is loaded with a filter but not at ENGAGED position - can't clamp.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        if (this.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.name + " Autochanger is holding filter. Open autochanger latches before clamping loader hooks.");
        }
    }

    public void checkConditionsForRecoveryClampingHooks() {
        if (!this.carrier.isLooslyBetweenStorageAndEngaged()) {
            String msg = this.name + ": commands recoveryClamp or recoveryUnclamp can be executed only if carrier is between ENGAGED and STORAGE.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
    }

    public void checkConditionsForUnclampingHooks() {
        if (!this.carrier.isAtEngaged()) {
            String msg = this.name + ": carrier is loaded with a filter but not at ENGAGED position - can't unclamp.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be closed.")
    public void checkLoaderNotEmpty() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for closing hooks"));
        this.updateStateAndCheckSensors();
        this.clamp.updatePosition();
        if (this.isEmpty()) {
            String msg = this.name + ": no filter in loader - can't execute close nor clamp command." + this.clamp.getName();
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
    }

    public void checkFilterDistanceOpened() {
        if (this.clamp.isOpened() && this.carrier.isCarrierApproachingHandoff() && this.loaderFilterDistanceSensor.getVoltage() < this.filterDistanceMin) {
            String msg = this.name + " : filter position is < " + this.filterDistanceMin + " distance to the filter too low; carrier motion must be stopped.";
            FCSCst.FCSLOG.error((Object)msg);
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, this.name);
            throw new FcsHardwareException(msg);
        }
    }

    public void checkFilterDistanceClamped() {
        if (this.clamp.isClamped() && !this.loaderFilterGoodPositionStatus.isOn()) {
            String msg = this.name + " : filter distance status is OFF : distance to the filter too high; carrier motion not allowed.";
            FCSCst.FCSLOG.error((Object)msg);
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, this.name);
            throw new FcsHardwareException(msg);
        }
    }

    public void updateStateAndCheckSensors() {
        this.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
        this.checkConnectedOnCamera();
        this.clamp.checkInitialized();
        this.clamp.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR, this.clamp.getName());
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        FCSCst.FCSLOG.info((Object)(this.name + " bridge=" + this.bridge.toString()));
        FCSCst.FCSLOG.info((Object)(this.name + " bridge CANbus connected=" + this.bridge.isCanbusConnected()));
        if (!this.isCANbusConnected()) {
            FCSCst.FCSLOG.info((Object)(this.name + " about to connect loader CANbus."));
            this.connectLoaderCANbus();
        }
        if (this.isCANbusConnected()) {
            this.loaderPlutoGateway.checkBooted();
            this.loaderPlutoGateway.checkInitialized();
            this.loaderPlutoGateway.updateValues();
            this.carrier.updatePosition();
            this.clamp.updatePosition();
            this.clamp.updateState();
            this.publishData();
            this.clamp.publishData();
            this.carrier.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.clamp.isHomingDone() && this.carrier.isInitialized()) {
            this.main.updateFCSStateToReady();
        }
    }

    public void disconnectLoaderCANbus() {
        this.bridge.disconnectHardware();
    }

    public void connectLoaderCANbus() {
        this.bridge.connectHardware();
        this.postStart();
    }

    public void goToStorage() {
        this.carrier.goToStorage();
    }

    public void goToHandoff() {
        this.carrier.goToHandOff();
    }

    public void goToEngaged() {
        this.carrier.goToEngaged();
    }

    public void goToAbsolutePosition(int newPosition) {
        this.carrier.goToAbsolutePosition(newPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a filter from STORAGE to HANDOFF. This command executes sequence of actions :\n- check initial conditions : a filter is in the loader \n- move carrier to ENGAGED with high speed\n- unclamp filter \n- move slowly filter to HANDOFF. This command can be restarted after a stop in any position of the carrier.", timeout=120000)
    public void moveFilterToHandoff() {
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + " is empty. Command moveFilterToHandoff is not relevant.");
        }
        if (this.carrier.isStrictlyBetweenStorageAndEngaged()) {
            if (!this.clamp.isClamped()) {
                throw new FcsHardwareException(this.name + " filter is not CLAMPED and carrier is between Storage and Engaged. Command moveFilterFromStorageToHandoff can't go on. See recovery procedure.");
            }
            this.carrier.raiseProfileVelocity();
            this.carrier.raiseProfileAcceleration();
            this.carrier.raiseProfileDeceleration();
            this.carrier.goToEngaged();
        }
        if (this.carrier.isAtEngaged()) {
            FcsUtils.sleep(50, this.name);
            this.clamp.unclamp();
        }
        if (this.carrier.isLooslyBetweenEngagedAndHandoff()) {
            if (!this.clamp.isClosed()) {
                throw new FcsHardwareException(this.name + " loader clamp should be CLOSED. Can't go one.");
            }
            this.carrier.slowProfileVelocity();
            this.carrier.slowProfileAcceleration();
            this.carrier.slowProfileDeceleration();
            this.carrier.goToHandOff();
        }
    }

    public void loadFilterIntoStorageBox() {
        if (!this.isClampedOnFilter() || !this.isAtStorage()) {
            throw new RejectedCommandException(this.name + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.moveFilterToHandoff();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
        FcsUtils.sleep(60000, this.name);
        this.openClampAndMoveEmptyToStorage();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
    }

    public void unloadFilterFromStorageBox() {
        throw new RejectedCommandException("command not yet implemented");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a filter from HANDOFF to STORAGE : move filter slowly to ENGAGEDthen clamp and move filter to STORAGE with high speed. This command can be restarted in any position of carrier between HANDOFF and STORAGE. This command can be restarted at any position of the carrier.", timeout=120000)
    public void moveFilterToStorage() {
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + " is empty. Command moveFilterToStorage is not relevant.");
        }
        if (this.carrier.isStrictlyBetweenEngagedAndHandoff()) {
            FCSCst.FCSLOG.info((Object)(this.name + " carrier is between HANDOFF and ENGAGED; about to move slowly to ENGAGED."));
            if (!this.clamp.isClosed()) {
                throw new RejectedCommandException(this.name + " clamp is not CLOSED. Command moveFilterToStorage is not relevant.");
            }
            this.carrier.slowProfileVelocity();
            this.carrier.slowProfileAcceleration();
            this.carrier.slowProfileDeceleration();
            this.carrier.goToEngaged();
        }
        if (this.carrier.isAtEngaged()) {
            FCSCst.FCSLOG.info((Object)(this.name + " carrier is at ENGAGED."));
            FcsUtils.sleep(100, this.name);
            if (!this.clamp.isClamped()) {
                this.clamp.clamp();
            }
        }
        if (this.carrier.isLooslyBetweenStorageAndEngaged()) {
            if (!this.clamp.isClamped()) {
                throw new FcsHardwareException(this.name + " carrier is between STORAGE and ENGAGED and not CLAMPED. moveFilterFromHandoffToStorage can't go on. See recovery procedure.");
            }
            FcsUtils.sleep(50, this.name);
            this.carrier.raiseProfileVelocity();
            this.carrier.raiseProfileAcceleration();
            this.carrier.raiseProfileDeceleration();
            this.carrier.goToStorage();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="open loader hooks and move empty from HANDOFF to STORAGE Position at high speed.", timeout=120000)
    public void openClampAndMoveEmptyToStorage() {
        if (!this.isEmpty() && !this.carrier.isAtHandoff()) {
            throw new RejectedCommandException(this.name + " command openClampAndMoveEmptyToStorage can't be executed when loaded whith a filter and not at HANDOFF");
        }
        if (this.carrier.isAtHandoff()) {
            this.clamp.open();
        }
        if (!this.clamp.isOpened()) {
            throw new FcsHardwareException(this.name + " clamp is not be opened. Command openClampAndMoveEmptyToStorage can't go on. See recovery procedure.");
        }
        this.carrier.raiseProfileVelocity();
        this.carrier.raiseProfileAcceleration();
        this.carrier.raiseProfileDeceleration();
        this.carrier.goToStorage();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move empty from Storage to Handoff at high speed and then close clamp.", timeout=120000)
    public void moveEmptyToHandoffAndClose() {
        if (!this.isEmpty()) {
            throw new RejectedCommandException(this.name + " is not empty. Command moveEmptyToHandoffAndClose is not relevant. Use goToHandoff");
        }
        this.carrier.raiseProfileVelocity();
        this.carrier.raiseProfileAcceleration();
        this.carrier.slowProfileDeceleration();
        this.carrier.goToHandOff();
        if (!this.clamp.isHomingDone()) {
            this.clamp.open();
        }
        this.clamp.close();
    }

    public StatusDataPublishedByLoader createStatusDataPublishedByLoader() {
        StatusDataPublishedByLoader status = new StatusDataPublishedByLoader();
        status.setFilterPresenceSensorValue(this.loaderFilterPresenceSensors.isOn());
        status.setFilterPresenceSensorsInError(this.loaderFilterPresenceSensors.isInError());
        status.setLoaderOnCameraSensorValue(this.loaderOnCameraSensors.isOn());
        status.setLoaderOnCameraSensorsInError(this.loaderOnCameraSensors.isInError());
        status.setAf0(this.acAF0.isOn());
        status.setAf1(this.acAF1.isOn());
        status.setAf3(this.acAF3.isOn());
        status.setAp2(this.acAP2.isOn());
        status.setAf0InError(this.acAF0.isInError());
        status.setAf1InError(this.acAF1.isInError());
        status.setAf3InError(this.acAF3.isInError());
        status.setAp2InError(this.acAP2.isInError());
        status.setKeyEng(this.keyEngSensors.isOn());
        status.setKeyLock(this.keyLockSensors.isOn());
        status.setKeyEngInError(this.keyEngSensors.isInError());
        status.setKeyLockInError(this.keyLockSensors.isInError());
        status.setCarrierRelayStatus(this.loaderCarrierRelayStatus.isOn());
        status.setHooksRelayStatus(this.loaderHooksRelayStatus.isOn());
        status.setLoaderChainPresenceSensor(this.loaderChainPresenceSensor.isOn());
        status.setLoaderDefaultStatus(this.loaderDefaultStatus.isOn());
        status.setLoaderFilterGoodPositionStatus(this.loaderFilterGoodPositionStatus.isOn());
        status.setFilterDistance(this.loaderFilterDistanceSensor.getVoltage());
        status.setLrh(this.loader_LRH.isOn());
        status.setLrhInError(this.loader_LRH.isOn());
        status.setLps(this.loader_LPS.isOn());
        status.setLpsInError(this.loader_LPS.isInError());
        return status;
    }

    public void publishData() {
        StatusDataPublishedByLoader status = this.createStatusDataPublishedByLoader();
        KeyValueData kvd = new KeyValueData("loaderGeneral", (Serializable)status);
        this.s.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public boolean isAtHandoff() {
        return this.carrier.isAtHandoff();
    }

    @Override
    public boolean isAtStandby() {
        return false;
    }

    @Override
    public boolean isAtOnline() {
        return false;
    }

    public boolean isAtStorage() {
        return this.carrier.isAtStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.carrier.printHardwareState());
        sb.append("\n");
        sb.append(this.clamp.printHardwareState());
        return sb.toString();
    }

    @Override
    public int getFilterID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

