/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutochangerLatch;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;

public class SimuAutochangerLatchController
extends SimuEPOSController {
    @ConfigurationParameter(isFinal=true, category="controller")
    private volatile String latchName;
    private AutochangerLatch latch;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private SimuAutochangerPlutoGateway plutoGateway;
    @LookupPath
    private String nodePath;

    public SimuAutochangerLatchController() {
        this.mode = EPOSEnumerations.EposMode.CURRENT;
    }

    public void init() {
        if (this.plutoGateway == null) {
            throw new RuntimeException("Invalid initialization. An instance of SimuAutochangerPlutoGateway should have been picked up from the Lookup tree from the siblinds of this node: " + this.nodePath);
        }
        FCSCst.FCSLOG.debug((Object)(this.name + ":latchName=" + this.latchName));
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.latch = (AutochangerLatch)lookup.getComponentByPath(this.latchName);
        if (this.latch == null) {
            throw new RuntimeException("Could not find latch " + this.latchName);
        }
    }

    @Override
    public void writeCurrent(int aValue) {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        FCSCst.FCSLOG.debug((Object)("=>initial current=" + this.actualCurrent));
        int stepsNB = 10;
        int step = (this.targetCurrent - this.actualCurrent) / stepsNB;
        for (int i = 1; i <= stepsNB; ++i) {
            this.actualCurrent = i < stepsNB ? (int)((short)(currentInitial + i * step)) : aValue;
            this.latch.updateCurrent();
            if (this.actualCurrent == this.latch.getCurrentToClose()) {
                FCSCst.FCSLOG.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.plutoGateway.simulateAutochangerLatchIsLocked(this.latchName);
            } else if (this.actualCurrent == -this.latch.getCurrentToClose()) {
                this.plutoGateway.simulateAutochangerLatchIsUnlocked(this.latchName);
            }
            this.latch.publishData();
            FCSCst.FCSLOG.debug((Object)("i=" + i + ",actualCurrent=" + this.actualCurrent));
            try {
                Thread.sleep(10L);
                if (!this.latch.getHaltRequired().get()) continue;
                FCSCst.FCSLOG.debug((Object)(this.name + " STOP simulated latch motion."));
                return;
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException(this.name + " sleep was interrupted.", (Throwable)ex);
            }
        }
    }

    @Override
    public void stopAction() {
        this.writeCurrent(0);
    }
}

