/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerThreeOnlineClampsProto
extends AutochangerThreeOnlineClamps {
    public AutochangerThreeOnlineClampsProto(AutochangerOnlineClamp onlineClampXminus, AutochangerOnlineClamp onlineClampXplus, AutochangerOnlineClamp onlineClampYminus) {
        super(onlineClampXminus, onlineClampXplus, onlineClampYminus);
    }

    @Override
    public void openClamps() {
        this.openClampsInCurrentMode();
    }

    @Override
    public void closeClamps() {
        this.closeClampsInCurrentMode();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the 3 online clamps.", timeout=6000)
    public void closeClampsInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.onlineClampYminus.closeClampInCurrentMode();
            this.closeClampsXInCurrentMode();
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " clamps already CLOSED nothing to do"));
        } else {
            throw new RejectedCommandException(this.name + " has to be unlocked before.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the 3 online clamps with a small pressure.", timeout=15000)
    public void openClampsInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (!this.isClosed()) {
            if (this.isOpened()) {
                FCSLOG.info((Object)(this.name + " clamps already OPENED. Nothing to do."));
                throw new RejectedCommandException(this.name + " clamps already OPENED. Nothing to do.");
            }
            throw new RejectedCommandException(this.name + " has to be closed before.");
        }
        this.checkReadyForAction();
        this.checkParametersToOpenClampsX();
        this.onlineClampYminus.openClampInCurrentMode();
        this.openClampsXInCurrentMode();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="open clampXs. for proto only.", timeout=15000)
    public void openClampsXInCurrentMode() {
        this.checkParametersToOpenClampsX();
        FcsUtils.parallelRun(() -> this.onlineClampXminus.openClampInCurrentMode(), () -> this.onlineClampXplus.openClampInCurrentMode());
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="close clamps X", timeout=6000)
    public void closeClampsXInCurrentMode() {
        this.checkParametersToCloseClampsX();
        FcsUtils.parallelRun(() -> this.onlineClampXminus.closeClampInCurrentMode(), () -> this.onlineClampXplus.closeClampInCurrentMode());
    }

    public void checkParametersToOpenClampsX() {
        int nbStepXplus;
        int initialValueXminus = this.onlineClampXminus.getFinalCurrentToClose();
        int finalValueXminus = this.onlineClampXminus.getCurrentToOpen();
        int incrementCurrentXminus = this.onlineClampXminus.getIncrementCurrentToOpen();
        int initialValueXplus = this.onlineClampXplus.getFinalCurrentToClose();
        int finalValueXplus = this.onlineClampXplus.getCurrentToOpen();
        int incrementCurrentXplus = this.onlineClampXplus.getIncrementCurrentToOpen();
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int period = this.maxTimeToOpenClampsX / Math.min(nbStepXminus, nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus));
        if (period < this.minPeriod) {
            int newMaxTime = this.minPeriod * Math.min(nbStepXminus, nbStepXplus);
            throw new IllegalArgumentException(this.maxTimeToOpenClampsX + " : value too low for maxTimeToOpenClampsX. should be >= " + newMaxTime);
        }
        if (nbStepXminus != nbStepXplus) {
            FCSLOG.finest((Object)(this.name + ": nbstep to open are not equal for the 2 clamps X"));
        }
    }

    public void checkParametersToCloseClampsX() {
        int nbStepXplus;
        int initialValueXminus = this.onlineClampXminus.getInitialCurrentToClose();
        int finalValueXminus = this.onlineClampXminus.getFinalCurrentToClose();
        int incrementCurrentXminus = this.onlineClampXminus.getIncrementCurrentToClose();
        int initialValueXplus = this.onlineClampXplus.getInitialCurrentToClose();
        int finalValueXplus = this.onlineClampXplus.getFinalCurrentToClose();
        int incrementCurrentXplus = this.onlineClampXplus.getIncrementCurrentToClose();
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int period = this.maxTimeToCloseClampsX / Math.min(nbStepXminus, nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus));
        if (period < this.minPeriod) {
            int newMaxTime = this.minPeriod * Math.min(nbStepXminus, nbStepXplus);
            throw new IllegalArgumentException(this.maxTimeToCloseClampsX + " : value too low. should be > " + newMaxTime);
        }
        if (nbStepXminus != nbStepXplus) {
            FCSLOG.finest((Object)(this.name + ": nbstep to open are not equal for the 2 clamps X"));
        }
    }
}

