/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.List;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FcsMain
extends MainModule {
    private static final long serialVersionUID = 7669526660659959402L;
    private final BridgeToHardware bridgeToLoader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterManager filterManager;
    private long setFilterDuration = 0L;

    public FcsMain(BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    public void init() {
        ((AgentPropertiesService)this.subs.getAgentService(AgentPropertiesService.class)).setAgentProperty("org.lsst.ccs.subsystem.fcs.wholefcs", "fcs");
        DataProviderInfo data = new DataProviderInfo("", DataProviderInfo.Type.TRENDING, "setFilterDuration");
        data.addAttribute(DataProviderInfo.Attribute.UNITS, "milliseconds");
        data.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "duration of command setFilter");
        data.addAttribute(DataProviderInfo.Attribute.TYPE, "long");
        this.dataProviderDictionaryService.addDataProviderInfoToDictionary(data);
    }

    @Override
    public void updateFCSStateToReady() {
        if (this.carousel.isInitialized() && this.autochanger.isInitialized() && this.loader.isInitialized()) {
            this.updateAgentState(FcsEnumerations.FilterState.READY);
            this.updateAgentState(FcsEnumerations.FilterReadinessState.READY);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Sets the filters state to READY even if some sensors are still missing in autochanger.")
    public void forceFilterReadinessStateToReady() {
        this.updateAgentState(FcsEnumerations.FilterState.READY);
        this.updateAgentState(FcsEnumerations.FilterReadinessState.READY);
    }

    public String getOnlineFilterName() {
        if (this.autochanger.isHoldingFilter()) {
            return this.autochanger.getFilterOnTrucksName();
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns the name of the filter which is at ONLINE.")
    public String printFilterONLINEName() {
        if (this.getOnlineFilterName() != null) {
            return this.getOnlineFilterName();
        }
        return "NONE";
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="returns the filter which has for name the String given as argument.")
    public Filter getFilterByName(String filterName) {
        return this.filterManager.getFilterByName(filterName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the changer is connected.")
    public boolean isChangerConnected() {
        return this.bridge.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.autochanger.isLoaderConnected();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the changer is ready.")
    public boolean isChangerReady() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the loader is ready.")
    public boolean isLoaderReady() {
        return this.bridgeToLoader.allDevicesBooted();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disconnect the loader hardware.")
    public void disconnectLoaderCANbus() {
        this.loader.disconnectLoaderCANbus();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Connect the loader hardware.")
    public void connectLoaderCANbus() {
        this.loader.connectLoaderCANbus();
    }

    public void checkFilterName(String aName) {
        this.filterManager.checkFilterName(aName);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the list of LOADER CANopen hardware that this subsystem manages.")
    public List<String> listLoaderHardwareNames() {
        return this.bridgeToLoader.listHardwareNames();
    }

    public boolean isFilterInCamera(int filterID) {
        return this.carousel.isFilterOnCarousel(filterID) || this.autochanger.isFilterOnAC(filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Store the filter in the carousel and move the empty autochanger to HANDOFF position. Initial State for AC: a filter at HANDOFF or ONLINE. Final State for AC : empty at HANDOFF.", autoAck=false, timeout=60000)
    public void storeFilterOnCarousel() {
        this.updateStateWithSensors();
        FCSCst.FCSLOG.info((Object)(this.name + " === About to store filter on carousel ==="));
        if (!FcsEnumerations.FilterReadinessState.READY.equals((Object)this.getFilterReadinessState())) {
            throw new RejectedCommandException(this.name + " FilterReadinessState must be READY");
        }
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new RejectedCommandException(this.name + " carousel should be at standby with an empty socket");
        }
        if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
            throw new RejectedCommandException(this.name + " autochanger must be at HANDOFF or at ONLINE");
        }
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " autochanger must hold the filter");
        }
        if (this.autochanger.isAtOnline()) {
            if (this.autochanger.getOnlineClamps().isLocked()) {
                this.autochanger.getOnlineClamps().unlockClamps();
            }
            if (this.autochanger.getOnlineClamps().isClosed()) {
                if (this.autochanger.getOnlineClamps().isHomingDone()) {
                    this.autochanger.getOnlineClamps().openClamps();
                } else {
                    this.autochanger.getOnlineClamps().homing();
                }
            }
            this.autochanger.disableYminus();
        }
        this.updateStateWithSensors();
        if (!this.autochanger.getOnlineClamps().isOpened()) {
            throw new FcsHardwareException(this.name + " autochanger online clamps should be opened");
        }
        FCSCst.FCSLOG.info((Object)(this.name + " === autochanger is free to move ==="));
        FCSCst.FCSLOG.info((Object)(this.name + " === carousel is ready to receive a filter at standby ==="));
        this.autochanger.getAutochangerTrucks().moveFilterToStandby();
        this.updateStateWithSensors();
        if (!this.carousel.isHoldingFilterAtStandby()) {
            throw new FcsHardwareException(this.name + ": carousel should be CLAMPED_ON_FILTER when autochanger is at STANDBY with a filter");
        }
        FCSCst.FCSLOG.info((Object)"=== carousel is CLAMPED_ON_FILTER === ");
        this.carousel.getSocketAtStandby().updateFilterID();
        FCSCst.FCSLOG.info((Object)("filter ID on CAROUSEL at STANDBY " + this.carousel.getSocketAtStandby().getFilterID()));
        FCSCst.FCSLOG.info((Object)("filter ID on AC = " + this.autochanger.getFilterID()));
        FCSCst.FCSLOG.info((Object)"==================================");
        if (!this.autochanger.isAtStandby()) {
            throw new FcsHardwareException(this.name + ": autochanger should be at STANDBY after moveFilterToStandby() command");
        }
        this.autochanger.waitForProtectionSystemUpdate();
        FCSCst.FCSLOG.info((Object)(this.name + ": is going to moveEmptyFromStandbyToHandoff"));
        this.autochanger.moveEmptyFromStandbyToHandoff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, autoAck=false, description="Unclamp filter from carousel, move autochanger to approachStandby position and release the carousel clamps", timeout=15000)
    public void disengageFilterFromCarousel() {
        this.updateStateWithSensors();
        if (!FcsEnumerations.FilterReadinessState.READY.equals((Object)this.getFilterReadinessState())) {
            throw new RejectedCommandException(this.name + " FilterReadinessState must be READY");
        }
        if (!this.carousel.isAtStandby()) {
            throw new RejectedCommandException(this.name + "Carousel should be at Standby");
        }
        if (!this.autochanger.isAtStandby()) {
            throw new RejectedCommandException("AC should be at Standby Position");
        }
        this.carousel.unlockClamps();
        this.carousel.updateStateWithSensors();
        this.carousel.waitForProtectionSystemUpdate();
        if (!this.carousel.isUnclampedOnFilterAtStandby()) {
            String msg = this.name + "Carousel clamps still locked. Aborting autochanger movement because carousel is still holding the filter. bad state for socketAtStandby: " + this.carousel.getClampsStateAtStandby() + " should be UNCLAMPED_ON_FILTER";
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, this.name);
            throw new FcsHardwareException(this.name + msg);
        }
        this.autochanger.waitForProtectionSystemUpdate();
        this.autochanger.getAutochangerTrucks().moveToApproachStandbyPositionWithLowVelocity();
        this.updateStateWithSensors();
        if (!this.carousel.isEmptyAtStandby()) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Carousel is still seeing the filter", this.name);
            throw new FcsHardwareException(this.name + " aborting autochanger movement because carousel is still seeing filter.");
        }
        this.carousel.releaseClamps();
        this.updateStateWithSensors();
    }

    public boolean autochangerNotInTravel() {
        return this.autochanger.isAtHandoff() || this.autochanger.isAtOnline() || this.autochanger.isAtStandby();
    }

    public boolean latchesOpenOrClosed() {
        return this.autochanger.getLatches().isClosed() || this.autochanger.getLatches().isOpened();
    }

    public boolean onlineClampsOpenOrLocked() {
        return this.autochanger.getOnlineClamps().isLocked() || this.autochanger.getOnlineClamps().isOpened();
    }

    public boolean filterAtOnlineMustBeLocked() {
        return !this.autochanger.isAtOnline() || this.autochanger.isEmpty() || this.autochanger.getOnlineClamps().isLocked();
    }

    public boolean filterAtStandbyMustBeHeld() {
        return !this.autochanger.isAtStandby() || this.autochanger.isEmpty() || this.autochanger.isHoldingFilter() || this.carousel.isHoldingFilterAtStandby();
    }

    public boolean carouselHoldingFilterOrReadyToGrab() {
        return this.carousel.isHoldingFilterAtStandby() || this.carousel.isReadyToGrabAFilterAtStandby();
    }

    public boolean carouselReadyToClampAtStandby() {
        return this.autochanger.isAtStandby() || this.autochanger.isEmpty() || this.carousel.isReadyToGrabAFilterAtStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Move filter to ONLINE position.", timeout=180000, autoAck=false)
    public void setFilter(int filterID) {
        this.updateStateWithSensors();
        this.checkControllers();
        FCSCst.FCSLOG.info((Object)(this.name + ": filter to set online:" + filterID));
        this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Object[0]).precondition(this.filterManager.containsFilterID(filterID), "%s: Unknown filter id : %s", new Object[]{this.name, filterID}).precondition(this.isFilterInCamera(filterID), "%s: filter %s in out of camera", new Object[]{this.name, filterID}).precondition(this.carousel.isAtStandby(), "carousel not stopped at STANDBY position", new Object[0]).precondition(this.autochangerNotInTravel(), "AC trucks are not at a HANDOFF or ONLINE or STANDBY", new Object[0]).precondition(this.latchesOpenOrClosed(), "%s: bad state for autochanger latches - have to be OPENED or CLOSED", new Object[]{this.autochanger.getLatches().getLockStatus()}).precondition(this.onlineClampsOpenOrLocked(), "%s: bad state for AC ONLINE clamps - have to be OPENED or LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtOnlineMustBeLocked(), "%s: bad state for AC ONLINE clamps - at ONLINE with a filter should be LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtStandbyMustBeHeld(), "When a filter is at STANDBY it must be held by AC or by carousel.", new Object[0]).precondition(this.carouselHoldingFilterOrReadyToGrab(), "%s: bad state for carousel : should be holding a filter or ready to receive a filter", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(this.carouselReadyToClampAtStandby(), "%s: bad state for carousel when a filter is on AC at HANDOFF or ONLINE: should be READYTOCLAMP", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).action(() -> {
            long beginTime = System.currentTimeMillis();
            if (this.autochanger.isHoldingFilter()) {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding a filter, filter name= " + this.autochanger.getFilterOnTrucksName()));
            } else {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is not holding filter, filter name on AC" + this.autochanger.getFilterOnTrucksName()));
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is on socket:" + this.carousel.getFilterSocket(filterID).getId()));
            }
            if (!this.carousel.isHomingDone() && (this.autochanger.isAtHandoff() || this.autochanger.isAtOnline())) {
                this.carousel.homing();
            }
            if (!this.autochanger.isFilterOnAC(filterID)) {
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is NOT on AC"));
                if (this.autochanger.isAtStandby()) {
                    FCSCst.FCSLOG.info((Object)(this.name + " autochanger is at STANDBY, it has to be moved empty at HANDOFF"));
                    this.autochanger.moveEmptyFromStandbyToHandoff();
                } else if (this.autochanger.isHoldingFilter()) {
                    FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding filter: " + this.autochanger.getFilterOnTrucksName()));
                    FCSCst.FCSLOG.info((Object)(this.name + ": is going to store a filter on carousel"));
                    this.storeFilterOnCarousel();
                }
                if (!this.autochanger.isEmpty() || !this.autochanger.isAtHandoff()) {
                    throw new FcsHardwareException(this.name + ": autochanger is not empty at handoff");
                }
                this.carousel.rotateSocketToStandby(this.carousel.getFilterSocket(filterID).getName());
                FcsUtils.sleep(100, this.name);
                this.updateStateWithSensors();
                if (!this.carousel.isAtStandby()) {
                    throw new FcsHardwareException(this.name + ": carousel should be at standby after rotateSocketToStandby command.");
                }
                FCSCst.FCSLOG.info((Object)(this.name + ": carousel is at standby"));
                if (this.carousel.getFilterIDatStandby() != filterID) {
                    throw new FcsHardwareException(this.name + " filterID at standby is " + this.carousel.getFilterIDatStandby() + " should be: " + filterID);
                }
                this.autochanger.waitForProtectionSystemUpdate();
                this.autochanger.grabFilterAtStandby();
                this.updateStateWithSensors();
                if (!this.autochanger.isFilterOnAC(filterID)) {
                    throw new FcsHardwareException(this.name + " filter: " + filterID + " should be now on AC");
                }
            }
            if (this.autochanger.isAtStandby()) {
                this.disengageFilterFromCarousel();
                this.updateStateWithSensors();
                this.autochanger.moveAndClampFilterOnline();
            } else if (this.autochanger.isAtHandoff()) {
                this.autochanger.moveAndClampFilterOnline();
            } else if (this.autochanger.isAtOnline()) {
                this.autochanger.lockFilterAtOnline();
            }
            String filterName = this.filterManager.getFilterNameByID(filterID);
            String letter = filterName.substring(6, filterName.length());
            this.updateAgentState(FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + letter)));
            this.setFilterDuration = System.currentTimeMillis() - beginTime;
            FCSCst.FCSLOG.info((Object)("filter " + filterID + " is ONLINE. setFilterDuration = " + this.setFilterDuration));
            this.publishData();
        });
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Select filter and move to HANDOFF position without going to ONLINE.", timeout=180000, autoAck=false)
    public void setFilterWithSafety(int filterID) {
        this.updateStateWithSensors();
        this.checkControllers();
        FCSCst.FCSLOG.info((Object)(this.name + ": filter to set online:" + filterID));
        this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Object[0]).precondition(!this.isLoaderConnected(), "loader is connected - can't continue setFilter", new Object[0]).precondition(this.filterManager.containsFilterID(filterID), "%s: Unknown filter id : %s", new Object[]{this.name, filterID}).precondition(this.isFilterInCamera(filterID), "%s: filter %s in out of camera", new Object[]{this.name, filterID}).precondition(this.carousel.isAtStandby(), "carousel not stopped at STANDBY position", new Object[0]).precondition(this.autochangerNotInTravel(), "AC trucks are not at a HANDOFF or ONLINE or STANDBY", new Object[0]).precondition(this.latchesOpenOrClosed(), "%s: bad state for autochanger latches - have to be OPENED or CLOSED", new Object[]{this.autochanger.getLatches().getLockStatus()}).precondition(this.onlineClampsOpenOrLocked(), "%s: bad state for AC ONLINE clamps - have to be OPENED or LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtOnlineMustBeLocked(), "%s: bad state for AC ONLINE clamps - at ONLINE with a filter should be LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtStandbyMustBeHeld(), "When a filter is at STANDBY it must be held by AC or by carousel.", new Object[0]).precondition(this.carouselHoldingFilterOrReadyToGrab(), "%s: bad state for carousel : should be holding a filter or ready to receive a filter", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(this.carouselReadyToClampAtStandby(), "%s: bad state for carousel when a filter is on AC at HANDOFF or ONLINE: should be READYTOCLAMP", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).action(() -> {
            long beginTime = System.currentTimeMillis();
            if (this.autochanger.isHoldingFilter()) {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding a filter, filter name= " + this.autochanger.getFilterOnTrucksName()));
            } else {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is not holding filter, filter name on AC" + this.autochanger.getFilterOnTrucksName()));
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is on socket:" + this.carousel.getFilterSocket(filterID).getId()));
            }
            if (!this.carousel.isHomingDone() && (this.autochanger.isAtHandoff() || this.autochanger.isAtOnline())) {
                this.carousel.homing();
            }
            if (!this.autochanger.isFilterOnAC(filterID)) {
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is NOT on AC"));
                if (this.autochanger.isAtStandby()) {
                    FCSCst.FCSLOG.info((Object)(this.name + " autochanger is at STANDBY, it has to be moved empty at HANDOFF"));
                    this.autochanger.moveEmptyFromStandbyToHandoff();
                } else if (this.autochanger.isHoldingFilter()) {
                    FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding filter: " + this.autochanger.getFilterOnTrucksName()));
                    FCSCst.FCSLOG.info((Object)(this.name + ": is going to store a filter on carousel"));
                    this.storeFilterOnCarousel();
                }
                if (!this.autochanger.isEmpty() || !this.autochanger.isAtHandoff()) {
                    throw new FcsHardwareException(this.name + ": autochanger is not empty at handoff");
                }
                this.carousel.rotateSocketToStandby(this.carousel.getFilterSocket(filterID).getName());
                FcsUtils.sleep(100, this.name);
                this.updateStateWithSensors();
                if (!this.carousel.isAtStandby()) {
                    throw new FcsHardwareException(this.name + ": carousel should be at standby after rotateSocketToStandby command.");
                }
                FCSCst.FCSLOG.info((Object)(this.name + ": carousel is at standby"));
                if (this.carousel.getFilterIDatStandby() != filterID) {
                    throw new FcsHardwareException(this.name + " filterID at standby is " + this.carousel.getFilterIDatStandby() + " should be: " + filterID);
                }
                this.autochanger.grabFilterAtStandby();
                this.updateStateWithSensors();
                if (!this.autochanger.isFilterOnAC(filterID)) {
                    throw new FcsHardwareException(this.name + " filter: " + filterID + " should be now on AC");
                }
            }
            if (this.autochanger.isAtStandby()) {
                this.disengageFilterFromCarousel();
                this.updateStateWithSensors();
                this.autochanger.getAutochangerTrucks().moveToHandoffWithHighVelocity();
            } else if (this.autochanger.isAtOnline() && this.autochanger.getOnlineClamps().isOpened()) {
                this.autochanger.getAutochangerTrucks().moveToApproachOnlinePositionWithLowVelocity();
                this.autochanger.getAutochangerTrucks().moveToHandoffWithHighVelocity();
            }
            String filterName = this.filterManager.getFilterNameByID(filterID);
            String letter = filterName.substring(6, filterName.length());
            this.updateAgentState(FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + letter)));
            this.setFilterDuration = System.currentTimeMillis() - beginTime;
            FCSCst.FCSLOG.info((Object)("filter " + filterID + " is ONLINE. setFilterDuration = " + this.setFilterDuration));
            this.publishData();
        });
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="change subsystem state.")
    public void changeState(String state) {
        this.updateAgentState(FcsEnumerations.FilterState.valueOf((String)state));
        FCSCst.FCSLOG.fine((Object)("SUBSYSTEM STATE=" + this.isInState((Enum)FcsEnumerations.FilterState.valueOf((String)state))));
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Load a filter from the loader to the camera. The loader must hold a filter at STORAGE position.The autochanger must be empty at HANDOFF, latches open. At the end of this command thefilter is held by autochanger at Handoff position, and the loader carrier is empty at STORAGE.")
    public void loadFilter() {
        this.updateStateWithSensors();
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.name + " autochanger is not empty at HANDOFF position; can't load a filter.");
        }
        if (!this.autochanger.getLatches().isOpened()) {
            throw new RejectedCommandException("Autochanger latches must be open before loadFilter command.");
        }
        if (!this.loader.isClampedOnFilter() || !this.loader.isAtStorage()) {
            throw new RejectedCommandException(this.name + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.loader.moveFilterFromStorageToHandoff();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
        this.autochanger.closeLatches();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
        this.loader.openClampAndMoveEmptyToStorage();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unload a filter from the camera to the loader. The camera has to be at horizontal position. The filter has to be on Autochanger at HANDOFF. Loader carrier must be empty at STORAGE. \nAt the end of this command, autochanger is empty at HANDOFF, latches are open, and loader carrier is holding the filter at STORAGE (hooks are clamped)")
    public void unloadFilter() {
        this.updateStateWithSensors();
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " autochanger is not holding a filter at STANDOFF position; can't unload a filter.");
        }
        if (!(this.loader.isEmpty() && this.loader.isOpened() && this.loader.isAtStorage())) {
            // empty if block
        }
        this.loader.moveEmptyToHandoffAndClose();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
        this.autochanger.openLatches();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
        this.loader.moveFilterFromHandoffToStorage();
        FcsUtils.sleep(50, this.name);
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="check if controllers are in fault")
    public void checkControllers() {
        this.bridge.checkControllers();
    }

    @Override
    public void updateStateWithSensors() {
        this.carousel.updateStateWithSensors();
        if (this.carousel.isAtStandby()) {
            this.carousel.getSocketAtStandby().updateFilterID();
        }
        this.autochanger.updateStateWithSensors();
        if (this.autochanger.getAutochangerTrucks().isAtOnline() && this.autochanger.isHoldingFilter() && this.autochanger.getOnlineClamps().isLocked()) {
            String filterName = this.filterManager.getFilterNameByID(this.autochanger.getFilterID());
            String shortFilterName = filterName.substring(6, filterName.length());
            this.updateAgentState(FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + shortFilterName)));
        } else {
            this.updateAgentState(FcsEnumerations.FilterState.valueOf((String)"ONLINE_NONE"));
        }
        if (this.loader.isConnectedOnCamera()) {
            this.loader.updateStateWithSensors();
        }
    }

    @Override
    public void initializeHardware() {
        this.carousel.initializeHardware();
        this.autochanger.initializeHardware();
        this.loader.initializeHardware();
        this.postStart();
    }

    @Override
    public void publishData() {
        super.publishData();
        this.bridgeToLoader.publishData();
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData("setFilterDuration", (Serializable)Long.valueOf(this.setFilterDuration)));
    }

    public void postStart() {
    }

    @Override
    public void postShutdown() {
        FCSCst.FCSLOG.info((Object)(this.name + " is shutting down."));
        this.bridge.doShutdown();
        if (this.loader.isCANbusConnected()) {
            this.bridgeToLoader.doShutdown();
        }
        FCSCst.FCSLOG.info((Object)(this.name + " is shutdown."));
    }
}

