
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.LookupField;
import static org.lsst.ccs.commons.annotations.LookupField.Strategy.TREE;

import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

/**
 *
 * @author virieux
 */
public class SimuLoaderCarrierController extends SimuEPOSController {

    @LookupField(strategy = TREE, pathFilter = ".*carrier")
    private LoaderCarrier carrier;

    @LookupField(strategy = TREE, pathFilter = ".*loader")
    private Loader loader;

    private final SimuLoaderPlutoGateway plutoGateway;

    /**
     * Build a new SimuLoaderCarrierController
     * @param nodeID
     * @param serialNB
     * @param plutoGateway
     */
    public SimuLoaderCarrierController(
            int nodeID, String serialNB,
            SimuLoaderPlutoGateway plutoGateway
    ) {
        super(nodeID, serialNB);
        this.plutoGateway = plutoGateway;
    }

    /**
     *
     * @param positionToReached
     * @throws SDORequestException
     */
    @Override
    public void writeTargetPosition(int positionToReached)  {

        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSLOG.debug("loader carrier is moving.");
        FCSLOG.debug(name + "=>position intitiale=" + position);
        int stepsNB = 20;
        int step = (targetPosition - this.position) / stepsNB;

        for (int i = 1; i < stepsNB; i++) {
            try {

                this.position = positionInitiale + (i * step);
                carrier.updatePosition();
                if (position == carrier.getHandoffPosition()) {
                    FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (position == carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                loader.updateStateWithSensors();
                carrier.publishData();
                FCSLOG.debug(name + "i=" + i + ",position=" + position);
                try {
                    Thread.sleep(500);
                    if (carrier.getHaltRequired().get()) {
                        FCSLOG.debug(name + " STOP simulated carrrier motion.");
                        return;
                    }
                } catch (InterruptedException ex) {
                    throw new RejectedCommandException(name + " sleep was interrupted.");
                }

            } catch (FcsHardwareException ex) {
                FCSLOG.error(ex);
                throw new RejectedCommandException(ex.getMessage());
            }

        }
        this.position = targetPosition;
        if (position == carrier.getHandoffPosition()) {
            FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (position == carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else if (position == carrier.getEngagedPosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtEngaged();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }

    }


}
