
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import static org.lsst.ccs.commons.annotations.LookupField.Strategy.CHILDREN;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This class is the Main Module when autochanger is in standalone mode.
 *
 * @author virieux
 */
public class AutochangerMain extends MainModule {

    @LookupField(strategy = CHILDREN)
    private Autochanger autochanger;

    private FakeFilterHolder carousel;
    private FakeFilterHolder loader;

    /**
     * Build a AutochangerMainModule.
     *
     * @param bridge
     */
    public AutochangerMain(BridgeToHardware bridge) {
        super(bridge);
    }

    @Override
    public void init() {
        /*
         * define a role for my subsystem in order to make AutochangerGUI listen to my
         * subsystem (cf GeneralGUI.connecting())
         */
        subs.getAgentService(AgentPropertiesService.class).setAgentProperty("org.lsst.ccs.subsystem.fcs.autochanger", "autochanger");
    }

    /**
     * Update autochanger state in reading the sensors.
     *
     * @throws FcsHardwareException
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, description = "Update autochanger state in reading the sensors.")
    @Override
    public void updateStateWithSensors() {
        autochanger.updateStateWithSensors();
    }


    /**
     * initialize hardware after initialization. to be executed if during boot
     * process some hardware is missing.
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "Check hardware after initialization. To be executed if during boot process some hardware is missing.")
    @Override
    public void initializeHardware() {
        autochanger.initializeHardware();
    }

}
