/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForOnlineClamp;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;

public class SimuAutochangerOnlineClampController
extends SimuEPOSController
implements EPOSControllerForOnlineClamp {
    @ConfigurationParameter(isFinal=true)
    private volatile String onlineClampName;
    private final SimuAutochangerPlutoGateway plutoGateway;
    private AutochangerOnlineClamp onlineClamp;
    private boolean brakeActivatedPub;
    private boolean homingDone = true;

    public SimuAutochangerOnlineClampController(int nodeID, String serialNB, SimuAutochangerPlutoGateway plutoGateway, String onlineClampName) {
        super(nodeID, serialNB);
        this.onlineClampName = onlineClampName;
        this.plutoGateway = plutoGateway;
    }

    @Override
    public boolean isBrakeActivatedPub() {
        return this.brakeActivatedPub;
    }

    @Override
    public void setBrakeActivatedPub(boolean brakeActivatedToPublish) {
        this.brakeActivatedPub = brakeActivatedToPublish;
    }

    public void init() {
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.onlineClamp = (AutochangerOnlineClamp)lookup.getComponentByPath(this.onlineClampName);
    }

    @Override
    public void writeCurrent(int current) {
        this.targetCurrent = current;
        this.actualCurrent = current;
        if (this.targetCurrent == this.onlineClamp.getFinalCurrentToClose()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsClosed(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToOpen()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsOpened(this.onlineClamp);
        } else if (this.targetCurrent == this.onlineClamp.getCurrentToClamp()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsLocked(this.onlineClamp);
        }
    }

    @Override
    public void writeTargetPosition(int positionToReach) {
        this.targetPosition = positionToReach;
        this.position = positionToReach;
        this.onlineClamp.updatePosition();
        if (this.targetPosition == this.onlineClamp.getTargetPositionToOpen()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsOpened(this.onlineClamp);
        } else if (this.targetPosition == this.onlineClamp.getTargetPositionToClose()) {
            this.plutoGateway.simulateAutochangerOnlineClampIsClosed(this.onlineClamp);
        }
    }

    @Override
    public void activateBrakeAndDisable() {
        this.brakeActivatedPub = true;
    }

    @Override
    public void enableAndReleaseBrake() {
        this.brakeActivatedPub = false;
    }

    @Override
    public void doReleaseBrake() {
        this.brakeActivatedPub = false;
    }

    @Override
    public boolean isBrakeActivated() {
        return this.brakeActivatedPub;
    }

    @Override
    public void activateBrake() {
        this.brakeActivatedPub = true;
    }

    @Override
    public void homing() {
    }

    @Override
    public boolean isHomingDone() {
        return this.homingDone;
    }
}

