/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSystecIO;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.utilities.logging.Logger;

public class SystecIO_X5
extends Device
implements AlertRaiser {
    protected static final Logger FCSLOG = FCSCst.FCSLOG;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    double[] temperatures;
    CanOpenSystecIO tempSensorsDevice;

    public SystecIO_X5(CanOpenSystecIO tempSensorsDevice) {
        this.tempSensorsDevice = tempSensorsDevice;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.s;
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.tempSensorsDevice.isBooted()) {
            this.initializePostStart();
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    public void initializePostStart() {
        try {
            this.tempSensorsDevice.initialize();
            this.setOnline(true);
            this.temperatures = new double[9];
            for (int i = 1; i < 9; ++i) {
                this.temperatures[i] = 0.0;
            }
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize tempSensorsDevice", this.tempSensorsDevice.getName(), (Exception)((Object)ex));
        }
    }

    public void initialize() {
    }

    public double[] readTemperatures() {
        return this.temperatures;
    }

    protected void close() {
    }

    public double readChannel(int chanelNO, int type) {
        double temp = this.temperatures[chanelNO];
        try {
            temp = this.tempSensorsDevice.readChannel(chanelNO);
        }
        catch (Exception ex) {
            FCSLOG.warning((Object)(this.getName() + " : couldn't read temperatures"), (Throwable)ex);
        }
        return temp;
    }
}

