/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsMain;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class FcsToto
extends CcsTestCaseTemplate {
    private static Subsystem fcsSubsystem = null;
    private static FcsMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static AutochangerTwoLatches latches;
    private static Carousel carousel;
    private static SimuCarouselController carouselController;
    private static SimuTTC580 hyttc580;
    private static SimuAutochangerPlutoGateway acPlutoGateway;
    private static FilterManager filterManager;
    private static Filter filterI;
    private static int socket1StandbyPos;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static AutochangerOnlineClamp[] onelineClampsList;
    private static CarouselSocket socket1;
    private static CarouselClamp clampXminus1;
    private static CarouselClamp clampXplus1;
    private static CarouselClamp clampXminus2;
    private static CarouselClamp clampXplus2;
    private static CarouselClamp clampXminus3;
    private static CarouselClamp clampXplus3;
    private static CarouselClamp clampXminus4;
    private static CarouselClamp clampXplus4;
    private static CarouselClamp clampXminus5;
    private static CarouselClamp clampXplus5;
    private static CarouselClamp[] clampsList;
    private static int LOCKA;
    private static int LOCKB;
    private static int LOCKC;
    private static int FILTERPRESENCEA;
    private static int FILTERPRESENCEB;
    private static int FILTERPRESENCEC;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("************************************************************************************");
        System.out.println("***                  TESTS OF THE WHOLE FCS SIMULATED                            ***");
        System.out.println("************************************************************************************");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.fcs.run.mode", "simulation");
        fcsSubsystem = BootUtils.getSubsystemFromFile((String)"fcs", (String)"");
        fcsSubsystem.startAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)ConfigurationState.CONFIGURED), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = fcsSubsystem.getComponentLookup();
        main = (FcsMain)lookup.getComponentByPath("main");
        autochanger = (Autochanger)lookup.getComponentByPath("autochanger");
        carousel = (Carousel)lookup.getComponentByPath("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByPath("carouselController");
        hyttc580 = (SimuTTC580)lookup.getComponentByPath("hyttc580");
        socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        acPlutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByPath("acSensorsGateway");
        trucks = (AutochangerTwoTrucks)lookup.getComponentByPath("autochangerTrucks");
        trucks.updatePosition();
        latches = (AutochangerTwoLatches)lookup.getComponentByPath("latches");
        filterManager = (FilterManager)lookup.getComponentByPath("filterManager");
        filterI = filterManager.getFilterByName("filterI");
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByPath("onlineClampYminus");
        for (AutochangerOnlineClamp autochangerOnlineClamp : onelineClampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus}) {
            autochangerOnlineClamp.setIncrementCurrentToClose(300);
            autochangerOnlineClamp.setIncrementCurrentToOpen(300);
            autochangerOnlineClamp.setIncrementCurrentToClamp(532);
            autochangerOnlineClamp.setInitialCurrentToClose(300);
            autochangerOnlineClamp.setFinalCurrentToClose(1800);
            autochangerOnlineClamp.setCurrentToOpen(-300);
            autochangerOnlineClamp.setCurrentToClamp(4992);
        }
        clampXminus1 = (CarouselClamp)lookup.getComponentByPath("clampXminus1");
        clampXplus1 = (CarouselClamp)lookup.getComponentByPath("clampXplus1");
        clampXminus2 = (CarouselClamp)lookup.getComponentByPath("clampXminus2");
        clampXplus2 = (CarouselClamp)lookup.getComponentByPath("clampXplus2");
        clampXminus3 = (CarouselClamp)lookup.getComponentByPath("clampXminus3");
        clampXplus3 = (CarouselClamp)lookup.getComponentByPath("clampXplus3");
        clampXminus4 = (CarouselClamp)lookup.getComponentByPath("clampXminus4");
        clampXplus4 = (CarouselClamp)lookup.getComponentByPath("clampXplus4");
        clampXminus5 = (CarouselClamp)lookup.getComponentByPath("clampXminus5");
        clampXplus5 = (CarouselClamp)lookup.getComponentByPath("clampXplus5");
        clampsList = new CarouselClamp[]{clampXminus1, clampXplus1, clampXminus2, clampXplus2, clampXminus3, clampXplus3, clampXminus4, clampXplus4, clampXminus5, clampXplus5};
        for (AutochangerOnlineClamp autochangerOnlineClamp : clampsList) {
            autochangerOnlineClamp.setLockSensorValueA(Integer.valueOf(LOCKA));
            autochangerOnlineClamp.setLockSensorValueB(Integer.valueOf(LOCKB));
            autochangerOnlineClamp.setLockSensorMaxValue(Integer.valueOf(LOCKC));
            autochangerOnlineClamp.setFilterPresenceOffset1(Integer.valueOf(FILTERPRESENCEA));
            autochangerOnlineClamp.setFilterPresenceOffset2(Integer.valueOf(FILTERPRESENCEB));
            autochangerOnlineClamp.setFilterPresenceValueB(Integer.valueOf(FILTERPRESENCEC));
        }
        Assert.assertTrue((String)"Carousel and Autochanger hardware is ready", (boolean)main.isChangerReady());
        socket1.setFilterID(29);
        Assert.assertEquals((String)"filterID on Carousel at STANDBY", (long)29L, (long)socket1.getFilterID());
    }

    @Before
    public void setUp() throws DriverException {
        Utils.printJoliSetUp("FcsTest");
        socket1StandbyPos = carousel.getSocketByName("socket1").getStandbyPosition();
        carouselController.initializeAndCheckHardware();
        carousel.homing();
        carouselController.setSsiPosition(socket1StandbyPos);
        carousel.updatePosition();
        Assert.assertEquals((String)"socket1 standby position", (long)socket1StandbyPos, (long)carousel.getSocketByName("socket1").getStandbyPosition());
        Assert.assertEquals((String)"carousel position", (long)socket1StandbyPos, (long)carousel.getPosition());
        FcsToto.initializePDOs();
        carousel.updateStateWithSensors();
        acPlutoGateway.simulateAutochangerTrucksAreAtHandoff();
        acPlutoGateway.simulateAutochangerIsEmpty();
        acPlutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)"name of socket at STANDBY", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        Assert.assertEquals((String)"socket at STANDBY", (Object)carousel.getSocketAtStandby(), (Object)carousel.getSocketByName("socket1"));
        Assert.assertEquals((String)"socket ID at STANDBY", (long)1L, (long)carousel.getSocketAtStandbyID());
        Assert.assertEquals((String)"socket1 ID", (long)1L, (long)socket1.getId());
        Assert.assertEquals((String)"socket1 standby position", (long)socket1StandbyPos, (long)carousel.getSocketByName("socket1").getStandbyPosition());
        Assert.assertEquals((String)"carousel position", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertTrue((String)"socket1 is at STANDBY", (boolean)socket1.isAtStandby());
        socket1.setFilterID(29);
        Assert.assertEquals((String)"filterID on Carousel at STANDBY", (long)29L, (long)carousel.getFilterID());
        Assert.assertFalse((String)"socket2 is NOT at STANDBY", (boolean)carousel.getSocketByName("socket2").isAtStandby());
        Assert.assertEquals((String)"clampXminus2 lock status", (Object)FcsEnumerations.LockStatus.LOCKED, (Object)clampXminus2.getLockStatus());
        Assert.assertEquals((String)"socket2 clamp state", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName("socket2").getClampsState());
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
    }

    private static void initializePDOs() throws DriverException {
        CarouselClamp[] clampsAtStandby;
        hyttc580.setPdo1(0L);
        hyttc580.setPdo2(0L);
        carouselController.setPdo1(0L);
        carouselController.setPdo2(0L);
        carouselController.simulatePosition((long)socket1StandbyPos);
        System.out.println(" ==> socket1 initialization");
        hyttc580.simulateSocketAtStandby((short)1);
        for (CarouselClamp clamp : clampsAtStandby = new CarouselClamp[]{clampXminus1, clampXplus1}) {
            hyttc580.simulateClampIsLocked(clamp);
            hyttc580.simulateClampFilterIsLockable(clamp);
        }
        for (int i = 2; i < 6; ++i) {
            String socketName = "socket" + i;
            System.out.println("==>" + socketName + " initialization");
            CarouselSocket socket = carousel.getSocketByName(socketName);
            System.out.println("i==" + i);
            hyttc580.simulateSocketNotAtStandby((short)i);
            hyttc580.simulateSlaveStatusNotAtS((short)i);
            hyttc580.simulateClampIsLockedNotAtS(socket.getClampXminus());
            hyttc580.simulateClampIsLockedNotAtS(socket.getClampXplus());
            hyttc580.simulateClampFilterIsLockableNotAtS(socket.getClampXminus());
            hyttc580.simulateClampFilterIsLockableNotAtS(socket.getClampXplus());
            System.out.println("hyttc580:" + hyttc580);
            carousel.updateStateWithSensors();
            Assert.assertFalse((String)(socketName + " is NOT at STANDBY"), (boolean)carousel.getSocketByName(socketName).isAtStandby());
            Assert.assertEquals((String)(socketName + " SlaveModuleStatus"), (Object)FcsEnumerations.SlaveModuleStatus.IS_READY_NOT_IN_POSITION, (Object)socket.getSlaveModuleStatus());
            Assert.assertEquals((String)(socketName + " clampXplus lock status"), (Object)FcsEnumerations.LockStatus.LOCKED, (Object)socket.getClampXplus().getLockStatus());
            Assert.assertEquals((String)(socketName + " clampXminus lock status"), (Object)FcsEnumerations.LockStatus.LOCKED, (Object)socket.getClampXminus().getLockStatus());
        }
    }

    public void testUpdateStateWithSensors() {
        System.out.println("********************************************************");
        System.out.println("*** test method updateStateWithSensors from FcsMain  ***");
        System.out.println("********************************************************");
        acPlutoGateway.simulateAutochangerTrucksAreAtStandby();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"AC trucks at STANDBY", (boolean)trucks.isAtStandby());
    }

    @Test
    public void testSimulateAutochangerTrucksAreAtStandby() {
        System.out.println("************************************************************************************");
        System.out.println("*** test simulateAutochangerTrucksAreAtStandby from SimuAutochangerPlutoGateway  ***");
        System.out.println("************************************************************************************");
        int id = 29;
        acPlutoGateway.simulateFilterIDOnAutochanger(29);
        autochanger.updateStateWithSensors();
        Assert.assertEquals((String)("filter on trucks is now " + id), (long)id, (long)autochanger.getFilterID());
        Assert.assertTrue((String)"filter ID 29 is on AC", (boolean)autochanger.isFilterOnAC(29));
        acPlutoGateway.simulateAutochangerTrucksAreAtStandby();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"AC trucks at STANDBY", (boolean)trucks.isAtStandby());
        Assert.assertTrue((String)"filter ID 29 is still on AC", (boolean)autochanger.isFilterOnAC(29));
    }

    public void testExchangeBetweenCarouselAndAutochanger() throws DriverException {
        System.out.println("*******************************************************");
        System.out.println("*** test Exchange Between Carousel And Autochanger  ***");
        System.out.println("*******************************************************");
        System.out.println(" from carousel to autochanger");
        Assert.assertTrue((String)"autochanger is empty", (boolean)autochanger.isEmpty());
        Assert.assertEquals((String)"filterID on AC", (long)0L, (long)autochanger.getFilterID());
        Assert.assertEquals((String)"filterID on Carousel at STANDBY", (long)29L, (long)carousel.getFilterID());
        trucks.goToStandby();
        autochanger.getLatches().close();
        main.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"AC holds filter", (boolean)autochanger.isHoldingFilter());
        Assert.assertEquals((String)"filterID on AC", (long)29L, (long)autochanger.getFilterID());
        carousel.unlockClamps();
        trucks.goToOnline();
        main.updateStateWithSensors();
        Assert.assertEquals((String)"socket1 is socketAtStandby", (Object)carousel.getSocketAtStandby(), (Object)carousel.getSocketByName("socket1"));
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertFalse((String)"carousel is no more holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertFalse((String)"socket2 is NOT at STANDBY", (boolean)carousel.getSocketByName("socket2").isAtStandby());
        Assert.assertEquals((String)"socket2 clamp state", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName("socket2").getClampsState());
        Assert.assertEquals((String)"socket1 clamp state", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY, (Object)socket1.getClampsState());
        Assert.assertEquals((String)"filterID 29 still on AC", (long)29L, (long)autochanger.getFilterID());
        Assert.assertEquals((String)"filterID on Carousel at STANDBY", (long)0L, (long)carousel.getFilterID());
        carousel.releaseClamps();
        Assert.assertEquals((String)"clamps state at STANDBY", (Object)FcsEnumerations.FilterClampState.READYTOCLAMP, (Object)carousel.getSocketAtStandby().getClampsState());
        System.out.println(" from autochanger to carousel");
        trucks.goToStandby();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertEquals((String)"socket1 is now CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName("socket1").getClampsState());
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        latches.open();
        trucks.goToHandOff();
        Assert.assertTrue((String)"Autochanger is now empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Autochanger is at HANDOFF", (boolean)autochanger.getAutochangerTrucks().isAtHandoff());
        Assert.assertTrue((String)"Filter is now on Carousel", (boolean)carousel.isFilterOnCarousel(autochanger.getFilterID()));
    }

    @AfterClass
    public static void after() throws Exception {
        fcsSubsystem.shutdownAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
    }

    public void launchScript() throws Exception {
        System.out.println("**************************************");
        System.out.println("***       launch  fcsTest.py       ***");
        System.out.println("**************************************");
        CCS.initializeScriptingEnvironment();
        Assert.assertTrue((String)"fcsSubsystem should be in OPERATIONAL phase.", (boolean)((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).isInState((Enum)PhaseState.OPERATIONAL));
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/fcsTest.py", (String[])new String[0]);
        System.out.println("**************************************");
        System.out.println("*** end of execution of fcsTest.py ***");
        System.out.println("**************************************");
    }

    static {
        LOCKA = 1000;
        LOCKB = 2000;
        LOCKC = 3000;
        FILTERPRESENCEA = 500;
        FILTERPRESENCEB = 1500;
        FILTERPRESENCEC = 2500;
    }
}

