/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.List;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FcsMain
extends MainModule {
    private static final long serialVersionUID = 7669526660659959402L;
    private final BridgeToHardware bridgeToLoader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterManager filterManager;
    private long setFilterDuration = 0L;

    public FcsMain(BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    public void init() {
        ((AgentPropertiesService)this.subs.getAgentService(AgentPropertiesService.class)).setAgentProperty("org.lsst.ccs.subsystem.fcs.wholefcs", "fcs");
    }

    @Override
    public void updateFCSStateToReady() {
        if (this.carousel.isInitialized() && this.autochanger.isInitialized() && this.loader.isInitialized()) {
            this.updateAgentState(FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Sets the filters state to READY even if some sensors are still missing in autochanger.")
    public void forceFilterReadinessStateToReady() {
        this.updateAgentState(FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY);
    }

    public String getOnlineFilterName() {
        if (this.autochanger.isHoldingFilter()) {
            return this.autochanger.getFilterOnTrucksName();
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns the name of the filter which is at ONLINE.")
    public String printFilterONLINEName() {
        if (this.getOnlineFilterName() != null) {
            return this.getOnlineFilterName();
        }
        return "NONE";
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="returns the filter which has for name the String given as argument.")
    public Filter getFilterByName(String filterName) {
        return this.filterManager.getFilterByName(filterName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the changer is connected.")
    public boolean isChangerConnected() {
        return this.bridge.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the changer is ready.")
    public boolean isChangerReady() {
        return this.bridge.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the loader is ready.")
    public boolean isLoaderReady() {
        return this.bridgeToLoader.allDevicesBooted();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disconnect the loader hardware.")
    public void disconnectLoader() {
        this.bridgeToLoader.disconnectHardware();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Connect the loader hardware.")
    public void connectLoader() {
        this.bridgeToLoader.connectHardware();
        this.loader.postStart();
    }

    public void checkFilterName(String aName) {
        this.filterManager.checkFilterName(aName);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the list of LOADER CANopen hardware that this subsystem manages.")
    public List<String> listLoaderHardwareNames() {
        return this.bridgeToLoader.listHardwareNames();
    }

    public boolean isFilterInCamera(int filterID) {
        return this.carousel.isFilterOnCarousel(filterID) || this.autochanger.isFilterOnAC(filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Store the filter in the carousel and move the empty autochanger to HANDOFF position.", autoAck=false, timeout=60000)
    public void storeFilterOnCarousel() {
        this.updateStateWithSensors();
        FCSCst.FCSLOG.info((Object)(this.name + " about to store filter on carousel"));
        this.subs.helper().precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).precondition(this.autochanger.isHoldingFilter()).precondition(this.autochanger.isAtHandoff() || this.autochanger.isAtOnline()).precondition(this.carousel.isReadyToGrabAFilterAtStandby(), " carousel should be at standby with an empty socket", new Object[0]).action(() -> {
            this.updateStateWithSensors();
            if (!this.carousel.isAtStandby() || !this.carousel.isEmptyAtStandby()) {
                throw new FcsHardwareException(this.name + " carousel should be at standby with an empty socket");
            }
            FCSCst.FCSLOG.info((Object)(this.name + " carousel is at standby with an empty socket "));
            if (this.autochanger.isAtOnline()) {
                if (this.autochanger.getOnlineClamps().isLocked()) {
                    this.autochanger.getOnlineClamps().unlockClamps();
                }
                if (this.autochanger.getOnlineClamps().isClosed()) {
                    if (this.autochanger.getOnlineClamps().isHomingDone()) {
                        this.autochanger.getOnlineClamps().openClamps();
                    } else {
                        this.autochanger.getOnlineClamps().homing();
                    }
                }
            }
            this.updateStateWithSensors();
            if (!this.autochanger.getOnlineClamps().isOpened()) {
                throw new FcsHardwareException(this.name + " autochanger online clamps should be opened");
            }
            FCSCst.FCSLOG.info((Object)(this.name + " autochanger is free to move"));
            FCSCst.FCSLOG.info((Object)(this.name + " carousel is ready to receive a filter at standby"));
            this.autochanger.getAutochangerTrucks().moveFilterToStandby();
            this.updateStateWithSensors();
            if (!this.carousel.isHoldingFilterAtStandby()) {
                throw new FcsHardwareException(this.name + ": carousel should be CLAMPED_ON_FILTER when autochanger is at STANDBY with a filter");
            }
            FCSCst.FCSLOG.info((Object)": carousel is CLAMPED_ON_FILTER");
            if (!this.autochanger.isAtStandby()) {
                throw new FcsHardwareException(this.name + ": autochanger should be at STANDBY after moveFilterToStandby() command");
            }
            FCSCst.FCSLOG.info((Object)(this.name + ": is going to moveEmptyFromStandbyToHandoff"));
            this.autochanger.moveEmptyFromStandbyToHandoff();
        });
    }

    @Command(type=Command.CommandType.ACTION, level=1, autoAck=false, description="Unclamp filter from carousel, move autochanger to approachStandby position and release the carousel clamps", timeout=15000)
    public void disengageFilterFromCarousel() {
        this.updateStateWithSensors();
        this.checkControllers();
        this.subs.helper().precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).precondition(this.carousel.isAtStandby(), "Carousel should be at Standby", new Object[0]).precondition(this.autochanger.isAtStandby(), "AC should be at Standby or Handoff position", new Object[0]).action(() -> {
            this.carousel.unlockClamps();
            FcsUtils.sleep(100, this.name);
            this.carousel.updateStateWithSensors();
            if (!this.carousel.isUnclampedOnFilterAtStandby()) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Carousel clamps still locked", this.name);
                throw new FcsHardwareException(this.name + " aborting autochanger movement because carousel is still holding the filter. bad state for socketAtStandby: " + this.carousel.getClampsStateAtStandby() + " should be UNCLAMPED_ON_FILTER");
            }
            this.autochanger.getAutochangerTrucks().moveToApproachStandbyPositionWithLowVelocity();
            this.updateStateWithSensors();
            if (!this.carousel.isEmptyAtStandby()) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Carousel is still seeing the filter", this.name);
                throw new FcsHardwareException(this.name + " aborting autochanger movement because carousel is still seeing filter.");
            }
            this.carousel.releaseClamps();
            this.updateStateWithSensors();
        });
    }

    public boolean autochangerNotInTravel() {
        return this.autochanger.isAtHandoff() || this.autochanger.isAtOnline() || this.autochanger.isAtStandby();
    }

    public boolean latchesOpenOrClosed() {
        return this.autochanger.getLatches().isClosed() || this.autochanger.getLatches().isOpened();
    }

    public boolean onlineClampsOpenOrLocked() {
        return this.autochanger.getOnlineClamps().isLocked() || this.autochanger.getOnlineClamps().isOpened();
    }

    public boolean filterAtOnlineMustBeLocked() {
        return !this.autochanger.isAtOnline() || this.autochanger.isEmpty() || this.autochanger.getOnlineClamps().isLocked();
    }

    public boolean filterAtStandbyMustBeHeld() {
        return !this.autochanger.isAtStandby() || this.autochanger.isEmpty() || this.autochanger.isHoldingFilter() || this.carousel.isHoldingFilterAtStandby();
    }

    public boolean carouselHoldingFilterOrReadyToGrab() {
        return this.carousel.isHoldingFilterAtStandby() || this.carousel.isReadyToGrabAFilterAtStandby();
    }

    public boolean carouselReadyToClampAtStandby() {
        return this.autochanger.isAtStandby() || this.autochanger.isEmpty() || this.carousel.isReadyToGrabAFilterAtStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Move filter to ONLINE position.", timeout=180000, autoAck=false)
    public void setFilter(int filterID) {
        this.updateStateWithSensors();
        this.checkControllers();
        FCSCst.FCSLOG.info((Object)(this.name + ": filter to set online:" + filterID));
        this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Object[0]).precondition(!this.isLoaderConnected(), "loader is connected - can't continue setFilter", new Object[0]).precondition(this.filterManager.containsFilterID(filterID), "%s: Unknown filter id : %s", new Object[]{this.name, filterID}).precondition(this.isFilterInCamera(filterID), "%s: filter %s in out of camera", new Object[]{this.name, filterID}).precondition(this.carousel.isAtStandby(), "carousel not stopped at STANDBY position", new Object[0]).precondition(this.autochangerNotInTravel(), "AC trucks are not at a HANDOFF or ONLINE or STANDBY", new Object[0]).precondition(this.latchesOpenOrClosed(), "%s: bad state for autochanger latches - have to be OPENED or CLOSED", new Object[]{this.autochanger.getLatches().getLockStatus()}).precondition(this.onlineClampsOpenOrLocked(), "%s: bad state for AC ONLINE clamps - have to be OPENED or LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtOnlineMustBeLocked(), "%s: bad state for AC ONLINE clamps - at ONLINE with a filter should be LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtStandbyMustBeHeld(), "When a filter is at STANDBY it must be held by AC or by carousel.", new Object[0]).precondition(this.carouselHoldingFilterOrReadyToGrab(), "%s: bad state for carousel : should be holding a filter or ready to receive a filter", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(this.carouselReadyToClampAtStandby(), "%s: bad state for carousel when a filter is on AC at HANDOFF or ONLINE: should be READYTOCLAMP", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).action(() -> {
            long beginTime = System.currentTimeMillis();
            if (this.autochanger.isHoldingFilter()) {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding a filter, filter name= " + this.autochanger.getFilterOnTrucksName()));
            } else {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is not holding filter, filter name on AC" + this.autochanger.getFilterOnTrucksName()));
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is on socket:" + this.carousel.getFilterSocket(filterID).getId()));
            }
            if (!this.carousel.isHomingDone() && (this.autochanger.isAtHandoff() || this.autochanger.isAtOnline())) {
                this.carousel.homing();
            }
            if (!this.autochanger.isFilterOnAC(filterID)) {
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is NOT on AC"));
                if (this.autochanger.isAtStandby()) {
                    FCSCst.FCSLOG.info((Object)(this.name + " autochanger is at STANDBY, it has to be moved empty at HANDOFF"));
                    this.autochanger.moveEmptyFromStandbyToHandoff();
                } else if (this.autochanger.isHoldingFilter()) {
                    FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding filter: " + this.autochanger.getFilterOnTrucksName()));
                    FCSCst.FCSLOG.info((Object)(this.name + ": is going to store a filter on carousel"));
                    this.storeFilterOnCarousel();
                }
                if (!this.autochanger.isEmpty() || !this.autochanger.isAtHandoff()) {
                    throw new FcsHardwareException(this.name + ": autochanger is not empty at handoff");
                }
                this.carousel.rotateSocketToStandby(this.carousel.getFilterSocket(filterID).getName());
                FcsUtils.sleep(100, this.name);
                this.updateStateWithSensors();
                if (!this.carousel.isAtStandby()) {
                    throw new FcsHardwareException(this.name + ": carousel should be at standby after rotateSocketToStandby command.");
                }
                FCSCst.FCSLOG.info((Object)(this.name + ": carousel is at standby"));
                if (this.carousel.getFilterIDatStandby() != filterID) {
                    throw new FcsHardwareException(this.name + " filterID at standby is " + this.carousel.getFilterIDatStandby() + " should be: " + filterID);
                }
                this.autochanger.grabFilterAtStandby();
                this.updateStateWithSensors();
                if (!this.autochanger.isFilterOnAC(filterID)) {
                    throw new FcsHardwareException(this.name + " filter: " + filterID + " should be now on AC");
                }
            }
            if (this.autochanger.isAtStandby()) {
                this.disengageFilterFromCarousel();
                this.updateStateWithSensors();
                this.autochanger.moveAndClampFilterOnline();
            } else if (this.autochanger.isAtHandoff()) {
                this.autochanger.moveAndClampFilterOnline();
            } else if (this.autochanger.isAtOnline()) {
                this.autochanger.lockFilterAtOnline();
            }
            String filterName = this.filterManager.getFilterNameByID(filterID);
            String letter = filterName.substring(6, filterName.length());
            this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + letter), FcsEnumerations.FilterReadinessState.READY);
            this.setFilterDuration = System.currentTimeMillis() - beginTime;
            FCSCst.FCSLOG.info((Object)("filter " + filterID + " is ONLINE. setFilterDuration = " + this.setFilterDuration));
            this.publishData();
        });
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Select filter and move to HANDOFF position without going to ONLINE.", timeout=180000, autoAck=false)
    public void setFilterWithSafety(int filterID) {
        this.updateStateWithSensors();
        this.checkControllers();
        FCSCst.FCSLOG.info((Object)(this.name + ": filter to set online:" + filterID));
        this.subs.helper().precondition(!this.agentStateService.isInState((Enum)AlertState.ALARM), "can't execute commands in ALARM state.", new Object[0]).precondition(!this.isLoaderConnected(), "loader is connected - can't continue setFilter", new Object[0]).precondition(this.filterManager.containsFilterID(filterID), "%s: Unknown filter id : %s", new Object[]{this.name, filterID}).precondition(this.isFilterInCamera(filterID), "%s: filter %s in out of camera", new Object[]{this.name, filterID}).precondition(this.carousel.isAtStandby(), "carousel not stopped at STANDBY position", new Object[0]).precondition(this.autochangerNotInTravel(), "AC trucks are not at a HANDOFF or ONLINE or STANDBY", new Object[0]).precondition(this.latchesOpenOrClosed(), "%s: bad state for autochanger latches - have to be OPENED or CLOSED", new Object[]{this.autochanger.getLatches().getLockStatus()}).precondition(this.onlineClampsOpenOrLocked(), "%s: bad state for AC ONLINE clamps - have to be OPENED or LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtOnlineMustBeLocked(), "%s: bad state for AC ONLINE clamps - at ONLINE with a filter should be LOCKED", new Object[]{this.autochanger.getOnlineClamps().getLockStatus()}).precondition(this.filterAtStandbyMustBeHeld(), "When a filter is at STANDBY it must be held by AC or by carousel.", new Object[0]).precondition(this.carouselHoldingFilterOrReadyToGrab(), "%s: bad state for carousel : should be holding a filter or ready to receive a filter", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(this.carouselReadyToClampAtStandby(), "%s: bad state for carousel when a filter is on AC at HANDOFF or ONLINE: should be READYTOCLAMP", new Object[]{this.carousel.getClampsStateAtStandby()}).precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).action(() -> {
            long beginTime = System.currentTimeMillis();
            if (this.autochanger.isHoldingFilter()) {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding a filter, filter name= " + this.autochanger.getFilterOnTrucksName()));
            } else {
                FCSCst.FCSLOG.info((Object)(this.name + ": AC is not holding filter, filter name on AC" + this.autochanger.getFilterOnTrucksName()));
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is on socket:" + this.carousel.getFilterSocket(filterID).getId()));
            }
            if (!this.carousel.isHomingDone() && (this.autochanger.isAtHandoff() || this.autochanger.isAtOnline())) {
                this.carousel.homing();
            }
            if (!this.autochanger.isFilterOnAC(filterID)) {
                FCSCst.FCSLOG.info((Object)(this.name + ": filterID: " + filterID + " is NOT on AC"));
                if (this.autochanger.isAtStandby()) {
                    FCSCst.FCSLOG.info((Object)(this.name + " autochanger is at STANDBY, it has to be moved empty at HANDOFF"));
                    this.autochanger.moveEmptyFromStandbyToHandoff();
                } else if (this.autochanger.isHoldingFilter()) {
                    FCSCst.FCSLOG.info((Object)(this.name + ": AC is holding filter: " + this.autochanger.getFilterOnTrucksName()));
                    FCSCst.FCSLOG.info((Object)(this.name + ": is going to store a filter on carousel"));
                    this.storeFilterOnCarousel();
                }
                if (!this.autochanger.isEmpty() || !this.autochanger.isAtHandoff()) {
                    throw new FcsHardwareException(this.name + ": autochanger is not empty at handoff");
                }
                this.carousel.rotateSocketToStandby(this.carousel.getFilterSocket(filterID).getName());
                FcsUtils.sleep(100, this.name);
                this.updateStateWithSensors();
                if (!this.carousel.isAtStandby()) {
                    throw new FcsHardwareException(this.name + ": carousel should be at standby after rotateSocketToStandby command.");
                }
                FCSCst.FCSLOG.info((Object)(this.name + ": carousel is at standby"));
                if (this.carousel.getFilterIDatStandby() != filterID) {
                    throw new FcsHardwareException(this.name + " filterID at standby is " + this.carousel.getFilterIDatStandby() + " should be: " + filterID);
                }
                this.autochanger.grabFilterAtStandby();
                this.updateStateWithSensors();
                if (!this.autochanger.isFilterOnAC(filterID)) {
                    throw new FcsHardwareException(this.name + " filter: " + filterID + " should be now on AC");
                }
            }
            if (this.autochanger.isAtStandby()) {
                this.disengageFilterFromCarousel();
                this.updateStateWithSensors();
                this.autochanger.getAutochangerTrucks().moveToHandoffWithHighVelocity();
            } else if (this.autochanger.isAtOnline() && this.autochanger.getOnlineClamps().isOpened()) {
                this.autochanger.getAutochangerTrucks().moveToApproachOnlinePositionWithLowVelocity();
                this.autochanger.getAutochangerTrucks().moveToHandoffWithHighVelocity();
            }
            String filterName = this.filterManager.getFilterNameByID(filterID);
            String letter = filterName.substring(6, filterName.length());
            this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + letter), FcsEnumerations.FilterReadinessState.READY);
            this.setFilterDuration = System.currentTimeMillis() - beginTime;
            FCSCst.FCSLOG.info((Object)("filter " + filterID + " is ONLINE. setFilterDuration = " + this.setFilterDuration));
            this.publishData();
        });
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="change subsystem state.")
    public void changeState(String state) {
        this.updateAgentState(FcsEnumerations.FilterState.valueOf(state), FcsEnumerations.FilterReadinessState.READY);
        FCSCst.FCSLOG.fine((Object)("SUBSYSTEM STATE=" + this.isInState(FcsEnumerations.FilterState.valueOf(state))));
    }

    public void loadFilter(int filterID) {
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new RejectedCommandException(this.name + " can't load a filter when socket at STANDBY position is not empty and ready.");
        }
        if (!this.autochanger.getAutochangerTrucks().isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.name + " autochanger is not empty at STANDOFF position; can't load a filter.");
        }
        if (!this.loader.isHoldingFilter() || !this.loader.getCarrier().isAtStorage()) {
            throw new RejectedCommandException(this.name + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.loader.getCarrier().goToHandOff();
        this.autochanger.getAutochangerTrucks().goToHandOff();
        this.autochanger.grabFilterAtHandoff(filterID);
        this.loader.openClampAndMoveEmptyToStorage();
    }

    public void unloadFilter(int filterID) {
        if (this.carousel.isFilterOnCarousel(filterID)) {
            throw new RejectedCommandException(this.name + " : filter " + filterID + " is not on the carousel, can't unload it.");
        }
        if (!this.carousel.isAtStandby(filterID)) {
            throw new RejectedCommandException(this.name + " : filter " + filterID + " is not on the carousel at standby position, can't unload it.");
        }
        if (!this.autochanger.getAutochangerTrucks().isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.name + " autochanger is not empty at STANDOFF position; can't unload a filter.");
        }
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.getAutochangerTrucks().goToStandby();
        this.autochanger.getLatches().close();
        FCSCst.FCSLOG.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.unlockClamps();
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to handoff position.");
        this.autochanger.moveFilterToHandoff(filterID);
        FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        this.loader.getCarrier().goToHandOff();
        this.loader.getClamp().close();
        this.autochanger.ungrabFilterAtHandoff(filterID);
        this.loader.getClamp().clamp();
        this.loader.getCarrier().goToStorage();
        this.disconnectLoader();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="check if controllers are in fault")
    public void checkControllers() {
        this.bridge.checkControllers();
    }

    @Override
    public void updateStateWithSensors() {
        this.carousel.updateStateWithSensors();
        if (this.carousel.isAtStandby()) {
            this.carousel.getSocketAtStandby().updateFilterID();
        }
        this.autochanger.updateStateWithSensors();
        if (this.autochanger.getAutochangerTrucks().isAtOnline() && this.autochanger.isHoldingFilter() && this.autochanger.getOnlineClamps().isLocked()) {
            String filterName = this.filterManager.getFilterNameByID(this.autochanger.getFilterID());
            String shortFilterName = filterName.substring(6, filterName.length());
            this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_" + shortFilterName), this.getFilterReadinessState());
        } else {
            this.updateAgentState(FcsEnumerations.FilterState.valueOf("ONLINE_NONE"), this.getFilterReadinessState());
        }
        if (this.loader.isConnectedOnCamera()) {
            this.loader.updateStateWithSensors();
        }
    }

    @Override
    public void initializeHardware() {
        this.carousel.initializeHardware();
        this.autochanger.initializeHardware();
        this.loader.initializeHardware();
        this.postStart();
    }

    @Override
    public void publishData() {
        super.publishData();
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData("setFilterDuration", (Serializable)Long.valueOf(this.setFilterDuration)));
    }

    public void postStart() {
    }
}

