/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class ForceSensor
implements SensorPluggedOnDevice {
    @LookupName
    private String name = "unset";
    private int voltage;
    @ConfigurationParameter
    protected String deviceName;
    @ConfigurationParameter
    protected int byteNumero;
    @Deprecated
    @ConfigurationParameter(description="Min value for range where hooks are clamped: over this value and below maxRangeValue, hooks are clamped.  Unit is N")
    private int minRangeValue = 15;
    @Deprecated
    @ConfigurationParameter(description="Max value for range where hooks are clamped:below this value and over minRangeValue, hooks are clamped.  Unit is N")
    private int maxRangeValue = 25;
    @Deprecated
    @ConfigurationParameter(description="Below this limit, there is no load on the clamp  so clamp is really unclamped.Over this limit and below minRangeValue, clamp is UNDER_LOAD, neither clamped, neither unclamped.  Unit is N")
    private int underLoadLimit = 5;
    @Deprecated
    private FcsEnumerations.LockStatus forceStatus;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Deprecated
    public int getMinRangeValue() {
        return this.minRangeValue;
    }

    @Deprecated
    public int getMaxRangeValue() {
        return this.maxRangeValue;
    }

    @Deprecated
    public int getUnderLoadLimit() {
        return this.underLoadLimit;
    }

    @Override
    public void updateValue(int newValue) {
        FCSCst.FCSLOG.info((Object)(this.name + " updating voltage = " + newValue));
        this.voltage = newValue;
        this.computeForceStatus();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Returns force sensor analog Value. No unit.")
    public int getVoltage() {
        return this.voltage;
    }

    @Deprecated
    public FcsEnumerations.LockStatus getForceStatus() {
        return this.forceStatus;
    }

    @Deprecated
    private void computeForceStatus() {
        this.forceStatus = this.voltage < this.underLoadLimit ? FcsEnumerations.LockStatus.UNCLAMPED : (this.voltage < this.minRangeValue ? FcsEnumerations.LockStatus.UNDER_CLAMPED : (this.voltage < this.maxRangeValue ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.OVER_CLAMPED));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a string representation of ForceSensor")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/deviceName=");
        sb.append(this.deviceName);
        sb.append("/byteNumero=");
        sb.append(String.valueOf(this.byteNumero));
        sb.append("/voltage=");
        sb.append(String.valueOf(this.voltage));
        return sb.toString();
    }
}

