
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.drivers.CanCBXAI814;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;

/**
 * A general simulated CanOpenSensor14bits. The simulated sensor doesn't read
 * its new value on a CANopen device but the new value is generated by a random
 * generator between a min and a max value. These values can be changed with
 * method setNewRange.
 *
 * @author virieux
 */
public class SimuCanOpenSensor14bits extends CanOpenSensor14bits {

    @LookupField(strategy = Strategy.TOP)
    protected Subsystem s;

    @LookupField(strategy = Strategy.TREE)
    protected AgentStateService agentStateService;

    /* the clamp this simulated sensor belongs to */
    @LookupField(strategy = Strategy.ANCESTORS)
    protected CarouselClamp clamp;

    @LookupField(strategy = Strategy.TREE, pathFilter = ".*autochanger")
    protected FilterHolder autochanger;

    /* used in isAtStandby method */
    @LookupField(strategy = Strategy.TREE, pathFilter = ".*carousel")
    private Carousel carousel;

    /**
     * Creates a new SimuCanOpenSensor14bits from arguments :
     *
     * @param adc
     * @param numOfAnalogInput
     */
    public SimuCanOpenSensor14bits(CanCBXAI814 adc, int numOfAnalogInput) {
        super(adc, numOfAnalogInput);
    }

    /**
     * return true if this sensor is on the clamp which is at STANDBY. return false
     * if no socket is at STANDBY or if this sensor is on a clamp which is not at
     * STANDBY. Used by simulator of clamps sensors to know where a filter presence
     * sensor or a clamp sensor has to be modified when the autochnager trucks
     * arrive at STANDBY.
     *
     * @return
     */
    protected boolean isAtStandby() {
        CarouselSocket socket = carousel.getSocketAtStandby();
        if (socket == null) {
            return false;
        } else {
            String socketName = socket.getName();
            char numSocket = socketName.charAt(socketName.length() - 1);
            char myNum = getName().charAt(name.length() - 1);
            return numSocket == myNum;
        }
    }
}
