/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerTruck;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerTwoTrucks
extends MobileItem
implements ClearAlertHandler {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Subsystem subs;
    private AutochangerTruck truckXminus;
    private AutochangerTruck truckXplus;
    @ConfigurationParameter(description="minimal position for AC trucks")
    private final int minActualPositionValue = 0;
    @ConfigurationParameter(description="maximal position for AC trucks")
    private final int maxActualPositionValue = 1200000;
    @ConfigurationParameter(description="STANDBY position in micron")
    private int standbyPosition = 997500;
    @ConfigurationParameter(description="HANDOFF position in micron")
    private int handoffPosition = 70000;
    @ConfigurationParameter(description="ONLINE position in micron")
    private int onlinePosition = 2600;
    @ConfigurationParameter(description="time for trucks motion from ONLINE to STANDBY in milliseconds")
    private long timeoutForTrucksMotion = 20000L;
    @ConfigurationParameter(description="prelimary ONLINE position in micron, used by process whichmoves a filter at ONLINE position.")
    private int prelimaryTargetPosition = 3367;
    @ConfigurationParameter(description="natural position at ONLINE position in micron  used by process whichmoves a filter at ONLINE position.")
    private int naturalPosition = 3215;
    @ConfigurationParameter(description="lowest position to be used by command moveAndClampFilterOnline.")
    private int minTargetPosition = 1800;
    @ConfigurationParameter(description="minimum value of voltage read on proximitySensor.", units="Volt")
    private double umin = 4.2;
    @ConfigurationParameter(description="maximum value of voltage read on proximitySensor. Unit: Volts")
    private double umax = 4.6;
    @ConfigurationParameter(description="voltage target on proximitySensor. Unit: Volts")
    private double utarget = 3.85;
    @ConfigurationParameter(description="adjustment factor. Unit: micrometre/volt")
    private double adjustmentFactor = 835.0;
    @ConfigurationParameter(description="low speed to approach STANDBY position")
    private int lowSpeed = 50;
    @ConfigurationParameter(description="high speed to approach STANDBY position")
    private int highSpeed = 260;
    @ConfigurationParameter(description="low acceleration to approach STANDBY position")
    private int lowAcceleration = 150;
    @ConfigurationParameter(description="high acceleration to approach STANDBY position")
    private int highAcceleration = 310;
    @ConfigurationParameter(description="low deceleration to approach STANDBY position")
    private int lowDeceleration = 50;
    @ConfigurationParameter(description="high deceleration to approach STANDBY position")
    private int highDeceleration = 310;
    @ConfigurationParameter(description="approach STANDBY position")
    private int approachStandbyPosition = 950000;
    @ConfigurationParameter(description="approach ONLINE position")
    private int approachOnlinePosition = 10000;
    private int current = 0;
    private int speed = 0;
    private long profileVelocity;
    private int masterPosition;
    private int slavePosition;
    private int deltaPosition;
    private int positionRange = 100;
    @ConfigurationParameter(description="position is reached at STANDBY if |targetPosition - masterPosition| < positionRangeAtStandby")
    private int positionRangeAtStandby = 100;
    @ConfigurationParameter(description="position is reached at ONLINE if |targetPosition - masterPosition| < positionRangeAtOnline")
    private int positionRangeAtOnline = 50;
    @ConfigurationParameter(description="position is reached at HANDOFF if |targetPosition - masterPosition| < positionRangeAtOnline")
    private int positionRangeAtHandoff = 100;
    @ConfigurationParameter(description="position is reached in TRAVEL if |targetPosition - masterPosition| < positionRangeAtOnline")
    private int positionRangeInTravel = 150;
    @ConfigurationParameter(description="an alignment of slave must be done when |deltaPosition| > deltaPositionMax")
    private int deltaPositionMax = 100;
    private int absoluteTargetPosition = 0;
    private int slaveTargetPosition = 0;
    private EPOSControllerForLinearRail linearRailMasterController;
    private EPOSControllerForLinearRail linearRailSlaveController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*proximitySensorsDevice")
    private ADCInterface proximitySensorsDevice;
    @ConfigurationParameter(description="input number on the ADC where proximity sensor is plugged", range="1..4")
    private int proximitySensorInput = 1;
    private boolean atHandoff = false;
    private boolean atOnline = false;
    private boolean atStandby = false;

    public AutochangerTwoTrucks(AutochangerTruck truckXminus, AutochangerTruck truckXplus, EPOSControllerForLinearRail linearRailMasterController, EPOSControllerForLinearRail linearRailSlaveController) {
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
        this.linearRailMasterController = linearRailMasterController;
        this.linearRailSlaveController = linearRailSlaveController;
    }

    @ConfigurationParameterChanger
    public void setNaturalPosition(int pos) {
        int minLimit = this.onlinePosition - 1500;
        int maxLimit = this.onlinePosition + 1500;
        if (pos < minLimit || pos > maxLimit) {
            throw new IllegalArgumentException(pos + " bad value for natural position must be > " + minLimit + " and < " + maxLimit);
        }
        this.naturalPosition = pos;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return actual trucks position (master position). Doesn't read again the position on the controller.")
    public int getPosition() {
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return HANDOFF position. Doesn't read again the position on the controller.")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return STANDBY position. Doesn't read again the position on the controller.")
    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return ONLINE position. Doesn't read again the position on the controller.")
    public int getOnlinePosition() {
        return this.onlinePosition;
    }

    public int getApproachStandbyPosition() {
        return this.approachStandbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return timeout for trucks motion.")
    public long getTimeoutForTrucksMotion() {
        return this.timeoutForTrucksMotion;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.atHandoff;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.atOnline;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.atStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the homing of the trucks has been done.")
    public boolean isHomingDone() {
        return this.linearRailSlaveController.isHomingDone() && this.linearRailMasterController.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if TruckXminus position sensors or TruckXminus position sensors are in error.")
    public boolean isPositionSensorsInError() {
        return this.truckXminus.isPositionSensorsInError() || this.truckXplus.isPositionSensorsInError() || this.positionSensorsNonConsistant();
    }

    private boolean positionSensorsNonConsistant() {
        return this.isAtStandby() && this.isAtHandoff() || this.isAtStandby() && this.isAtOnline() || this.isAtHandoff() && this.isAtOnline();
    }

    public boolean isPositionSensorErrorsTransient() {
        int delta = 5000;
        boolean errorHandoff = this.truckXminus.isHandoffSensorsInError() || this.truckXplus.isHandoffSensorsInError();
        boolean errorOnline = this.truckXminus.isOnlineSensorsInError() || this.truckXplus.isOnlineSensorsInError();
        boolean errorStandby = this.truckXminus.isStandbySensorsInError() || this.truckXplus.isStandbySensorsInError();
        return errorHandoff && Math.abs(this.masterPosition - this.handoffPosition) < delta || errorOnline && Math.abs(this.masterPosition - this.onlinePosition) < delta || errorStandby && Math.abs(this.masterPosition - this.standbyPosition) < delta;
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.linearRailSlaveController.isBooted() && this.linearRailMasterController.isBooted()) {
            this.initializeControllers();
        }
        if (this.proximitySensorsDevice.isBooted()) {
            this.proximitySensorsDevice.initializeAndCheckHardware();
            this.proximitySensorsDevice.publishData();
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " can't clamp at ONLINE if proximitySensorsDevice not booted", this.name);
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    public void initializeControllers() {
        try {
            this.linearRailSlaveController.initializeAndCheckHardware();
            this.linearRailMasterController.initializeAndCheckHardware();
            if (this.autochanger.isLinearRailMotionAllowed()) {
                this.homing();
                FCSLOG.info((Object)(this.name + " homing of AC trucks done."));
            }
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Couldn't initialize controllers or do homing", this.name, ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() {
        FCSLOG.info((Object)(this.name + " Begin configuration of the controllers"));
        this.linearRailMasterController.configureDigitalInputOfLinearRails();
        this.linearRailSlaveController.configureDigitalInputOfLinearRails();
        this.linearRailMasterController.configureDigitalOutputOfLinearRails();
        this.linearRailSlaveController.configureDigitalOutputOfLinearRails();
        FCSLOG.info((Object)(this.name + " End configuration of the controllers"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if both controllers are initialized and homing of trucks are done.")
    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized() && this.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the motion of trucks are allowed.")
    public void checkConditionsForTrucksMotion() {
        this.autochanger.checkFilterSafetyBeforeMotion();
        this.checkPrerequisitesForTrucksMotion();
    }

    private void checkPrerequisitesForTrucksMotion() {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.name + " can't move autochanger trucks because controllers are not both initialized:\n";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        this.updatePosition();
        this.checkDeltaPosition();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.", alias="goToHandoff")
    public void goToHandOff() {
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() {
        this.moveToAbsoluteTargetPosition(this.onlinePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() {
        this.moveToAbsoluteTargetPosition(this.standbyPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument. At the end of motion : doesn't align slave then activate brakes and disable controllers.", alias="mobeABSPos", timeout=20000)
    public void moveToAbsoluteTargetPosition(int targetPosition) {
        if (targetPosition < 0 || targetPosition > 1200000) {
            throw new IllegalArgumentException(this.name + "argument has to be between " + 0 + " and " + 1200000);
        }
        this.updatePosition();
        if (this.masterPosition == targetPosition) {
            FCSLOG.info((Object)(this.name + " is already at target position=" + targetPosition));
        } else {
            this.checkConditionsForTrucksMotion();
            this.checkControllersMode();
            this.checkReadyForAction();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
            if (this.absoluteTargetPosition == this.handoffPosition) {
                this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_HANDOFF, FcsEnumerations.FilterReadinessState.NOT_READY);
                this.positionRange = this.positionRangeAtHandoff;
            } else if (this.absoluteTargetPosition == this.standbyPosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
                this.positionRange = this.positionRangeAtStandby;
            } else if (this.absoluteTargetPosition == this.onlinePosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
                this.positionRange = this.positionRangeAtOnline;
            } else if (this.absoluteTargetPosition < this.prelimaryTargetPosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS, FcsEnumerations.FilterReadinessState.NOT_READY});
                this.positionRange = this.positionRangeAtOnline;
            } else {
                if (this.masterPosition > this.absoluteTargetPosition) {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
                } else {
                    this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
                }
                this.positionRange = this.positionRangeInTravel;
            }
            this.goToPosition(this.absoluteTargetPosition);
            this.checkPositionSensors();
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.TRUCKS_STOPPED, FcsEnumerations.FilterReadinessState.READY});
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Move Autochanger trucks to the absolute position given as argument. At the end of motion : doesn't align slave then activate brakes and disable controllers VERY DANGEROUS COMMAND. Only for tests with prototype.", timeout=20000)
    public void moveToAbsoluteTargetPositionDangerous(int targetPosition) {
        if (targetPosition < 0 || targetPosition > 1200000) {
            throw new IllegalArgumentException(this.name + " argument has to be between " + 0 + " and " + 1200000);
        }
        this.updatePosition();
        if (this.masterPosition == targetPosition) {
            FCSLOG.info((Object)(this.name + " is already at target position=" + targetPosition));
        } else {
            this.checkPrerequisitesForTrucksMotion();
            this.checkControllersMode();
            this.checkReadyForAction();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
            if (this.absoluteTargetPosition == this.handoffPosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_HANDOFF, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else if (this.absoluteTargetPosition == this.standbyPosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else if (this.absoluteTargetPosition == this.onlinePosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS, FcsEnumerations.FilterReadinessState.NOT_READY});
            }
            this.goToPosition(this.absoluteTargetPosition);
            this.checkPositionSensors();
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.TRUCKS_STOPPED, FcsEnumerations.FilterReadinessState.READY});
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="goToOnline with filter then adjust position then close and finally lock clamps", autoAck=false, timeout=20000)
    public void moveAndClampFilterOnline() {
        long beginTime = System.currentTimeMillis();
        this.moveToApproachOnlinePositionWithHighVelocity();
        this.alignSlave();
        this.slowProfile();
        this.goToPosition(this.prelimaryTargetPosition);
        double umeasured = this.readProximitySensorDevice();
        int newTargetPosition = (int)((double)this.prelimaryTargetPosition + this.adjustmentFactor * (this.utarget - umeasured));
        FCSLOG.info((Object)(this.name + " new computed target position=" + newTargetPosition));
        newTargetPosition = Math.max(this.minTargetPosition, newTargetPosition);
        FCSLOG.info((Object)(this.name + " new target position=" + newTargetPosition));
        this.goToPosition(newTargetPosition);
        if (!this.autochanger.getOnlineClamps().isHomingDone()) {
            this.autochanger.getOnlineClamps().homing();
        }
        this.autochanger.updateStateWithSensors();
        FCSLOG.info((Object)(this.name + " closing ONLINE clamps"));
        this.autochanger.getOnlineClamps().closeClamps();
        FCSLOG.info((Object)(this.name + " locking ONLINE clamps"));
        this.autochanger.getOnlineClamps().lockClamps();
        umeasured = this.readProximitySensorDevice();
        if (umeasured > this.umax) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too high.");
        } else if (umeasured < this.umin) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too low.");
        }
        this.goToPosition(this.naturalPosition);
        FCSLOG.info((Object)(this.name + " END process docking ONLINE."));
        this.autochanger.updateFCSStateToReady();
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.fine((Object)(this.name + " moveAndClampFilterOnline duration = " + duration));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="move filter to approachPosition with high speed and move to STANDBY with lowSpeed.", autoAck=false, timeout=30000)
    public void moveFilterToStandby() {
        this.updatePosition();
        this.autochanger.updateStateWithSensors();
        this.subs.helper().precondition(new Enum[]{FcsEnumerations.FilterReadinessState.READY}).precondition(this.atHandoff || this.atOnline, "AC should be at Online or Handoff position", new Object[0]).action(() -> {
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
            if (this.atOnline) {
                this.moveToApproachOnlinePositionWithLowVelocity();
            }
            this.alignSlave();
            this.moveToApproachStandbyPositionWithHighVelocity();
            this.moveToStandbyWithLowVelocity();
            this.publishData();
        });
    }

    @Command(type=Command.CommandType.ACTION)
    public void moveToApproachStandbyPositionWithLowVelocity() {
        this.slowProfile();
        this.moveToAbsoluteTargetPosition(this.approachStandbyPosition);
    }

    @Command(type=Command.CommandType.ACTION)
    public void moveToApproachOnlinePositionWithLowVelocity() {
        this.slowProfile();
        this.moveToAbsoluteTargetPosition(this.approachOnlinePosition);
    }

    @Command(type=Command.CommandType.ACTION)
    public void alignSlaveAndMoveEmptyFromApproachToHandoff() {
        this.alignSlave();
        this.fastProfile();
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION)
    public void moveToApproachStandbyPositionWithHighVelocity() {
        this.fastProfile();
        this.moveToAbsoluteTargetPosition(this.approachStandbyPosition);
    }

    @Command(type=Command.CommandType.ACTION)
    public void moveToApproachOnlinePositionWithHighVelocity() {
        this.fastProfile();
        this.moveToAbsoluteTargetPosition(this.approachOnlinePosition);
    }

    @Command(type=Command.CommandType.ACTION)
    public void moveToStandbyWithLowVelocity() {
        this.slowProfile();
        this.moveToAbsoluteTargetPosition(this.standbyPosition);
    }

    @Command(type=Command.CommandType.ACTION)
    public void moveToHandoffWithHighVelocity() {
        this.fastProfile();
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    private void goToPosition(int targetPosition) {
        FCSLOG.info((Object)(this.name + " moving to position " + targetPosition));
        if (!this.isHomingDone()) {
            this.homing();
        }
        this.absoluteTargetPosition = targetPosition;
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, this.timeoutForTrucksMotion);
        this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.TRUCKS_STOPPED, FcsEnumerations.FilterReadinessState.READY});
    }

    private void goToPositionNoBreak(int targetPosition) {
        FCSLOG.info((Object)(this.name + " moving to position " + targetPosition));
        this.absoluteTargetPosition = targetPosition;
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION_NO_BREAK, this.timeoutForTrucksMotion);
        this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.TRUCKS_STOPPED, FcsEnumerations.FilterReadinessState.READY});
    }

    public void moveAndClampFilterOnlineNoBreak() {
        long beginTime = System.currentTimeMillis();
        FCSLOG.info((Object)(this.name + " BEGIN moving filter to ONLINE "));
        this.checkConditionsForTrucksMotion();
        this.checkControllersMode();
        this.checkReadyForAction();
        if (!this.isHomingDone()) {
            this.homing();
        }
        this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.positionRange = this.positionRangeInTravel;
        try {
            this.fastProfile();
            this.goToPosition(this.approachOnlinePosition);
            FcsUtils.sleep(100, this.name);
            this.alignSlave();
            this.slowProfile();
            this.goToPositionNoBreak(this.prelimaryTargetPosition);
            double umeasured = this.readProximitySensorDevice();
            int newTargetPosition = (int)((double)this.prelimaryTargetPosition + this.adjustmentFactor * (this.utarget - umeasured));
            FCSLOG.info((Object)(this.name + " new computed target position=" + newTargetPosition));
            newTargetPosition = Math.max(this.minTargetPosition, newTargetPosition);
            FCSLOG.info((Object)(this.name + " new target position=" + newTargetPosition));
            this.goToPositionNoBreak(newTargetPosition);
            this.autochanger.updateStateWithSensors();
            FCSLOG.info((Object)(this.name + " closing ONLINE clamps"));
            this.autochanger.getOnlineClamps().closeClamps();
            FCSLOG.info((Object)(this.name + " locking ONLINE clamps"));
            this.autochanger.getOnlineClamps().lockClamps();
            umeasured = this.readProximitySensorDevice();
            if (umeasured > this.umax) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too high.");
            } else if (umeasured < this.umin) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too low.");
            }
            this.goToPosition(this.naturalPosition);
        }
        catch (Exception ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " ERROR during moveAndClampFilterOnlineNoBreak", this.name, ex);
            throw new FcsHardwareException(this.name + " ERROR during moveAndClampFilterOnlineNoBreak", ex);
        }
        finally {
            FCSLOG.info((Object)(this.name + " finally in moveAndClampFilterOnlineNoBreak"));
            this.activateBrakesAndDisable();
        }
        FCSLOG.info((Object)(this.name + " END process docking ONLINE."));
        this.autochanger.updateFCSStateToReady();
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.fine((Object)(this.name + " moveFilterFromStandbyToOnline duration = " + duration));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Activate brakes and disable the 2 controllers.")
    public void activateBrakesAndDisable() {
        this.linearRailMasterController.activateBrake();
        this.linearRailSlaveController.activateBrake();
        this.linearRailMasterController.disableOperation();
        this.linearRailSlaveController.disableOperation();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.autochanger.checkLinearRailMotionAllowed();
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: 
            case MOVE_TO_ABSOLUTE_POSITION_NO_BREAK: {
                this.checkControllersMode();
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord(63);
                this.autochanger.increaseLinearRailsCurrentMonitoring();
                break;
            }
            case ALIGN_SLAVE: {
                this.linearRailSlaveController.enableAndReleaseBrake();
                this.linearRailSlaveController.writeTargetPosition(this.slaveTargetPosition);
                this.linearRailSlaveController.writeControlWord(63);
                break;
            }
            case MOVE_SLAVE_TRUCK_ALONE: {
                this.linearRailSlaveController.enableAndReleaseBrake();
                this.linearRailSlaveController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailSlaveController.writeControlWord(63);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.name + " ABORTING action: " + action.toString() + " within delay " + delay));
        if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION || action == FcsEnumerations.MobileItemAction.MOVE_TO_STANDBY_POSITION_WITH_FCS) {
            this.quickStopAction(action, 0L);
            this.activateBrakesAndDisable();
            this.autochanger.decreaseLinearRailsCurrentMonitoring();
        } else if (action == FcsEnumerations.MobileItemAction.ALIGN_SLAVE) {
            this.stopAlignSlave();
        } else {
            this.activateBrakesAndDisable();
        }
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.info((Object)(this.name + " ENDING action: " + action.toString()));
        if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION) {
            this.activateBrakesAndDisable();
            this.autochanger.decreaseLinearRailsCurrentMonitoring();
        } else if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION_NO_BREAK) {
            FCSLOG.info((Object)(this.name + " nothing to do for action MOVE_TO_ABSOLUTE_POSITION_NO_BREAK"));
        } else if (action == FcsEnumerations.MobileItemAction.ALIGN_SLAVE) {
            this.stopAlignSlave();
        } else {
            this.linearRailMasterController.disableOperation();
            this.linearRailSlaveController.disableOperation();
        }
        this.linearRailMasterController.checkFault();
        this.linearRailSlaveController.checkFault();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.linearRailMasterController.quickStop();
        this.linearRailSlaveController.quickStop();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable and release brake for the 2 controllers.")
    public void enableControllersAndReleaseBrake() {
        this.linearRailMasterController.enable();
        this.linearRailSlaveController.enable();
        this.linearRailMasterController.doReleaseBrake();
        if (!this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.name + " can't release Slave Controller brake  because Master Controller is disabled.");
        }
        this.linearRailSlaveController.doReleaseBrake();
    }

    private void checkControllersMode() {
        if (!this.linearRailMasterController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.name + " : linearRailMasterController is not in PROFILE_POSITION mode, can't move.");
        }
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER)) {
            throw new FcsHardwareException(this.name + " : linearRailSlaveController is not in MASTER_ENCODER mode, can't move. Slave controller mode =" + (Object)((Object)this.linearRailSlaveController.getMode()));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Align slave controller position to master controller position.", timeout=20000)
    public void alignSlave() {
        if (this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.name + " master controller must be disabled.");
        }
        this.updatePosition();
        if (!this.isHomingDone()) {
            this.homing();
        }
        if (Math.abs(this.deltaPosition) > this.deltaPositionMax) {
            this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.doAlignSlave(this.masterPosition);
        }
    }

    private void stopAlignSlave() {
        FCSLOG.info((Object)(this.name + " STOP ALIGN SLAVE"));
        this.linearRailSlaveController.activateBrake();
        FcsUtils.sleep(100, this.name);
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        this.linearRailSlaveController.disableOperation();
        FCSLOG.info((Object)(this.name + " END STOP ALIGN SLAVE"));
    }

    private void doAlignSlave(int pos) {
        FCSLOG.info((Object)(this.name + " slave's alignment to be done. deltaPosition= " + this.deltaPosition));
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.name + " can't align slave truck because couldn't change its mode to PROFILE_POSITION.");
        }
        this.slaveTargetPosition = pos;
        this.executeAction(FcsEnumerations.MobileItemAction.ALIGN_SLAVE, this.timeoutForTrucksMotion);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Move truckXminus (slave controller) independently of truckXplus (master controller). To be used with final products AC1 and AC2.Don't use with prototype.")
    public void moveTruckXminus(int newPos) {
        int slavePos = this.linearRailSlaveController.readPosition();
        if (Math.abs(slavePos - newPos) >= 2000) {
            throw new IllegalArgumentException(this.name + " newPos must be such as |newPos - slavePosition| < 2000");
        }
        this.activateBrakesAndDisable();
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.absoluteTargetPosition = newPos;
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_SLAVE_TRUCK_ALONE, this.timeoutForTrucksMotion);
    }

    public void checkPositionSensors() {
        this.autochanger.updateStateWithSensors();
        if (this.absoluteTargetPosition == this.standbyPosition && !this.atStandby) {
            throw new FailedCommandException(this.name + ": check with sensors: STANDBY sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.atHandoff) {
            FCSLOG.info((Object)("this.absoluteTargetPosition=" + this.absoluteTargetPosition));
            FCSLOG.info((Object)("this.handoffPosition=" + this.handoffPosition));
            FCSLOG.info((Object)("this.atHandoff=" + this.atHandoff));
            throw new FailedCommandException(this.name + ": check with sensors: HANDOFF sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.onlinePosition && !this.atOnline) {
            throw new FailedCommandException(this.name + ": check with sensors: ONLINE sensors don't confirm trucks position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Do homing for both  controllers.")
    public void homing() {
        this.linearRailMasterController.homing();
        this.linearRailSlaveController.homing();
        this.updatePosition();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() {
        this.masterPosition = this.linearRailMasterController.readPosition();
        this.slavePosition = this.linearRailSlaveController.readPosition();
        this.deltaPosition = this.masterPosition - this.slavePosition;
        this.truckXminus.updatePosition();
        this.truckXplus.updatePosition();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read position on controllers then compute difference and throw exceptionif difference is > 1000.")
    public void checkDeltaPosition() {
        this.updatePosition();
        if (Math.abs(this.deltaPosition) > 1000) {
            String msg = "Too much difference between trucks position. Alignment of Slave Truck to be done.";
            throw new FcsHardwareException(this.name + ":" + msg);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update trucks position in reading controller and return position.")
    public int readPosition() {
        this.updatePosition();
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return a voltage in mV which represents a distance between between filterand filter beam.")
    public double readProximitySensorDevice() {
        return this.proximitySensorsDevice.readVoltage(this.proximitySensorInput);
    }

    @Override
    public boolean myDevicesReady() {
        return this.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: 
            case MOVE_TO_ABSOLUTE_POSITION_NO_BREAK: {
                FCSLOG.finest((Object)(this.name + " linearRailMasterController.isTargetReached()=" + this.linearRailMasterController.isTargetReached() + " /masterPosition=" + this.masterPosition + " /absoluteTargetPosition=" + this.absoluteTargetPosition));
                return Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
            case ALIGN_SLAVE: {
                return this.linearRailSlaveController.isTargetReached() && Math.abs(this.deltaPosition) < this.deltaPositionMax;
            }
            case MOVE_SLAVE_TRUCK_ALONE: {
                return this.linearRailMasterController.isTargetReached() && Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.updatePosition();
            FCSLOG.finest((Object)(this.name + " position=" + this.masterPosition));
            this.autochanger.updateStateWithSensors();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "=> ERROR IN READING CONTROLLERS:", this.name, ex);
        }
    }

    synchronized void updateState() {
        this.atHandoff = this.truckXminus.isAtHandoff() && this.truckXplus.isAtHandoff();
        this.atOnline = this.truckXminus.isAtOnline() && this.truckXplus.isAtOnline();
        this.atStandby = this.truckXminus.isAtStandby() && this.truckXplus.isAtStandby();
        this.updatePosition();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity parameter to lowSpeed and slowProfileAcceleration and slowProfileDeceleration")
    public void slowProfile() {
        this.slowProfileVelocity();
        this.slowProfileAcceleration();
        this.slowProfileDeceleration();
        this.checkProfileVelocity();
        this.checkProfileAcceleration();
        this.checkProfileDeceleration();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity and ProfileAcceleration and ProfileDeceleration parameters to highSpeed")
    public void fastProfile() {
        this.raiseProfileVelocity();
        this.raiseProfileAcceleration();
        this.raiseProfileDeceleration();
        this.checkProfileVelocity();
        this.checkProfileAcceleration();
        this.checkProfileDeceleration();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity parameter to lowSpeed and slowProfileAcceleration and slowProfileDeceleration")
    public void slowProfileVelocity() {
        this.profileVelocity = this.lowSpeed;
        this.linearRailMasterController.changeProfileVelocity(this.lowSpeed);
        this.linearRailSlaveController.changeProfileVelocity(this.lowSpeed);
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.lowSpeed));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileVelocity and ProfileAcceleration and ProfileDeceleration parameters to highSpeed")
    public void raiseProfileVelocity() {
        this.profileVelocity = this.highSpeed;
        this.linearRailMasterController.changeProfileVelocity(this.highSpeed);
        this.linearRailSlaveController.changeProfileVelocity(this.highSpeed);
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.highSpeed));
    }

    private void checkProfileVelocity() {
        int masterV;
        int slaveV = this.linearRailSlaveController.readVelocity();
        if (slaveV != (masterV = this.linearRailMasterController.readVelocity())) {
            throw new FcsHardwareException(this.name + " master and slave ProfileVelocity are not the same.");
        }
    }

    private void checkProfileAcceleration() {
        long masterV;
        long slaveV = this.linearRailSlaveController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration);
        if (slaveV != (masterV = this.linearRailMasterController.readParameter(EPOSEnumerations.Parameter.ProfileAcceleration))) {
            throw new FcsHardwareException(this.name + " master and slave ProfileAcceleration are not the same.");
        }
    }

    private void checkProfileDeceleration() {
        long masterV;
        long slaveV = this.linearRailSlaveController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration);
        if (slaveV != (masterV = this.linearRailMasterController.readParameter(EPOSEnumerations.Parameter.ProfileDeceleration))) {
            throw new FcsHardwareException(this.name + " master and slave ProfileDeceleration are not the same.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileAcceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.highAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileAcceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.lowAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileDeceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.highDeceleration));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileDeceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.lowDeceleration));
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    public StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks() {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setMasterPosition(this.masterPosition);
        s.setSlavePosition(this.slavePosition);
        s.setCurrent(this.current);
        s.setSpeed(this.speed);
        s.setProfileVelocity(this.profileVelocity);
        s.setHomingDone(this.isHomingDone());
        s.setAtHandoff(this.atHandoff);
        s.setAtOnline(this.atOnline);
        s.setAtStandby(this.atStandby);
        s.setInError(this.isPositionSensorsInError());
        return s;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByAutoChangerTrucks()));
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.linearRailMasterController.isBooted() && this.linearRailSlaveController.isBooted()) {
            this.activateBrakesAndDisable();
        }
        FCSLOG.info((Object)(this.name + " is shutdown."));
    }
}

