/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenTTC580;
import org.lsst.ccs.subsystems.fcs.simulation.AutochangerTruckPositionListener;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;

public class SimuTTC580
extends CanOpenTTC580
implements AutochangerTruckPositionListener {
    CarouselSocket socket1;
    CarouselSocket socket2;
    CarouselSocket socket3;
    CarouselSocket socket4;
    CarouselSocket socket5;
    protected final Map<String, CarouselSocket> socketMapByID = new HashMap<String, CarouselSocket>();

    public SimuTTC580(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.socket1 = (CarouselSocket)lookup.getComponentByPath("socket1");
        this.socket2 = (CarouselSocket)lookup.getComponentByPath("socket2");
        this.socket3 = (CarouselSocket)lookup.getComponentByPath("socket3");
        this.socket4 = (CarouselSocket)lookup.getComponentByPath("socket4");
        this.socket5 = (CarouselSocket)lookup.getComponentByPath("socket5");
        this.socketMapByID.put("1", this.socket1);
        this.socketMapByID.put("2", this.socket2);
        this.socketMapByID.put("3", this.socket3);
        this.socketMapByID.put("4", this.socket4);
        this.socketMapByID.put("5", this.socket5);
    }

    @Override
    public void initializeAndCheckHardware() {
        super.initializeAndCheckHardware();
        this.updateFakePDOData(this.cobid1, 0L);
        this.updateFakePDOData(this.cobid2, (long)Math.pow(2.0, 59.0));
    }

    public void updateFakePDOData(int cobid, long newPdo) {
        if (cobid == this.cobid1) {
            this.pdo1 = newPdo;
        } else if (cobid == this.cobid2) {
            this.pdo2 = newPdo;
        }
        ((SimuCanOpenInterface)this.tcpProxy.getCanInterface()).simulatePDOData(cobid, newPdo);
    }

    private static void checkID(short id) {
        if (id < 1 || id > 5) {
            throw new IllegalArgumentException(id + " not a valid socket number");
        }
    }

    private static void checkSensorValue(int value) {
        if (value > 4095) {
            throw new IllegalArgumentException(value + " value can't be > " + 4095);
        }
    }

    public void simulateSocketAtStandby(short socketID) {
        System.out.println("simulate socket at STANDBY: " + socketID);
        SimuTTC580.checkID(socketID);
        long sock = (long)socketID << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateSocketNotAtStandby(short id) {
        System.out.println("simulate socket NOT at STANDBY: " + id);
        SimuTTC580.checkID(id);
        long sock = (long)id << 61;
        long mask = 0x1FFFFFFFFFFFFFFFL;
        long newpdo = sock | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateSlaveStatus(short slaveStatus) {
        System.out.println("simulate SlaveStatus: " + slaveStatus);
        long status = (long)slaveStatus << 58;
        long mask = -2017612633061982209L;
        long newpdo = status | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateSlaveStatusNotAtS(short slaveStatus) {
        long status = (long)slaveStatus << 58;
        long mask = -2017612633061982209L;
        long newpdo = status | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simuSocketAtSLocked(short id) {
        this.simulateSocketAtStandby(id);
        CarouselSocket socket = this.socketMapByID.get(Integer.toString(id));
        this.simulateClampIsLocked(socket.getClampXminus());
        this.simulateClampIsLocked(socket.getClampXplus());
    }

    public void simulateLockSensorXminusValue(long lockValue) {
        System.out.println("lockValue=" + Long.toBinaryString(lockValue));
        long pdo = lockValue << 36;
        long mask = -281406257233921L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateLockSensorXminusValueNotAtS(long lockValue) {
        System.out.println("lockValue=" + Long.toBinaryString(lockValue));
        long pdo = lockValue << 36;
        long mask = -281406257233921L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateFilterPresenceXminusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 24;
        long mask = -68702699521L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateFilterPresenceXminusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 24;
        long mask = -68702699521L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateLockSensorXplusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 12;
        long mask = -16773121L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateLockSensorXplusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue << 12;
        long mask = -16773121L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateFilterPresenceXplusValue(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue & 0xFFFL;
        long mask = -4096L;
        long newpdo = pdo | this.pdo1 & mask;
        System.out.println("newpdo1=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid1, newpdo);
    }

    public void simulateFilterPresenceXplusValueNotAtS(long newValue) {
        System.out.println("lockValue=" + Long.toBinaryString(newValue));
        long pdo = newValue & 0xFFFL;
        long mask = -4096L;
        long newpdo = pdo | this.pdo2 & mask;
        System.out.println("newpdo2=" + Long.toBinaryString(newpdo));
        this.updateFakePDOData(this.cobid2, newpdo);
    }

    public void simulateClampIsLocked(CarouselClamp clamp) {
        int lockVal = clamp.getLockSensorMaxValue() / 4;
        this.simulateClampLockValue(clamp, lockVal);
    }

    public void simulateClampIsLockedNotAtS(CarouselClamp clamp) {
        int lockVal = (clamp.getLockSensorValueB() + clamp.getLockSensorMaxValue()) / 8;
        this.simulateClampLockValueNotAtS(clamp, lockVal);
    }

    public void simulateClampIsUnlocked(CarouselClamp clamp) {
        int lockVal = clamp.getLockSensorValueA() / 4 - 10;
        this.simulateClampLockValue(clamp, lockVal);
    }

    private void simulateClampLockValue(CarouselClamp clamp, int lockVal) {
        SimuTTC580.checkSensorValue(lockVal);
        if (clamp.getName().contains("Xminus")) {
            this.simulateLockSensorXminusValue(lockVal);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateLockSensorXplusValue(lockVal);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    private void simulateClampLockValueNotAtS(CarouselClamp clamp, int lockVal) {
        SimuTTC580.checkSensorValue(lockVal);
        if (clamp.getName().contains("Xminus")) {
            this.simulateLockSensorXminusValueNotAtS(lockVal);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateLockSensorXplusValueNotAtS(lockVal);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    public void simulateClampFilterIsLockable(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceOffset1() + clamp.getFilterPresenceOffset2()) / 8;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    public void simulateClampFilterIsLockableNotAtS(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceOffset1() + clamp.getFilterPresenceOffset2()) / 8;
        this.simulateClampFilterPresenceValueNotAtS(clamp, val);
    }

    public void simulateClampFilterIsNotLockable(CarouselClamp clamp) {
        int val = (clamp.getFilterPresenceOffset2() + clamp.getFilterPresenceValueB()) / 8;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    public void simulateClampNoFilter(CarouselClamp clamp) {
        int val = clamp.getFilterPresenceValueB() / 4 + 1;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    public void simulateClampFilterIsInError(CarouselClamp clamp) {
        int val = clamp.getFilterPresenceOffset1() / 4 - 1;
        this.simulateClampFilterPresenceValue(clamp, val);
    }

    private void simulateClampFilterPresenceValue(CarouselClamp clamp, int val) {
        SimuTTC580.checkSensorValue(val);
        if (clamp.getName().contains("Xminus")) {
            this.simulateFilterPresenceXminusValue(val);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateFilterPresenceXplusValue(val);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    private void simulateClampFilterPresenceValueNotAtS(CarouselClamp clamp, int val) {
        SimuTTC580.checkSensorValue(val);
        if (clamp.getName().contains("Xminus")) {
            this.simulateFilterPresenceXminusValueNotAtS(val);
        } else if (clamp.getName().contains("Xplus")) {
            this.simulateFilterPresenceXplusValueNotAtS(val);
        } else {
            throw new IllegalArgumentException(clamp.getName() + " illegal value. Should contain Xminus or Xplus");
        }
    }

    @Override
    public void onTruckPositionChange(int newPos) {
        this.socketMapByID.values().stream().forEach(socket -> {
            if (socket.isAtStandby()) {
                System.out.println("################## SOCKET AT STANDBY #####################" + socket.getName());
                this.updateSocketFromACTrucksPosition((CarouselSocket)socket, newPos);
            }
        });
    }

    private void updateSocketFromACTrucksPosition(CarouselSocket socket, int newPos) {
        int acTrucksStandbyPosition = 992000;
        if (newPos < acTrucksStandbyPosition - 1000) {
            this.simulateClampNoFilter(socket.getClampXminus());
            this.simulateClampNoFilter(socket.getClampXplus());
        } else {
            this.simulateClampFilterIsLockable(socket.getClampXminus());
            this.simulateClampFilterIsLockable(socket.getClampXplus());
        }
    }
}

