/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class Inclinometer
implements SensorPluggedOnDevice,
AlertRaiser {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupName
    private String name = "unset";
    @ConfigurationParameter
    private int byteNumero;
    @ConfigurationParameter
    private String deviceName;
    private double inclinaison;
    private double voltage;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    public void updateValue(int newValue) {
        FCSCst.FCSLOG.fine((Object)(this.name + " updating inclinaison with newValue read on gateway (unit=0,1Volt): " + newValue));
        this.voltage = newValue;
        this.inclinaison = this.convertVoltage2Degree(this.voltage);
        if (newValue < 0 || newValue > 50) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, newValue + ": bad value read on inclinometer. Value read has to be between 0 and 50 (unit = 0,1Volts).", this.getName());
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns inclinaison value in degrees. Doesn't read again CANopen device.")
    public double getInclinaison() {
        return this.inclinaison;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return raw voltage read on AC PlutoGateway unit=0.1Volt")
    public double getVoltage() {
        return this.voltage;
    }

    private double convertVoltage2Degree(double voltage) {
        double voltageInVolt = voltage / 10.0;
        double sin_angle = (voltageInVolt - 2.5) / 11.52;
        return Math.toDegrees(Math.asin(sin_angle));
    }

    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)Double.valueOf(this.inclinaison)));
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }
}

