/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.common.TTC580Interface;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Carousel
extends MobileItem
implements HardwareController,
FilterHolder,
AlertRaiser {
    private static final long serialVersionUID = -2376279469784152348L;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @ConfigurationParameter(range="0..500000", description="in milliseconds; if rotation lasts more than rotationTimeout, rotation is halted and the subsystem goes in error state.")
    private int rotationTimeout = 20000;
    protected int position = 0;
    private int relativeTargetPosition;
    protected int absoluteTargetPosition;
    @ConfigurationParameter
    protected int deltaPosition = 1000;
    private int velocity = 0;
    private int current = 0;
    private final int fullTurn = 4362240;
    private final int halfTurn = 2181120;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXminusController")
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXplusController")
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*carouselController")
    private EPOSControllerForCarousel carouselController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*hyttc580")
    private TTC580Interface hyttc580;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*ai814")
    protected PieceOfHardware ai814;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, CarouselSocket> socketsMap = new TreeMap<String, CarouselSocket>();
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="tcpProxy")
    protected BridgeToHardware tcpProxy;
    private boolean initialized = false;
    private boolean clampsStateInitialized = false;
    private boolean homingDone = false;
    private int socketAtStandbyID;
    private CarouselSocket socketAtStandby;

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name + "-publishData", this::publishData).withIsFixedRate(true).withLogLevel(Level.WARNING).withPeriod(Duration.ofSeconds(1L)));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if CANopen devices are booted and initialized and homing has been done.")
    boolean isInitialized() {
        return this.myDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if clamp state is initialized for all clamps.")
    public boolean isClampsStateInitialized() {
        return this.clampsStateInitialized;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if carouselController homing is done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    public int getFullTurn() {
        return 4362240;
    }

    public Map<String, CarouselSocket> getSocketsMap() {
        return this.socketsMap;
    }

    public CarouselSocket getSocketByName(String socketName) {
        if (this.socketsMap.containsKey(socketName)) {
            return this.socketsMap.get(socketName);
        }
        throw new IllegalArgumentException(this.name + ": no such name for socket:" + socketName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return carousel position.", alias="printPosition")
    public int getPosition() {
        return this.position;
    }

    public EPOSController getClampXminusController() {
        return this.clampXminusController;
    }

    public EPOSController getClampXplusController() {
        return this.clampXplusController;
    }

    public CarouselClamp getClampXminus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXminus();
    }

    public CarouselClamp getClampXplus() {
        if (this.socketAtStandby == null) {
            return null;
        }
        return this.socketAtStandby.getClampXplus();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a socket is HALTED at STANDBY position, false otherwise.")
    public boolean isAtStandby() {
        return this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5;
    }

    public CarouselSocket getSocketAtStandby() {
        return this.socketAtStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="return ID of socket at STANDBY")
    public int getSocketAtStandbyID() {
        return this.socketAtStandbyID;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns name of filter at STANDBY position  or NO_FILTER if there is no filter at STANDBY.")
    public String getFilterAtStandbyName() {
        if (this.socketAtStandby == null) {
            return "NO FILTER";
        }
        return this.socketAtStandby.getFilterName();
    }

    public boolean isFilterOnCarousel(int filterID) {
        return this.socketsMap.values().stream().anyMatch(socket -> socket.getFilterID() == filterID);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To change filterID on socket which ID is given as argument.")
    public void changeFilterID(int filterID, int socketID) {
        if (socketID < 1 || socketID > 5) {
            throw new IllegalArgumentException(socketID + ": bad value - enter a digit between 1 and 5");
        }
        if (this.isFilterOnCarousel(filterID)) {
            int sockID = this.getFilterSocket(filterID).getId();
            throw new IllegalArgumentException(filterID + " filter already on carousel on socket" + sockID);
        }
        String socketName = "socket" + socketID;
        this.socketsMap.get(socketName).setFilterID(filterID);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if Autochanger is holding filter at STANDBY.")
    public boolean isAutochangerHoldingFilter() {
        this.autochanger.updateStateWithSensors();
        return this.autochanger.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize carousel hardware after initialization. To be executed if during boot process some hardware is missing.")
    public void initializeHardware() {
        this.tcpProxy.bootProcess();
        this.postStart();
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.carouselController.isBooted()) {
            this.initializeRotationController();
        }
        if (this.clampXminusController.isBooted()) {
            this.initializeClampController(this.clampXminusController);
        }
        if (this.clampXplusController.isBooted()) {
            this.initializeClampController(this.clampXplusController);
        }
        try {
            this.initializeClampsState();
        }
        catch (DriverException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initiliaze clamps state.", this.name, (Exception)((Object)ex));
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeRotationController() {
        try {
            this.carouselController.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.carouselController.getName(), (Exception)ex);
        }
    }

    private void initializeClampController(EPOSController controller) {
        try {
            controller.initializeAndCheckHardware();
            if (!controller.isInMode(EPOSEnumerations.EposMode.CURRENT)) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "  is not in CURRENT mode.", controller.getName());
            }
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller ", controller.getName(), (Exception)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="CarouselHoming")
    public void homing() {
        this.homingDone = false;
        this.carouselController.disableOperation();
        FcsUtils.sleep(100, this.name);
        this.carouselController.disableVoltage();
        FcsUtils.sleep(100, this.name);
        this.carouselController.setPositionSensorTypeEncoderSSI();
        int ssiPosition = this.carouselController.readSSIPosition();
        this.carouselController.setPositionSensorTypeSinusIncrementalEncoder();
        this.carouselController.enable();
        this.carouselController.defineAbsolutePosition(ssiPosition);
        this.homingDone = true;
        this.carouselController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.carouselController.disableOperation();
        this.updatePosition();
        this.publishData();
    }

    private void checkHomingDone() {
        if (!this.isHomingDone()) {
            throw new FcsHardwareException(this.name + " homing has to be done before motion.");
        }
    }

    public void checkSensorTypeIncremental() {
        int sensorType = this.carouselController.readPositionSensorType();
        if (sensorType != 8) {
            throw new FcsHardwareException(this.name + " PositionSensorType has to be set to Incremental Encoder before motion.");
        }
    }

    @Override
    public void publishData() {
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData("carousel", (Serializable)this.createStatusDataPublishedByCarousel()));
    }

    public StatusDataPublishedByCarousel createStatusDataPublishedByCarousel() {
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel();
        status.setPosition(this.position);
        status.setCurrent((double)this.current);
        status.setVelocity((double)this.velocity);
        status.setHomingDone(this.homingDone);
        status.setAtStandby(this.isAtStandby());
        status.setSocketAtStandbyID(this.socketAtStandbyID);
        status.setFilterAtStandbyName(this.getFilterAtStandbyName());
        if (this.isAtStandby()) {
            status.setSocketAtStandbyName(this.socketAtStandby.getName());
        } else if (this.socketAtStandbyID == 0) {
            status.setSocketAtStandbyName("NO_SOCKET_AT_STANDBY");
        } else if (this.socketAtStandbyID == 7) {
            status.setSocketAtStandbyName("ERROR_READING_ID");
        }
        return status;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if Carousel is stopped and no filter is at STANDBY position")
    public boolean isReadyToGrabAFilterAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        if (this.socketAtStandby == null) {
            return false;
        }
        return this.socketAtStandby.isEmpty() && this.socketAtStandby.isReadyToClamp();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if a filter is clamped at STANDBY position")
    public boolean isHoldingFilterAtStandby() {
        if (this.isRotating()) {
            return false;
        }
        if (this.socketAtStandby == null || this.socketAtStandby.isEmpty()) {
            return false;
        }
        return this.socketAtStandby.isClampedOnFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if carousel is rotating.")
    public boolean isRotating() {
        return this.isMoving();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update carousel position in reading controller.")
    public void updatePosition() {
        if (this.homingDone) {
            try {
                this.position = this.carouselController.readPosition();
            }
            catch (SDORequestException ex) {
                FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
            }
        } else {
            throw new RejectedCommandException("Carousel homing not done : do carousel homing before updatePosition.");
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update field current in reading controller.")
    public void updateCurrent() {
        try {
            this.current = this.carouselController.readCurrent();
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)(this.name + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    public void updateClampsStateWithSensorsFromPDO() {
        this.tcpProxy.updatePDOData();
        PDOData pdoStore = this.tcpProxy.getPDOData();
        FCSLOG.finest((Object)(this.name + ":pdoStore=" + pdoStore.toString()));
        this.socketsMap.values().stream().forEach(socket -> socket.updateState());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamps state in sending 5 sync.")
    public void initializeClampsState() throws DriverException {
        FCSLOG.info((Object)(this.name + " Initializing clamps state...."));
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        for (int count = 1; count <= 5; count = (int)((byte)(count + 1))) {
            FCSLOG.info((Object)(this.name + " sync no " + count));
            this.tcpProxy.updatePDOData();
            this.hyttc580.updateFromPDO(this.tcpProxy.getPDOData());
            this.updateState();
        }
        this.clampsStateInitialized = true;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp offsets.")
    public void initializeAndCheckClampsOffset() {
        FCSLOG.info((Object)(this.name + " Initializing clamps offsets...."));
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        this.socketsMap.values().stream().forEach(socket -> {
            byte socketId = (byte)socket.getId();
            long offset2 = this.hyttc580.readOffset2SDO(socketId);
            socket.checkAndUpdateOffset2(offset2);
        });
        this.publishData();
    }

    public CarouselSocket getFilterSocket(int filterID) {
        CarouselSocket socket = null;
        for (CarouselSocket sock : this.socketsMap.values()) {
            if (sock.getFilterID() != filterID) continue;
            return sock;
        }
        return socket;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release clamps at standby position to get ready to clamp again")
    public void releaseClamps() {
        this.updateStateWithSensors();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't release clamps when no socket is halted at standby position.");
        }
        this.socketAtStandby.releaseClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamps at STANDBY.")
    public void unlockClamps() {
        this.updateStateWithSensors();
        if (this.socketAtStandby == null) {
            throw new RejectedCommandException(this.name + " can't unlock clamps while a socket is not halted at standby position.");
        }
        FCSLOG.info((Object)"Unlocking clamps at standby.");
        this.socketAtStandby.unlockClamps();
    }

    public boolean isAtStandby(int filterID) {
        return this.socketAtStandby.getFilterID() != 0 && this.socketAtStandby.getFilterID() == filterID;
    }

    public void releaseClampsContact() {
    }

    @Override
    public boolean myDevicesReady() {
        return this.carouselController.isBooted() && this.carouselController.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if carousel rotation is permitted.")
    public void checkConditionsForRotation() {
        if (!this.initialized) {
            throw new FcsHardwareException("Carousel hardware is not initialized. Can't rotate.");
        }
        if (this.isAtStandby() && this.socketAtStandby.isUnclampedOnFilter()) {
            String message = "Filter at STANDBY position is not held by clamps. Can't rotate carousel.";
            FCSLOG.error((Object)message);
            throw new RejectedCommandException(message);
        }
        if (!this.autochanger.isAtHandoff()) {
            throw new RejectedCommandException(this.name + " can't rotate if autochanger is not at HANDOFF position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Rotate carousel to a new absolute position.", timeout=60000)
    public void rotateToAbsolutePosition(int newPos) {
        if (Math.abs(newPos - this.position) < this.deltaPosition) {
            throw new RejectedCommandException(this.name + " is already at position " + newPos);
        }
        this.carouselController.checkInitialized();
        this.carouselController.checkFault();
        if (!this.autochanger.isAtHandoff() && !this.autochanger.isAtOnline()) {
            throw new RejectedCommandException(this.name + " can rotate only if autochanger is at Handoff or at Online  " + newPos);
        }
        this.homing();
        this.checkHomingDone();
        int diffPos = newPos - this.position;
        this.absoluteTargetPosition = Math.abs(newPos - this.position) <= 2181120 ? newPos : (diffPos < 0 ? newPos + 4362240 : newPos - 4362240);
        FCSLOG.info((Object)(this.name + " is at position: " + this.position + "; about to rotate to absolute position: " + this.absoluteTargetPosition));
        this.executeAction(FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION, this.rotationTimeout);
        ((AgentStateService)this.s.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)"CAROUSEL_STOPPED"), FcsEnumerations.FilterReadinessState.READY});
        this.homing();
        this.checkHomingDone();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a socket which name is given as argument to STANDBY position.", alias="moveSocketToStandby", timeout=50000)
    public void rotateSocketToStandby(String socketName) {
        FcsUtils.checkSocketName(socketName);
        CarouselSocket socketToMove = this.socketsMap.get(socketName);
        if (socketToMove.isAtStandby()) {
            throw new RejectedCommandException(this.name + ": " + socketName + " is already at STANDBY.");
        }
        int requiredPosition = socketToMove.getStandbyPosition();
        if (this.position != requiredPosition) {
            FCSLOG.info((Object)(this.name + " is at position: " + this.position + "; about to rotate to position: " + requiredPosition));
            this.rotateToAbsolutePosition(requiredPosition);
        }
        FCSLOG.info((Object)(this.name + ":" + socketName + " is at STANDBY position on carousel."));
    }

    public void rotateEmptySocketAtStandby() {
        for (Map.Entry<String, CarouselSocket> entry : this.socketsMap.entrySet()) {
            CarouselSocket socket = entry.getValue();
            if (!socket.isEmpty()) continue;
            this.rotateSocketToStandby(entry.getKey());
            return;
        }
        FCSLOG.error((Object)"no empty socket on carousel - nothing to do.");
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            return this.carouselController.isTargetReached();
        }
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            FCSLOG.info((Object)(this.name + " => Checking for carousel position to complete action -  CurrentCarousel Position = " + this.position + " Target Position = " + this.absoluteTargetPosition + " Delta Position expected = " + this.deltaPosition));
            return Math.abs(this.position - this.absoluteTargetPosition) < this.deltaPosition;
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        FCSLOG.debug((Object)(this.name + " position=" + this.position));
        this.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        ((AgentStateService)this.s.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)"ROTATING"), FcsEnumerations.FilterReadinessState.NOT_READY});
        if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_RELATIVE_POSITION.equals((Object)action)) {
            this.carouselController.enableAndWriteRelativePosition(this.relativeTargetPosition);
        } else if (FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals((Object)action)) {
            this.carouselController.enable();
            FcsUtils.sleep(250, this.name);
            this.carouselController.writeTargetPosition(this.absoluteTargetPosition);
            this.carouselController.writeControlWord(63);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException ex) {
            FCSLOG.warning((Object)ex);
        }
        this.carouselController.stopPosition();
        this.carouselController.disableOperation();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException ex) {
            FCSLOG.warning((Object)ex);
        }
        this.carouselController.stopPosition();
        this.carouselController.disableOperation();
        this.updateStateWithSensors();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.carouselController.stopPosition();
        this.carouselController.disableOperation();
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isNotHoldingFilter() {
        return !this.isHoldingFilterAtStandby();
    }

    @Override
    public boolean isAtHandoff() {
        return false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the ID of filter at STANDBY")
    public int getFilterID() {
        return this.socketAtStandby.getFilterID();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read sensors and update state", timeout=2000)
    public void updateStateWithSensors() {
        long beginTime = System.currentTimeMillis();
        if (!this.clampsStateInitialized) {
            throw new FcsHardwareException(this.name + ": clamps state not initialized.  Please launch command initializeClampsState.");
        }
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        this.tcpProxy.updatePDOData();
        this.updateState();
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateStateWithSensors duration = " + duration));
        this.publishData();
    }

    @Override
    public boolean isAtOnline() {
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update socket at standby state from hyttc580 data.", timeout=2000)
    public void updateSocketAtStandbyWithSensors() {
        long beginTime = System.currentTimeMillis();
        this.hyttc580.checkBooted();
        this.hyttc580.checkInitialized();
        this.tcpProxy.updatePDOData();
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " hyttc580.updateFromPDO(tcpProxy.updatePDOData()) duration = " + duration));
        this.updateSocketAtStandbyState();
        duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateStateWithSensorsAtStandby duration = " + duration));
    }

    public void updateSocketAtStandbyState() {
        long beginTime = System.currentTimeMillis();
        this.socketAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo1());
        if (this.socketAtStandbyID >= 1 && this.socketAtStandbyID <= 5) {
            this.socketAtStandby = this.socketsMap.get("socket" + this.socketAtStandbyID);
            this.socketAtStandby.updateState();
            this.socketAtStandby.getClampXminus().setAtStandby(true);
            this.socketAtStandby.getClampXplus().setAtStandby(true);
            this.socketAtStandby.updateFilterID();
        } else {
            this.socketAtStandby = null;
        }
        this.publishData();
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateSocketAtStandbyState duration = " + duration));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update state from hyttc580 data.", timeout=2000)
    public void updateState() {
        long beginTime = System.currentTimeMillis();
        this.updateSocketAtStandbyState();
        this.position = this.carouselController.getPosition();
        this.current = this.carouselController.getCurrent();
        this.velocity = this.carouselController.getVelocity();
        this.subs.getScheduler().schedule(() -> this.updateSocketNotAtStandby(), 0L, TimeUnit.SECONDS);
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateState duration = " + duration));
    }

    public void updateSocketNotAtStandby() {
        long beginTime = System.currentTimeMillis();
        short socketNotAtStandbyID = this.hyttc580.getSocketId(this.hyttc580.getPdo2());
        if (socketNotAtStandbyID >= 1 && socketNotAtStandbyID <= 5) {
            CarouselSocket socketToUpdate = this.socketsMap.get("socket" + socketNotAtStandbyID);
            socketToUpdate.updateState();
            socketToUpdate.getClampXminus().setAtStandby(false);
            socketToUpdate.getClampXplus().setAtStandby(false);
        }
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.info((Object)(this.name + " updateSocketNotAtStandby duration = " + duration));
    }
}

