/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.TimeUnit;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerThreeOnlineClampsProto
extends AutochangerThreeOnlineClamps {
    public AutochangerThreeOnlineClampsProto(AutochangerOnlineClamp onlineClampXminus, AutochangerOnlineClamp onlineClampXplus, AutochangerOnlineClamp onlineClampYminus) {
        super(onlineClampXminus, onlineClampXplus, onlineClampYminus);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=0, description="Unlock and open the online clamps.", timeout=15000)
    public void unlockAndOpenClamps() {
        this.updateStateAndCheckSensors();
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.enableAndCheckControllersBeforeAction(FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS);
        if (this.isLocked()) {
            this.autochanger.checkOnlineClampMotionAllowed();
            this.currentAction = FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS;
            long beginTime = System.currentTimeMillis();
            this.doUnlock();
            this.updateStateAndCheckSensors();
            if (!this.isClosed()) {
                throw new FailedCommandException(this.name + "couldn't unlock clamps");
            }
            this.onlineClampYminus.openClampInCurrentMode();
            this.openClampsXInCurrentMode();
            this.updateStateAndCheckSensors();
            this.activateBrakesAndDisableOperation();
            if (!this.isOpened()) {
                throw new FailedCommandException(this.name + "couldn't open clamps");
            }
            long dur = System.currentTimeMillis() - beginTime;
            FCSLOG.fine((Object)(this.name + " unlockAndOpenClamps duration = " + dur));
        } else if (this.isOpened()) {
            FCSLOG.info((Object)(this.name + " clamps already UNLOCKED and OPENED - nothing to do"));
        } else {
            throw new RejectedCommandException(this.name + " has to be LOCKED before unlockAndOpen action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Closes and locks the online clamps.", timeout=15000)
    public void closeAndLockClampsInModeCurrent() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            long beginTime = System.currentTimeMillis();
            this.onlineClampYminus.closeClampInCurrentMode();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS_MODE_CURRENT, this.timeoutForLockingClamps);
            long dur = System.currentTimeMillis() - beginTime;
            FCSLOG.fine((Object)(this.name + " closeAndLockClamps duration = " + dur));
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.name + " is already LOCKED - nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be OPENED before a closeAndLockClamps");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the 3 online clamps.", timeout=15000)
    public void closeClampsInModeCurrent() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            this.onlineClampYminus.closeClampInCurrentMode();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS_MODE_CURRENT, this.timeoutForLockingClamps);
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " clamps already CLOSED nothing to do"));
        } else {
            throw new RejectedCommandException(this.name + " has to be unlocked before.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="close clamps X", timeout=15000)
    public void closeClampsXInModeCurrent() {
        this.checkParametersToCloseClampsX();
        this.currentAction = FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS;
        this.onlineClampXminus.enableAndCheckControllerBeforeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS);
        this.onlineClampXminus.getController().doReleaseBrake();
        this.onlineClampXplus.enableAndCheckControllerBeforeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS);
        this.onlineClampXplus.getController().doReleaseBrake();
        this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.onlineClampXminus.getInitialCurrentToClose());
        this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.onlineClampXplus.getInitialCurrentToClose());
        FcsUtils.sleep(this.onlineClampXminus.getWaitTimeToClose(), this.name);
        this.executeCurrentRampToCloseClampsX();
        this.updateStateAndCheckSensors();
        this.onlineClampXminus.getController().activateBrake();
        this.onlineClampXplus.getController().activateBrake();
        this.onlineClampXminus.getController().writeCurrent(0);
        this.onlineClampXplus.getController().writeCurrent(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the 3 online clamps with a small pressure.", timeout=15000)
    public void openClampsInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (!this.isClosed()) {
            if (this.isOpened()) {
                FCSLOG.info((Object)(this.name + " clamps already OPENED. Nothing to do."));
                throw new RejectedCommandException(this.name + " clamps already OPENED. Nothing to do.");
            }
            throw new RejectedCommandException(this.name + " has to be closed before.");
        }
        this.checkReadyForAction();
        this.checkParametersToOpenClampsX();
        this.currentAction = FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPS_MODE_CURRENT;
        this.onlineClampYminus.openClampInCurrentMode();
        this.openClampsXInCurrentMode();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="open clampXs. for proto only.", timeout=15000)
    public void openClampsXInCurrentMode() {
        this.checkParametersToOpenClampsX();
        this.currentAction = FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX_MODE_CURRENT;
        this.onlineClampXminus.enableAndCheckControllerBeforeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX_MODE_CURRENT);
        this.onlineClampXplus.enableAndCheckControllerBeforeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX_MODE_CURRENT);
        this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.onlineClampXminus.getFinalCurrentToClose());
        this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.onlineClampXplus.getFinalCurrentToClose());
        FcsUtils.sleep(500, this.name);
        this.onlineClampXminus.getController().doReleaseBrake();
        this.onlineClampXplus.getController().doReleaseBrake();
        this.executeAction(this.currentAction, this.timeoutForUnlockingClamps);
    }

    private void executeCurrentRampToCloseClampsX() {
        this.writeCurrentRampToCloseClampsX();
        this.waitForEndOfCurrentRamp(this.timeoutForLockingClamps);
    }

    private void executeCurrentRampToOpenClampsX() {
        FCSLOG.info((Object)(this.name + " executeCurrentRampToOpenClampsX"));
        this.writeCurrentRampToOpenClampsX();
        this.waitForEndOfCurrentRamp(this.timeoutForUnlockingClamps);
    }

    private void writeCurrentRampToCloseClampsX() {
        this.writeCurrentRampToClampsX(this.onlineClampXminus.getInitialCurrentToClose(), this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getIncrementCurrentToClose(), this.onlineClampXplus.getInitialCurrentToClose(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getIncrementCurrentToClose(), this.maxTimeToCloseClampsX);
    }

    private void writeCurrentRampToOpenClampsX() {
        FCSLOG.info((Object)(this.name + " writeCurrentRampToOpenClampsX"));
        this.writeCurrentRampToClampsX(this.onlineClampXminus.getFinalCurrentToClose(), this.onlineClampXminus.getCurrentToOpen(), this.onlineClampXminus.getIncrementCurrentToOpen(), this.onlineClampXplus.getFinalCurrentToClose(), this.onlineClampXplus.getCurrentToOpen(), this.onlineClampXplus.getIncrementCurrentToOpen(), this.maxTimeToOpenClampsX);
    }

    private void writeCurrentRampToClampsX(final int initialValueXminus, final int finalValueXminus, int incrementCurrentXminus, final int initialValueXplus, final int finalValueXplus, int incrementCurrentXplus, int maxTime) {
        final int stepHeightXminus = FcsUtils.getSignedStepHeight(initialValueXminus, finalValueXminus, incrementCurrentXminus);
        final int stepHeightXplus = FcsUtils.getSignedStepHeight(initialValueXplus, finalValueXplus, incrementCurrentXplus);
        int nbStepXminus = Math.abs((finalValueXminus - initialValueXminus) / incrementCurrentXminus);
        int nbStepXplus = Math.abs((finalValueXplus - initialValueXplus) / incrementCurrentXplus);
        int period = maxTime / Math.min(nbStepXminus, nbStepXplus);
        FCSLOG.finest((Object)"############################################################");
        FCSLOG.finest((Object)("initialValue for clampXminus=" + initialValueXminus));
        FCSLOG.finest((Object)("finalValue for clampXminus=" + finalValueXminus));
        FCSLOG.finest((Object)("initialValue for clampXplus=" + initialValueXplus));
        FCSLOG.finest((Object)("finalValue for clampXplus=" + finalValueXplus));
        FCSLOG.finest((Object)("period=" + period));
        FCSLOG.finest((Object)("nbStepXminus=" + nbStepXminus));
        FCSLOG.finest((Object)("stepHeightXplus=" + stepHeightXplus));
        FCSLOG.finest((Object)("nbStepXminus=" + nbStepXminus));
        FCSLOG.finest((Object)("nbStepXplus=" + nbStepXplus));
        FCSLOG.finest((Object)"############################################################");
        Runnable currentRamp = new Runnable(){
            private int newCurrentValueXminus;
            private int newCurrentValueXplus;
            private boolean finalValueReachedXminus;
            private boolean finalValueReachedXplus;
            {
                this.newCurrentValueXminus = initialValueXminus;
                this.newCurrentValueXplus = initialValueXplus;
                this.finalValueReachedXminus = false;
                this.finalValueReachedXplus = false;
            }

            @Override
            public void run() {
                this.newCurrentValueXminus = FcsUtils.computeNewCurrentValue(stepHeightXminus, this.newCurrentValueXminus, finalValueXminus);
                this.newCurrentValueXplus = FcsUtils.computeNewCurrentValue(stepHeightXplus, this.newCurrentValueXplus, finalValueXplus);
                try {
                    if (!this.finalValueReachedXminus) {
                        AutochangerThreeOnlineClampsProto.this.onlineClampXminus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXminus);
                    }
                    if (!this.finalValueReachedXplus) {
                        AutochangerThreeOnlineClampsProto.this.onlineClampXplus.sendCurrentToControllerAndSaveValue(this.newCurrentValueXplus);
                    }
                    this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                }
                catch (Throwable throwable) {
                    this.finalValueReachedXminus = this.newCurrentValueXminus == finalValueXminus;
                    this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                    throw throwable;
                }
                this.finalValueReachedXplus = this.newCurrentValueXplus == finalValueXplus;
                if (this.finalValueReachedXminus && this.finalValueReachedXplus) {
                    AutochangerThreeOnlineClampsProto.this.cancelCurrentRamp();
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.enableAndCheckControllersBeforeAction(action);
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.autochanger.checkOnlineClampMotionAllowed();
        this.autochanger.increaseCurrentMonitoring();
        if (action == FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS) {
            this.closeClamps();
            this.doLock();
        } else if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPS_MODE_CURRENT) {
            this.closeClampsXInModeCurrent();
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_AND_OPEN_ONLINECLAMPS) {
            this.openClampsXInCurrentMode();
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            this.doUnlock();
        } else if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            this.doLock();
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().enableAndReleaseBrake();
            this.onlineClampXplus.getController().enableAndReleaseBrake();
            this.onlineClampXminus.getController().writeTargetPosition(this.onlineClampXminus.getTargetPositionToOpen());
            this.onlineClampXplus.getController().writeTargetPosition(this.onlineClampXplus.getTargetPositionToOpen());
            this.onlineClampXminus.getController().writeControlWord(63);
            this.onlineClampXplus.getController().writeControlWord(63);
        } else if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().enableAndReleaseBrake();
            this.onlineClampXplus.getController().enableAndReleaseBrake();
            this.onlineClampXminus.getController().writeTargetPosition(this.onlineClampXminus.getTargetPositionToClose());
            this.onlineClampXplus.getController().writeTargetPosition(this.onlineClampXplus.getTargetPositionToClose());
            this.onlineClampXminus.getController().writeControlWord(63);
            this.onlineClampXplus.getController().writeControlWord(63);
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX_MODE_CURRENT) {
            this.executeCurrentRampToOpenClampsX();
        } else if (action == FcsEnumerations.MobileItemAction.CLOSE_AND_LOCK_ONLINECLAMPS_MODE_CURRENT) {
            this.closeClampsXInModeCurrent();
            this.doLock();
        } else {
            throw new IllegalArgumentException(this.name + " invalid action:" + action);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.autochanger.decreaseCurrentMonitoring();
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX_MODE_CURRENT) {
            this.onlineClampXminus.getController().activateBrake();
            this.onlineClampXplus.getController().activateBrake();
            this.onlineClampXminus.getController().writeCurrent(0);
            this.onlineClampXplus.getController().writeCurrent(0);
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMPSX || action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMPSX) {
            this.onlineClampXminus.getController().stopAction();
            this.onlineClampXplus.getController().stopAction();
            this.onlineClampXminus.getController().activateBrake();
            this.onlineClampXplus.getController().activateBrake();
        } else {
            this.activateBrakesAndDisableOperation();
        }
    }
}

