
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.MobileItemAction;
import static org.lsst.ccs.subsystems.fcs.FcsEnumerations.MobileItemAction.ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION;

/**
 *
 * @author virieux
 */
public class SimuCarousel extends Carousel {

    @Override
    public boolean isActionCompleted(MobileItemAction action) {
        int simuAbsTargetPos = this.absoluteTargetPosition % this.getFullTurn();
        if (ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION.equals(action)) {
            FCSLOG.info(name + " => Checking for carousel position to complete action - "
                    + " CurrentCarousel Position = " + this.position + " Target Position = "
                    + this.absoluteTargetPosition + " Delta Position expected = " + deltaPosition);
            return Math.abs(this.position - simuAbsTargetPos) < deltaPosition;
        }
        return false;
    }

}
